/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.math.BigDecimal;
import javax.naming.InitialContext;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.interfaces.ServerHome;
import org.compiere.model.MClient;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class DocumentEngine
implements DocAction {
    private DocAction m_document;
    private String m_status = "DR";
    private String m_message = null;
    private String m_action = null;
    private static String EXCEPTION_MSG = "Document Engine is no Document";

    public DocumentEngine(DocAction po) {
        this(po, "DR");
    }

    public DocumentEngine(DocAction po, String docStatus) {
        this.m_document = po;
        if (docStatus != null) {
            this.m_status = docStatus;
        }
    }

    public String getDocStatus() {
        return this.m_status;
    }

    public void setDocStatus(String ignored) {
    }

    public boolean isDrafted() {
        return "DR".equals(this.m_status);
    }

    public boolean isInvalid() {
        return "IN".equals(this.m_status);
    }

    public boolean isInProgress() {
        return "IP".equals(this.m_status);
    }

    public boolean isApproved() {
        return "AP".equals(this.m_status);
    }

    public boolean isNotApproved() {
        return "NA".equals(this.m_status);
    }

    public boolean isWaiting() {
        return "WP".equals(this.m_status) || "WC".equals(this.m_status);
    }

    public boolean isCompleted() {
        return "CO".equals(this.m_status);
    }

    public boolean isReversed() {
        return "RE".equals(this.m_status);
    }

    public boolean isClosed() {
        return "CL".equals(this.m_status);
    }

    public boolean isVoided() {
        return "VO".equals(this.m_status);
    }

    public boolean isUnknown() {
        return "??".equals(this.m_status) || !this.isDrafted() && !this.isInvalid() && !this.isInProgress() && !this.isNotApproved() && !this.isApproved() && !this.isWaiting() && !this.isCompleted() && !this.isReversed() && !this.isClosed() && !this.isVoided();
    }

    public boolean processIt(String processAction, String docAction) {
        this.m_message = null;
        this.m_action = null;
        if (this.isValidAction(processAction)) {
            this.m_action = processAction;
        } else if (this.isValidAction(docAction)) {
            this.m_action = docAction;
        } else {
            if (processAction.equals("--") || docAction.equals("--")) {
                if (this.m_document != null) {
                    this.m_document.get_Logger().info("**** No Action (Prc=" + processAction + "/Doc=" + docAction + ") " + this.m_document);
                }
                return true;
            }
            throw new IllegalStateException("Status=" + this.getDocStatus() + " - Invalid Actions: Process=" + processAction + ", Doc=" + docAction);
        }
        if (this.m_document != null) {
            this.m_document.get_Logger().info("**** Action=" + this.m_action + " (Prc=" + processAction + "/Doc=" + docAction + ") " + this.m_document);
        }
        boolean success = this.processIt(this.m_action);
        if (this.m_document != null) {
            this.m_document.get_Logger().fine("**** Action=" + this.m_action + " - Success=" + success);
        }
        return success;
    }

    public boolean processIt(String action) {
        this.m_message = null;
        this.m_action = action;
        if ("XL".equals(this.m_action)) {
            return this.unlockIt();
        }
        if ("IN".equals(this.m_action)) {
            return this.invalidateIt();
        }
        if ("PR".equals(this.m_action)) {
            return "IP".equals(this.prepareIt());
        }
        if ("AP".equals(this.m_action)) {
            return this.approveIt();
        }
        if ("RJ".equals(this.m_action)) {
            return this.rejectIt();
        }
        if ("CO".equals(this.m_action) || "WC".equals(this.m_action)) {
            String status = null;
            if ((this.isDrafted() || this.isInvalid()) && !"IP".equals(status = this.prepareIt())) {
                return false;
            }
            status = this.completeIt();
            if (this.m_document != null && !Ini.isClient()) {
                MClient client = MClient.get(this.m_document.getCtx(), this.m_document.getAD_Client_ID());
                if ("CO".equals(status) && client.isPostImmediate()) {
                    this.m_document.save();
                    this.postIt();
                }
            }
            return "CO".equals(status) || "IP".equals(status) || "WP".equals(status) || "WC".equals(status);
        }
        if ("RE".equals(this.m_action)) {
            return this.reActivateIt();
        }
        if ("RA".equals(this.m_action)) {
            return this.reverseAccrualIt();
        }
        if ("RC".equals(this.m_action)) {
            return this.reverseCorrectIt();
        }
        if ("CL".equals(this.m_action)) {
            return this.closeIt();
        }
        if ("VO".equals(this.m_action)) {
            return this.voidIt();
        }
        if ("PO".equals(this.m_action)) {
            return this.postIt();
        }
        return false;
    }

    public boolean unlockIt() {
        if (!this.isValidAction("XL")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.unlockIt()) {
                this.m_status = "DR";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "DR";
        return true;
    }

    public boolean invalidateIt() {
        if (!this.isValidAction("IN")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.invalidateIt()) {
                this.m_status = "IN";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IN";
        return true;
    }

    public String prepareIt() {
        if (!this.isValidAction("PR")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.prepareIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    public boolean approveIt() {
        if (!this.isValidAction("AP")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.approveIt()) {
                this.m_status = "AP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "AP";
        return true;
    }

    public boolean rejectIt() {
        if (!this.isValidAction("RJ")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.rejectIt()) {
                this.m_status = "NA";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "NA";
        return true;
    }

    public String completeIt() {
        if (!this.isValidAction("CO")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.completeIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    public boolean postIt() {
        if (!this.isValidAction("PO") || this.m_document == null) {
            return false;
        }
        try {
            InitialContext ctx = CConnection.get().getInitialContext(true);
            ServerHome serverHome = (ServerHome)ctx.lookup("compiere/Server");
            if (serverHome != null) {
                Server server = serverHome.create();
                if (server != null) {
                    String error = server.postImmediate(Env.getCtx(), this.m_document.getAD_Client_ID(), this.m_document.get_Table_ID(), this.m_document.get_ID(), true, this.m_document.get_TrxName());
                    this.m_document.get_Logger().config("Server: " + error == null ? "OK" : error);
                    return error == null;
                }
            } else {
                this.m_document.get_Logger().config("NoServerHome");
            }
        }
        catch (Exception e) {
            this.m_document.get_Logger().config("(ex) " + e.getMessage());
        }
        return false;
    }

    public boolean voidIt() {
        if (!this.isValidAction("VO")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.voidIt()) {
                this.m_status = "VO";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "VO";
        return true;
    }

    public boolean closeIt() {
        if (!(this.m_document != null && this.m_document.get_Table_ID() == 259 || this.isValidAction("CL"))) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.closeIt()) {
                this.m_status = "CL";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "CL";
        return true;
    }

    public boolean reverseCorrectIt() {
        if (!this.isValidAction("RC")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseCorrectIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    public boolean reverseAccrualIt() {
        if (!this.isValidAction("RA")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseAccrualIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    public boolean reActivateIt() {
        if (!this.isValidAction("RE")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reActivateIt()) {
                this.m_status = "IP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IP";
        return true;
    }

    void setStatus(String newStatus) {
        this.m_status = newStatus;
    }

    public String[] getActionOptions() {
        if (this.isInvalid()) {
            return new String[]{"PR", "IN", "XL", "VO"};
        }
        if (this.isDrafted()) {
            return new String[]{"PR", "IN", "CO", "XL", "VO"};
        }
        if (this.isInProgress() || this.isApproved()) {
            return new String[]{"CO", "WC", "AP", "RJ", "XL", "VO", "PR"};
        }
        if (this.isNotApproved()) {
            return new String[]{"RJ", "PR", "XL", "VO"};
        }
        if (this.isWaiting()) {
            return new String[]{"CO", "WC", "RE", "VO", "CL"};
        }
        if (this.isCompleted()) {
            return new String[]{"CL", "RE", "RA", "RC", "PO", "VO"};
        }
        if (this.isClosed()) {
            return new String[]{"PO", "OP"};
        }
        if (this.isReversed() || this.isVoided()) {
            return new String[]{"PO"};
        }
        return new String[0];
    }

    public boolean isValidAction(String action) {
        String[] options = this.getActionOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(action)) continue;
            return true;
        }
        return false;
    }

    public String getProcessMsg() {
        return this.m_message;
    }

    public void setProcessMsg(String msg) {
        this.m_message = msg;
    }

    public String getSummary() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public String getDocumentNo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public String getDocumentInfo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int getDoc_User_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int getC_Currency_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public BigDecimal getApprovalAmt() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int getAD_Client_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int getAD_Org_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public String getDocAction() {
        return this.m_action;
    }

    public boolean save() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public Ctx getCtx() {
        if (this.m_document != null) {
            return this.m_document.getCtx();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int get_ID() {
        if (this.m_document != null) {
            return this.m_document.get_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public int get_Table_ID() {
        if (this.m_document != null) {
            return this.m_document.get_Table_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public CLogger get_Logger() {
        if (this.m_document != null) {
            return this.m_document.get_Logger();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    public String get_TrxName() {
        return null;
    }

    public File createPDF() {
        return null;
    }
}

