/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.JTextComponent;
import org.compiere.plaf.CompiereComboBoxUI;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompiereTheme;
import org.compiere.swing.CEditor;
import org.compiere.util.NamePair;
import org.compiere.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CComboBox
extends JComboBox
implements CEditor {
    public static int FIELD_HIGHT = 30;
    public static final String AUTO_REDUCIBLE_PROPERTY = "autoReducible";
    public static final String CASE_SENSITIVE_PROPERTY = "caseSensitive";
    ReducibleModel m_reducibleModel;
    private ReducibleKeyListener reducibleKeyListener = new ReducibleKeyListener();
    private static JTextField s_text = new JTextField(15);
    private Icon m_icon = null;
    private boolean m_mandatory = false;

    public CComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    public CComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public CComboBox(Object[] items, String key) {
        this(items);
        if (key == null) {
            return;
        }
        for (int i = 0; i < 0; ++i) {
            Object item = items[i];
            if (item == null) continue;
            boolean found = false;
            found = item instanceof NamePair ? ((NamePair)item).getID().equals(key) : item.toString().equals(key);
            if (!found) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public CComboBox(Vector<?> items) {
        super(items);
        this.init();
    }

    public CComboBox() {
        this.init();
    }

    private void init() {
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
        this.setFont(CompierePLAF.getFont_Field());
        this.setForeground(CompierePLAF.getTextColor_Normal());
        this.setBackground(false);
        this.setPreferredSize(s_text.getPreferredSize());
        this.setEditable(true);
        this.setAutoReducible(true);
        FIELD_HIGHT = this.getPreferredSize().height;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me) && CComboBox.this.isAutoReducible()) {
                    CComboBox.this.updateReducibleModel(false);
                }
            }
        });
        final JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        textComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                if (CComboBox.this.isEditable()) {
                    textComponent.selectAll();
                }
                textComponent.repaint();
            }

            public void focusLost(FocusEvent fe) {
                if (CComboBox.this.isAutoReducible()) {
                    Object item = CComboBox.this.m_reducibleModel.getSelectedItem();
                    Object object = item = item == null && CComboBox.this.m_reducibleModel.getSize() != 0 ? CComboBox.this.m_reducibleModel.getElementAt(0) : item;
                    if (item == null) {
                        CComboBox.this.updateReducibleModel(false);
                        if (CComboBox.this.m_reducibleModel.getSize() != 0) {
                            item = CComboBox.this.m_reducibleModel.getElementAt(0);
                        } else {
                            return;
                        }
                    }
                    CComboBox.this.m_reducibleModel.setSelectedItem(item);
                }
                textComponent.setCaretPosition(0);
                CComboBox.this.hidePopup();
                textComponent.repaint();
            }
        });
        textComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me) && CComboBox.this.isAutoReducible() && !CComboBox.this.isPopupVisible()) {
                    CComboBox.this.updateReducibleModel(false);
                    CComboBox.this.showPopup();
                }
            }
        });
    }

    public void setIcon(Icon defaultIcon) {
        if (this.getUI() instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(defaultIcon);
        }
        this.m_icon = defaultIcon;
    }

    public ComboBoxModel getCompleteComboBoxModel() {
        return this.m_reducibleModel.getModel();
    }

    public void setModel(ComboBoxModel aModel) {
        this.m_reducibleModel = this.m_reducibleModel == null ? new ReducibleModel() : this.m_reducibleModel;
        this.m_reducibleModel.setModel(aModel);
        super.setModel(this.m_reducibleModel);
    }

    @Override
    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
        if (this.m_icon != null && ui instanceof CompiereComboBoxUI) {
            ((CompiereComboBoxUI)this.getUI()).setIcon(this.m_icon);
        }
    }

    public boolean displayPopup() {
        return true;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.isEnabled();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(CompierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(CompierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(CompierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(CompierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.getEditor() != null) {
            this.getEditor().getEditorComponent().setBackground(bg);
        }
        super.setBackground(bg);
    }

    public void setOpaqueAll(boolean isOpaque) {
        Component cc;
        super.setOpaque(isOpaque);
        ComboBoxEditor cbe = this.getEditor();
        if (cbe != null && (cc = cbe.getEditorComponent()) instanceof JTextField) {
            ((JTextField)cc).setOpaque(isOpaque);
        }
    }

    @Override
    public void setValue(Object value) {
        super.setSelectedItem(value);
    }

    @Override
    public Object getValue() {
        return super.getSelectedItem();
    }

    @Override
    public String getDisplay() {
        Object o = super.getSelectedItem();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        JButton b;
        super.addMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && !Trace.getCallerClass(1).startsWith("javax") && (b = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        JButton b;
        super.removeMouseListener(ml);
        if (this.getUI() instanceof CompiereComboBoxUI && (b = ((CompiereComboBoxUI)this.getUI()).getArrowButton()) != null) {
            b.removeMouseListener(ml);
        }
    }

    @Override
    public void setActionCommand(String actionCommand) {
        super.setActionCommand(actionCommand);
        if (this.getName() == null && actionCommand != null && actionCommand.length() > 0) {
            this.setName(actionCommand);
        }
    }

    protected boolean isMatchingFilter(Object element) {
        String str = element != null ? element.toString().trim() : "";
        str = this.isCaseSensitive() ? str : str.toLowerCase();
        return str.indexOf(this.m_reducibleModel.getMatchingFilter()) > -1;
    }

    public boolean isAutoReducible() {
        Boolean b = (Boolean)this.getClientProperty(AUTO_REDUCIBLE_PROPERTY);
        return b != null && b != false;
    }

    public void setAutoReducible(boolean autoreducible) {
        if (this.isAutoReducible() != autoreducible) {
            this.putClientProperty(AUTO_REDUCIBLE_PROPERTY, autoreducible);
            this.updateReducibleModel(false);
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            if (autoreducible) {
                textComponent.addKeyListener(this.reducibleKeyListener);
            } else {
                textComponent.removeKeyListener(this.reducibleKeyListener);
            }
        }
    }

    public boolean isCaseSensitive() {
        Boolean b = (Boolean)this.getClientProperty(CASE_SENSITIVE_PROPERTY);
        return b != null && b != false;
    }

    @Override
    public void removeAllItems() {
        this.m_reducibleModel.removeAllElements();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.putClientProperty(CASE_SENSITIVE_PROPERTY, caseSensitive);
    }

    void updateReducibleModel(boolean filtering) {
        if (filtering || this.m_reducibleModel.getSize() != this.m_reducibleModel.getModel().getSize()) {
            if (this.getParent() != null) {
                this.hidePopup();
            }
            JTextComponent textComponent = (JTextComponent)this.getEditor().getEditorComponent();
            int pos = textComponent.getCaretPosition();
            this.m_reducibleModel.setFilter(textComponent.getText());
            this.m_reducibleModel.updateModel(filtering);
            textComponent.setText(this.m_reducibleModel.getFilter());
            textComponent.setCaretPosition(pos);
            if (this.getParent() != null) {
                this.getParent().validate();
                this.getParent().repaint();
                if (this.isShowing() && this.m_reducibleModel.getSize() > 0) {
                    this.showPopup();
                }
            }
        }
    }

    public static void main(String[] args) {
        CompiereTheme.load();
        CompierePLAF.setPLAF(null);
        JFrame f = new JFrame("CComboBox");
        Container cp = f.getContentPane();
        cp.setLayout(new BorderLayout());
        CComboBox list = new CComboBox(new String[]{"A", "B", "C"});
        cp.add((Component)list, "Center");
        cp.add((Component)new JLabel("---n---"), "North");
        cp.add((Component)new JLabel("---S---"), "South");
        cp.add((Component)new JLabel("|"), "East");
        cp.add((Component)new JLabel("|"), "West");
        f.pack();
        f.setVisible(true);
    }

    class ReducibleKeyListener
    extends KeyAdapter {
        private Runnable m_invoker = new Runnable(){

            public void run() {
                CComboBox.this.updateReducibleModel(true);
            }
        };
        private Runnable m_updateMenu = new Runnable(){

            public void run() {
                CComboBox.this.hidePopup();
                CComboBox.this.getParent().validate();
                CComboBox.this.getParent().repaint();
                CComboBox.this.showPopup();
            }
        };

        ReducibleKeyListener() {
        }

        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() != 17 && ke.getKeyCode() != 18 && ke.getKeyCode() != 16 && (ke.getModifiersEx() & 0x200) == 0) {
                if (ke.getKeyCode() == 10 || ke.getKeyCode() == 9) {
                    Object selObject = CComboBox.this.getSelectedItem();
                    selObject = selObject == null && CComboBox.this.getItemCount() > 0 ? CComboBox.this.getItemAt(0) : selObject;
                    CComboBox.this.setSelectedItem(selObject);
                    CComboBox.this.getEditor().setItem(CComboBox.this.getSelectedItem());
                } else if (ke.getKeyCode() == 27) {
                    FocusManager.getCurrentManager().upFocusCycle();
                } else if (ke.getKeyCode() == 38 || ke.getKeyCode() == 224 || ke.getKeyCode() == 40 || ke.getKeyCode() == 225) {
                    SwingUtilities.invokeLater(this.m_updateMenu);
                } else {
                    SwingUtilities.invokeLater(this.m_invoker);
                    CComboBox.this.setSelectedItem(null);
                }
            }
        }
    }

    private class ReducibleModel
    implements MutableComboBoxModel,
    ListDataListener {
        private ComboBoxModel m_model;
        private EventListenerList m_listenerList = new EventListenerList();
        private ArrayList<Object> m_visibleData = new ArrayList();
        private ArrayList<Object> m_modelData = new ArrayList();
        private String m_filter = "";
        private String m_lcFilter = "";

        public void addElement(Object anObject) {
            this.checkMutableComboBoxModel();
            this.m_modelData.add(anObject);
            ((MutableComboBoxModel)this.m_model).addElement(anObject);
        }

        public void addListDataListener(ListDataListener ldl) {
            this.m_listenerList.remove(ListDataListener.class, ldl);
            this.m_listenerList.add(ListDataListener.class, ldl);
        }

        void checkMutableComboBoxModel() {
            if (!(this.m_model instanceof MutableComboBoxModel)) {
                throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
            }
        }

        public void contentsChanged(ListDataEvent lde) {
            this.updateDataModel();
            this.updateModel(false);
            if (CComboBox.this.isPopupVisible()) {
                CComboBox.this.hidePopup();
                CComboBox.this.showPopup();
            }
        }

        private void fireContentsChanged() {
            ListDataEvent lde = null;
            for (ListDataListener ldl : this.getListDataListeners()) {
                lde = lde == null ? new ListDataEvent(this, 0, 0, this.getSize()) : lde;
                ldl.contentsChanged(lde);
            }
        }

        public Object getElementAt(int index) {
            return this.m_visibleData.get(index);
        }

        public String getFilter() {
            return this.m_filter;
        }

        public ListDataListener[] getListDataListeners() {
            return (ListDataListener[])this.m_listenerList.getListeners(ListDataListener.class);
        }

        protected String getMatchingFilter() {
            return CComboBox.this.isCaseSensitive() ? this.m_filter : this.m_lcFilter;
        }

        public ComboBoxModel getModel() {
            return this.m_model;
        }

        public Object getSelectedItem() {
            return this.m_model.getSelectedItem();
        }

        public int getSize() {
            return this.m_visibleData.size();
        }

        public void insertElementAt(Object anObject, int index) {
            this.checkMutableComboBoxModel();
            this.m_modelData.add(index, anObject);
            ((MutableComboBoxModel)this.m_model).insertElementAt(anObject, index);
        }

        public void intervalAdded(ListDataEvent lde) {
            this.updateDataModel();
            this.updateModel(false);
        }

        public void intervalRemoved(ListDataEvent lde) {
            this.updateDataModel();
            this.updateModel(false);
        }

        public void removeAllElements() {
            this.checkMutableComboBoxModel();
            ListDataListener[] listeners = this.getListDataListeners();
            for (int i = 0; i < listeners.length; ++i) {
                this.removeListDataListener(listeners[i]);
            }
            this.m_model.removeListDataListener(this);
            this.m_modelData.clear();
            this.m_visibleData.clear();
            while (this.m_model.getSize() > 0) {
                ((MutableComboBoxModel)this.m_model).removeElementAt(0);
            }
            for (ListDataListener ldl : listeners) {
                this.addListDataListener(ldl);
            }
            this.m_model.addListDataListener(this);
            this.updateModel(false);
        }

        public void removeElement(Object anObject) {
            this.checkMutableComboBoxModel();
            this.m_modelData.remove(anObject);
            this.m_visibleData.clear();
            ((MutableComboBoxModel)this.m_model).removeElement(anObject);
        }

        public void removeElementAt(int index) {
            this.checkMutableComboBoxModel();
            this.m_modelData.remove(index);
            this.m_visibleData.clear();
            ((MutableComboBoxModel)this.m_model).removeElementAt(index);
        }

        public void removeListDataListener(ListDataListener ldl) {
            this.m_listenerList.remove(ListDataListener.class, ldl);
        }

        public void setFilter(String filter) {
            this.m_filter = filter != null ? filter : "";
            this.m_lcFilter = filter.trim().toLowerCase();
        }

        public void setModel(ComboBoxModel model) {
            if (this.m_model != null) {
                this.m_model.removeListDataListener(this);
            }
            this.m_model = model;
            this.updateDataModel();
            this.m_filter = "";
            model.addListDataListener(this);
            this.updateModel(false);
        }

        public void setSelectedItem(Object anObject) {
            if (anObject == null || this.m_modelData.contains(anObject)) {
                this.m_model.setSelectedItem(anObject);
            }
        }

        public void updateDataModel() {
            this.m_modelData.clear();
            int size = this.m_model.getSize();
            for (int i = 0; i < size; ++i) {
                this.m_modelData.add(this.m_model.getElementAt(i));
            }
        }

        public void updateModel(boolean filtering) {
            boolean includeAll;
            boolean bl = includeAll = !filtering || !CComboBox.this.isAutoReducible() || "".equals(this.m_lcFilter);
            if (includeAll) {
                this.m_visibleData.clear();
                this.m_visibleData.addAll(this.m_modelData);
            } else {
                this.m_visibleData.clear();
                Object selected = this.getSelectedItem();
                ListDataListener[] listeners = this.getListDataListeners();
                for (int i = 0; i < listeners.length; ++i) {
                    this.removeListDataListener(listeners[i]);
                }
                this.m_model.removeListDataListener(this);
                int size = this.m_model.getSize();
                for (int i = 0; i < size; ++i) {
                    Object element = this.m_model.getElementAt(i);
                    if (element != null && !CComboBox.this.isMatchingFilter(element)) continue;
                    this.m_visibleData.add(element);
                }
                if (this.m_visibleData.contains(selected) || selected == null) {
                    this.setSelectedItem(selected);
                }
                for (ListDataListener ldl : listeners) {
                    this.addListDataListener(ldl);
                }
                this.m_model.addListDataListener(this);
            }
            this.fireContentsChanged();
        }
    }
}

