/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.compiere.plaf.CompiereRowHeaderUI;
import org.compiere.swing.CButton;

public class CRowHeader
extends JList {
    private FastListModel m_listModel = new FastListModel();
    protected JTable m_table;
    private int m_width;
    private int m_rowCount = -1;
    CButton m_button = new CButton();
    TableModelListener tableModelListener = new TableModelListener(){

        public void tableChanged(TableModelEvent tme) {
            CRowHeader.this.updateRowModel();
        }
    };
    private PropertyChangeListener modelChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ((TableModel)evt.getOldValue()).removeTableModelListener(CRowHeader.this.tableModelListener);
            ((TableModel)evt.getNewValue()).addTableModelListener(CRowHeader.this.tableModelListener);
            CRowHeader.this.updateRowModel();
        }
    };

    public CRowHeader() {
        this.setModel(this.m_listModel);
        this.setUI(new CompiereRowHeaderUI());
        for (MouseMotionListener mouseMotionListener : this.getMouseMotionListeners()) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        for (EventListener eventListener : this.getMouseListeners()) {
            this.removeMouseListener((MouseListener)eventListener);
        }
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        ListCellRenderer renderer = new ListCellRenderer(){
            Dimension prefSize = new Dimension();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CRowHeader.this.m_button.setText(value.toString());
                CRowHeader.this.m_button.setFont(list.getFont());
                this.prefSize.width = CRowHeader.this.computeWidth();
                this.prefSize.height = CRowHeader.this.m_table.getRowHeight(index);
                CRowHeader.this.m_button.setPreferredSize(this.prefSize);
                return CRowHeader.this.m_button;
            }
        };
        this.setCellRenderer(renderer);
    }

    public CRowHeader(JTable table) {
        this();
        this.setTable(table);
    }

    int computeWidth() {
        int tableCount = this.m_table.getRowCount();
        if (tableCount == this.m_rowCount) {
            return this.m_width;
        }
        this.m_rowCount = tableCount;
        FontMetrics fm = this.m_table.getFontMetrics(this.m_table.getFont());
        String rowCountStr = Integer.toString(this.m_rowCount * 10);
        this.m_width = SwingUtilities.computeStringWidth(fm, rowCountStr);
        return this.m_width;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        d.width = this.m_table != null && this.m_table.getRowCount() > 0 ? d.width : this.computeWidth();
        return d;
    }

    public JTable getTable() {
        return this.m_table;
    }

    public void setTable(JTable table) {
        if (this.m_table != null) {
            this.m_table.getModel().removeTableModelListener(this.tableModelListener);
            this.m_table.removePropertyChangeListener("model", this.modelChangeListener);
        }
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.getModel().addTableModelListener(this.tableModelListener);
            this.m_table.addPropertyChangeListener("model", this.modelChangeListener);
            this.setFont(table.getFont());
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.updateRowModel();
            table.getModel().addTableModelListener(this.tableModelListener);
            table.addPropertyChangeListener("model", this.modelChangeListener);
        }
    }

    void updateRowModel() {
        int listRows;
        int tableRows = this.m_table.getRowCount();
        if (tableRows == (listRows = this.m_listModel.getSize())) {
            return;
        }
        if (listRows > tableRows) {
            this.m_listModel.clear();
        }
        for (int i = this.m_listModel.getSize(); i < tableRows; ++i) {
            this.m_listModel.add(Integer.toString(i + 1));
        }
        this.m_listModel.fireContentsChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FastListModel
    extends ArrayList<String>
    implements ListModel {
        private EventListenerList m_listenerList = new EventListenerList();
        private ListDataEvent m_listDataEvent = new ListDataEvent(this, 0, 0, this.getSize());

        FastListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener ldl) {
            this.m_listenerList.remove(ListDataListener.class, ldl);
            this.m_listenerList.add(ListDataListener.class, ldl);
        }

        public void fireContentsChanged() {
            for (ListDataListener ldl : (ListDataListener[])this.m_listenerList.getListeners(ListDataListener.class)) {
                ldl.contentsChanged(this.m_listDataEvent);
            }
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public void removeListDataListener(ListDataListener ldl) {
            this.m_listenerList.remove(ListDataListener.class, ldl);
        }
    }
}

