/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.compiere.common.FieldType;
import org.compiere.util.CLogger;
import org.compiere.util.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DisplayType
extends FieldType {
    private static final int MAX_DIGITS = 28;
    private static final int INTEGER_DIGITS = 10;
    private static final int MAX_FRACTION = 12;
    private static final int AMOUNT_FRACTION = 2;
    private static CLogger s_log = CLogger.getCLogger(DisplayType.class);

    public static DecimalFormat getNumberFormat(int displayType, Language language) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Language.getLoginLanguage();
        }
        Locale locale = myLanguage.getLocale();
        DecimalFormat format = null;
        format = locale != null ? (DecimalFormat)NumberFormat.getNumberInstance(locale) : (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        if (displayType == 11) {
            format.setParseIntegerOnly(true);
            format.setMaximumIntegerDigits(10);
            format.setMaximumFractionDigits(0);
        } else if (displayType == 29) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
        } else if (displayType == 12) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(2);
            format.setMinimumFractionDigits(2);
        } else if (displayType == 37) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(1);
        }
        return format;
    }

    public static DecimalFormat getNumberFormat(int displayType) {
        return DisplayType.getNumberFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat() {
        return DisplayType.getDateFormat(15, null);
    }

    public static SimpleDateFormat getDateFormat(Language language) {
        return DisplayType.getDateFormat(15, language);
    }

    public static SimpleDateFormat getDateFormat(int displayType) {
        return DisplayType.getDateFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Language.getLoginLanguage();
        }
        if (displayType == 16) {
            return myLanguage.getDateTimeFormat();
        }
        if (displayType == 24) {
            return myLanguage.getTimeFormat();
        }
        return myLanguage.getDateFormat();
    }

    public static SimpleDateFormat getDateFormat_JDBC() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static Class<?> getClass(int displayType, boolean yesNoAsBoolean) {
        if (DisplayType.isText((int)displayType) || displayType == 17) {
            return String.class;
        }
        if (DisplayType.isID((int)displayType) || displayType == 11) {
            return Integer.class;
        }
        if (DisplayType.isNumeric((int)displayType)) {
            return BigDecimal.class;
        }
        if (DisplayType.isDate((int)displayType)) {
            return Timestamp.class;
        }
        if (displayType == 20) {
            return yesNoAsBoolean ? Boolean.class : String.class;
        }
        if (displayType == 28) {
            return String.class;
        }
        if (DisplayType.isLOB((int)displayType)) {
            return byte[].class;
        }
        return Object.class;
    }

    public static String getSQLDataType(int displayType, String columnName, int fieldLength) {
        if (columnName.equals("EntityType") || columnName.equals("AD_Language") || columnName.equals("DocBaseType")) {
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (DisplayType.isID((int)displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return "BLOB";
            }
            if (columnName.endsWith("_ID") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                return "NUMBER(10)";
            }
            if (fieldLength < 4) {
                return "CHAR(" + fieldLength + ")";
            }
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (displayType == 11) {
            return "NUMBER(10)";
        }
        if (DisplayType.isDate((int)displayType)) {
            return "DATE";
        }
        if (DisplayType.isNumeric((int)displayType)) {
            return "NUMBER";
        }
        if (displayType == 23) {
            return "BLOB";
        }
        if (displayType == 36 || displayType == 14 && fieldLength >= 4000) {
            return "CLOB";
        }
        if (displayType == 20) {
            return "CHAR(1)";
        }
        if (displayType == 17) {
            return "CHAR(" + fieldLength + ")";
        }
        if (displayType == 27) {
            if (columnName.endsWith("_ID")) {
                return "NUMBER(10)";
            }
            return "CHAR(" + fieldLength + ")";
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return "NUMBER(10)";
            }
            return "CHAR(" + fieldLength + ")";
        }
        if (!DisplayType.isText((int)displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        return "NVARCHAR2(" + fieldLength + ")";
    }

    public static String getDescription(int displayType) {
        if (displayType == 10) {
            return "String";
        }
        if (displayType == 11) {
            return "Integer";
        }
        if (displayType == 12) {
            return "Amount";
        }
        if (displayType == 13) {
            return "ID";
        }
        if (displayType == 14) {
            return "Text";
        }
        if (displayType == 15) {
            return "Date";
        }
        if (displayType == 16) {
            return "DateTime";
        }
        if (displayType == 17) {
            return "List";
        }
        if (displayType == 18) {
            return "Table";
        }
        if (displayType == 19) {
            return "TableDir";
        }
        if (displayType == 20) {
            return "YesNo";
        }
        if (displayType == 21) {
            return "Location";
        }
        if (displayType == 22) {
            return "Number";
        }
        if (displayType == 23) {
            return "Binary";
        }
        if (displayType == 24) {
            return "Time";
        }
        if (displayType == 25) {
            return "Account";
        }
        if (displayType == 26) {
            return "RowID";
        }
        if (displayType == 27) {
            return "Color";
        }
        if (displayType == 28) {
            return "Button";
        }
        if (displayType == 29) {
            return "Quantity";
        }
        if (displayType == 30) {
            return "Search";
        }
        if (displayType == 31) {
            return "Locator";
        }
        if (displayType == 32) {
            return "Image";
        }
        if (displayType == 33) {
            return "Assignment";
        }
        if (displayType == 34) {
            return "Memo";
        }
        if (displayType == 35) {
            return "PAttribute";
        }
        if (displayType == 36) {
            return "TextLong";
        }
        if (displayType == 37) {
            return "CostPrice";
        }
        if (displayType == 38) {
            return "FilePath";
        }
        if (displayType == 39) {
            return "FileName";
        }
        if (displayType == 40) {
            return "URL";
        }
        if (displayType == 42) {
            return "PrinterName";
        }
        return "UNKNOWN DisplayType=" + displayType;
    }

    public static Object convertFromString(int displayType, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            if (DisplayType.isDate((int)displayType)) {
                long ts = Long.parseLong(stringValue);
                return new Timestamp(ts);
            }
            if (DisplayType.isID((int)displayType) || displayType == 11) {
                return Integer.valueOf(stringValue);
            }
            if (DisplayType.isNumeric((int)displayType)) {
                return new BigDecimal(stringValue);
            }
        }
        catch (Exception e) {
            s_log.warning("Convert '" + stringValue + "' to " + DisplayType.getDescription(displayType) + ": " + e.getLocalizedMessage());
        }
        return stringValue;
    }
}

