/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.compiere.util.IniDialog;
import org.compiere.util.Language;
import org.compiere.util.SecureEngine;

public final class Ini
implements Serializable {
    public static final String COMPIERE_PROPERTY_FILE = "Compiere.properties";
    public static final String P_UID = "ApplicationUserID";
    private static final String DEFAULT_UID = "GardenAdmin";
    public static final String P_PWD = "ApplicationPassword";
    private static final String DEFAULT_PWD = "GardenAdmin";
    public static final String P_STORE_PWD = "StorePassword";
    private static final boolean DEFAULT_STORE_PWD = true;
    public static final String P_TRACELEVEL = "TraceLevel";
    private static final String DEFAULT_TRACELEVEL = "WARNING";
    public static final String P_TRACEFILE = "TraceFile";
    private static final boolean DEFAULT_TRACEFILE = false;
    public static final String P_LANGUAGE = "Language";
    private static final String DEFAULT_LANGUAGE = Language.getName(System.getProperty("user.language") + "_" + System.getProperty("user.country"));
    public static final String P_INI = "FileNameINI";
    private static final String DEFAULT_INI = "";
    public static final String P_CONNECTION = "Connection";
    private static final String DEFAULT_CONNECTION = "";
    public static final String P_CONTEXT = "DataSource";
    private static final String DEFAULT_CONTEXT = "java:compiereDB";
    public static final String P_UI_LOOK = "UILookFeel";
    private static final String DEFAULT_UI_LOOK = "Compiere";
    public static final String P_UI_THEME = "UITheme";
    private static final String DEFAULT_UI_THEME = "Compiere Theme";
    public static final String P_UI_FLAT = "UIFlat";
    private static final boolean DEFAULT_UI_FLAT = false;
    public static final String P_A_LOGIN = "AutoLogin";
    private static final boolean DEFAULT_A_LOGIN = false;
    public static final String P_A_NEW = "AutoNew";
    private static final boolean DEFAULT_A_NEW = true;
    public static final String P_COMPIERESYS = "CompiereSys";
    private static final boolean DEFAULT_COMPIERESYS = false;
    public static final String P_CACHE_WINDOW = "CacheWindow";
    private static final boolean DEFAULT_CACHE_WINDOW = false;
    public static final String P_TEMP_DIR = "TempDir";
    private static final String DEFAULT_TEMP_DIR = "";
    public static final String P_ROLE = "Role";
    private static final String DEFAULT_ROLE = "";
    public static final String P_CLIENT = "Client";
    private static final String DEFAULT_CLIENT = "";
    public static final String P_ORG = "Organization";
    private static final String DEFAULT_ORG = "";
    public static final String P_WAREHOUSE = "Warehouse";
    private static final String DEFAULT_WAREHOUSE = "";
    public static final String P_TODAY = "CDate264";
    private static final Timestamp DEFAULT_TODAY = new Timestamp(System.currentTimeMillis());
    public static final String P_PRINTPREVIEW = "PrintPreview";
    private static final boolean DEFAULT_PRINTPREVIEW = true;
    private static final String P_WARNING = "Warning";
    private static final String DEFAULT_WARNING = "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.";
    private static final String P_WARNING_de = "WarningD";
    private static final String DEFAULT_WARNING_de = "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.";
    private static final String[] PROPERTIES = new String[]{"ApplicationUserID", "ApplicationPassword", "TraceLevel", "TraceFile", "Language", "FileNameINI", "Connection", "StorePassword", "UILookFeel", "UITheme", "UIFlat", "AutoLogin", "AutoNew", "CompiereSys", "CacheWindow", "DataSource", "TempDir", "Role", "Client", "Organization", "Warehouse", "CDate264", "PrintPreview", "Warning", "WarningD"};
    private static final String[] VALUES = new String[]{"GardenAdmin", "GardenAdmin", "WARNING", "N", DEFAULT_LANGUAGE, "", "", "Y", "Compiere", "Compiere Theme", "N", "N", "Y", "N", "N", "java:compiereDB", "", "", "", "", "", DEFAULT_TODAY.toString(), "Y", "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.", "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben."};
    private static Properties s_prop = new Properties();
    private static Logger log = Logger.getLogger(Ini.class.getName());
    public static final String ENV_PREFIX = "env.";
    public static final String COMPIERE_HOME = "COMPIERE_HOME";
    private static boolean s_client = true;
    private static boolean s_loaded = false;

    public static void saveProperties(boolean tryUserHome) {
        String fileName = Ini.getFileName(tryUserHome);
        FileOutputStream fos = null;
        try {
            File f = new File(fileName);
            fos = new FileOutputStream(f);
            s_prop.store(fos, "Compiere (c) 1999-2007");
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + e.toString());
            return;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Cannot save Properties to " + fileName + " - " + t.toString());
            return;
        }
        log.finer(fileName);
    }

    public static void loadProperties(boolean reload) {
        if (reload || s_prop.size() == 0) {
            Ini.loadProperties(Ini.getFileName(s_client));
        }
    }

    public static boolean loadProperties(String filename) {
        boolean loadOK = true;
        boolean firstTime = false;
        s_prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            s_prop.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            log.warning(filename + " not found");
            loadOK = false;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, filename + " - " + e.toString());
            loadOK = false;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, filename + " - " + t.toString());
            loadOK = false;
        }
        if (!loadOK || s_prop.getProperty(P_TODAY, "").equals("")) {
            log.config(filename);
            firstTime = true;
            if (!IniDialog.accept()) {
                System.exit(-1);
            }
        }
        for (int i = 0; i < PROPERTIES.length; ++i) {
            if (VALUES[i].length() <= 0) continue;
            Ini.checkProperty(PROPERTIES[i], VALUES[i]);
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            tempDir = Ini.getCompiereHome();
        }
        if (tempDir == null) {
            tempDir = "";
        }
        Ini.checkProperty(P_TEMP_DIR, tempDir);
        if (!loadOK || firstTime) {
            Ini.saveProperties(true);
        }
        s_loaded = true;
        log.info(filename + " #" + s_prop.size());
        return firstTime;
    }

    public static void deletePropertyFile() {
        String fileName = Ini.getFileName(s_client);
        File file = new File(fileName);
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                s_prop = new Properties();
                log.config(fileName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Cannot delete Property file", e);
            }
        }
    }

    private static String checkProperty(String key, String defaultValue) {
        String result = null;
        result = key.equals(P_WARNING) || key.equals(P_WARNING_de) ? defaultValue : (!Ini.isClient() ? s_prop.getProperty(key, "xyz" + defaultValue + "") : s_prop.getProperty(key, SecureEngine.encrypt(defaultValue)));
        s_prop.setProperty(key, result);
        return result;
    }

    private static String getFileName(boolean tryUserHome) {
        String home;
        if (System.getProperty("PropertyFile") != null) {
            return System.getProperty("PropertyFile");
        }
        String base = null;
        if (tryUserHome && s_client) {
            base = System.getProperty("user.home");
        }
        if (!(s_client && base != null && base.length() != 0 || (home = Ini.getCompiereHome()) == null)) {
            base = home;
        }
        if (base != null && !base.endsWith(File.separator)) {
            base = base + File.separator;
        }
        if (base == null) {
            base = "";
        }
        return base + COMPIERE_PROPERTY_FILE;
    }

    public static void setProperty(String key, String value) {
        if (s_prop == null) {
            s_prop = new Properties();
        }
        if (key.equals(P_WARNING) || key.equals(P_WARNING_de)) {
            s_prop.setProperty(key, value);
        } else if (!Ini.isClient()) {
            s_prop.setProperty(key, "xyz" + value + "");
        } else if (value == null) {
            s_prop.setProperty(key, "");
        } else {
            String eValue = SecureEngine.encrypt(value);
            if (eValue == null) {
                s_prop.setProperty(key, "");
            } else {
                s_prop.setProperty(key, eValue);
            }
        }
    }

    public static void setProperty(String key, boolean value) {
        Ini.setProperty(key, value ? "Y" : "N");
    }

    public static void setProperty(String key, int value) {
        Ini.setProperty(key, String.valueOf(value));
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        if (retStr == null || retStr.length() == 0) {
            return "";
        }
        String value = SecureEngine.decrypt(retStr);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static boolean isPropertyBool(String key) {
        return Ini.getProperty(key).equals("Y");
    }

    public static boolean isCacheWindow() {
        return Ini.getProperty(P_CACHE_WINDOW).equals("Y");
    }

    public static Properties getProperties() {
        return s_prop;
    }

    public static String getAsString() {
        StringBuffer buf = new StringBuffer("Ini[");
        Enumeration<Object> e = s_prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buf.append(key).append("=");
            buf.append(Ini.getProperty(key)).append("; ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static boolean isClient() {
        return s_client;
    }

    public static void setClient(boolean client) {
        s_client = client;
    }

    public static boolean isLoaded() {
        return s_loaded;
    }

    public static String getCompiereHome() {
        String env = System.getProperty("env.COMPIERE_HOME");
        if (env == null) {
            env = System.getProperty(COMPIERE_HOME);
        }
        if (env == null) {
            env = System.getenv(COMPIERE_HOME);
        }
        if (env == null) {
            env = File.separator + "Compiere2";
        }
        return env;
    }

    public static void setCompiereHome(String CompiereHome) {
        if (CompiereHome != null && CompiereHome.length() > 0) {
            System.setProperty(COMPIERE_HOME, CompiereHome);
        }
    }

    public static String findCompiereHome() {
        String ch = Ini.getCompiereHome();
        if (ch != null) {
            return ch;
        }
        File[] roots = File.listRoots();
        for (int i = 0; i < roots.length; ++i) {
            File[] subs;
            if (roots[i].getAbsolutePath().startsWith("A:") || (subs = roots[i].listFiles()) == null) continue;
            for (int j = 0; j < subs.length; ++j) {
                String libDir;
                File lib;
                String fileName;
                if (!subs[j].isDirectory() || (fileName = subs[j].getAbsolutePath()).indexOf("Compiere2") == 1 || !(lib = new File(libDir = fileName + File.separator + "lib")).exists() || !lib.isDirectory()) continue;
                return fileName;
            }
        }
        return ch;
    }

    public static Dimension getWindowDimension(int AD_Window_ID) {
        String key = "WindowDim" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf("|");
        if (index == -1) {
            return null;
        }
        try {
            String w = value.substring(0, index);
            String h = value.substring(index + 1);
            return new Dimension(Integer.parseInt(w), Integer.parseInt(h));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setWindowDimension(int AD_Window_ID, Dimension windowDimension) {
        String key = "WindowDim" + AD_Window_ID;
        if (windowDimension != null) {
            String value = windowDimension.width + "|" + windowDimension.height;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    public static Point getWindowLocation(int AD_Window_ID) {
        String key = "WindowLoc" + AD_Window_ID;
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf("|");
        if (index == -1) {
            return null;
        }
        try {
            String x = value.substring(0, index);
            String y = value.substring(index + 1);
            return new Point(Integer.parseInt(x), Integer.parseInt(y));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setWindowLocation(int AD_Window_ID, Point windowLocation) {
        String key = "WindowLoc" + AD_Window_ID;
        if (windowLocation != null) {
            String value = windowLocation.x + "|" + windowLocation.y;
            s_prop.put(key, value);
        } else {
            s_prop.remove(key);
        }
    }

    public static int getDividerLocation() {
        String key = "Divider";
        String value = (String)s_prop.get(key);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void setDividerLocation(int dividerLocation) {
        String key = "Divider";
        String value = String.valueOf(dividerLocation);
        s_prop.put(key, value);
    }
}

