/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.security.Principal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.Compiere;
import org.compiere.db.CConnection;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.model.MCountry;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSystem;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.model.X_W_Store;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Login {
    private static CLogger log = CLogger.getCLogger(Login.class);
    private Ctx m_ctx = null;
    private String m_connectionProfile = null;
    private ArrayList<KeyNamePair> m_roles = new ArrayList();
    private ArrayList<Integer> m_users = new ArrayList();
    private KeyNamePair m_user = null;
    private KeyNamePair m_role = null;
    private KeyNamePair m_org = null;
    private X_W_Store m_store = null;

    public static Ctx initTest(boolean isClient) {
        KeyNamePair[] orgs;
        KeyNamePair[] clients;
        Ctx ctx;
        Login login;
        KeyNamePair[] roles;
        if (!Compiere.startupEnvironment(true, null)) {
            System.exit(1);
        }
        if ((roles = (login = new Login(ctx = Env.getCtx())).getRoles(CConnection.get(), "System", "System", true)) != null && roles.length > 0 && (clients = login.getClients(roles[0])) != null && clients.length > 0 && (orgs = login.getOrgs(clients[0])) != null && orgs.length > 0) {
            login.loadPreferences(orgs[0], null, null, null);
        }
        ctx.setContext("#Date", String.valueOf(System.currentTimeMillis()));
        return ctx;
    }

    public static boolean isJavaOK(boolean isClient) {
        String jVersion = System.getProperty("java.version");
        if (jVersion.startsWith("1.5.0")) {
            return true;
        }
        boolean ok = false;
        if (jVersion.startsWith("1.6")) {
            ok = true;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(System.getProperty("java.vm.name")).append(" - ").append(jVersion);
        if (ok) {
            msg.append("(untested)");
        }
        msg.append("  <>  1.5.0");
        if (isClient) {
            JOptionPane.showMessageDialog(null, msg.toString(), Compiere.getName() + " - Java Version Check", ok ? 2 : 0);
        } else {
            log.severe(msg.toString());
        }
        return ok;
    }

    public Login(Ctx ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        this.m_ctx = ctx;
    }

    protected KeyNamePair[] getRoles(CConnection cc, String app_user, String app_pwd, boolean force) {
        DB.setDBTarget(cc);
        this.m_ctx.setContext("#Host", cc.getAppsHost());
        this.m_ctx.setContext("#Database", cc.getDbName());
        if (DB.getConnectionRO() == null) {
            log.saveError("NoDatabase", "");
            return null;
        }
        if (app_pwd == null) {
            return null;
        }
        return this.getRoles(app_user, app_pwd, force, false);
    }

    public KeyNamePair[] getRoles(Principal app_user) {
        if (app_user == null) {
            return null;
        }
        return this.getRoles(app_user.getName(), null, false, false);
    }

    public KeyNamePair[] getRoles() {
        return this.m_roles.toArray(new KeyNamePair[this.m_roles.size()]);
    }

    public KeyNamePair[] getRoles(String app_user, String app_pwd) {
        return this.getRoles(app_user, app_pwd, false, false);
    }

    public KeyNamePair[] getRoles(String app_user, String app_pwd, int W_Store_ID) {
        KeyNamePair[] roles = null;
        if (W_Store_ID >= 0 && (roles = this.getRolesByEmail(app_user, app_pwd, W_Store_ID)) != null) {
            this.m_store = new X_W_Store(this.m_ctx, W_Store_ID, null);
            if (W_Store_ID != this.m_store.get_ID()) {
                log.warning("Cannot find W_Store_ID=" + W_Store_ID);
                this.m_store = null;
            }
            this.m_ctx.setContext("#AD_Client_ID", this.m_store.getAD_Client_ID());
            this.m_ctx.setContext("#AD_Org_ID", this.m_store.getAD_Org_ID());
            this.m_ctx.setContext("#User_Level", "  O");
            this.m_ctx.setContext("#SalesRep_ID", this.m_store.getSalesRep_ID());
            this.m_ctx.setContext("#M_PriceList_ID", this.m_store.getM_PriceList_ID());
        }
        if (roles == null) {
            roles = this.getRoles(app_user, app_pwd, false, false);
        }
        return roles;
    }

    private KeyNamePair[] getRoles(String app_user, String app_pwd, boolean force, boolean ignore_pwd) {
        log.info("User=" + app_user);
        long start = System.currentTimeMillis();
        if (app_user == null) {
            log.warning("No Apps User");
            return null;
        }
        boolean authenticated = false;
        MSystem system = MSystem.get(this.m_ctx);
        if (system == null) {
            throw new IllegalStateException("No System Info");
        }
        if (system.isLDAP()) {
            authenticated = system.isLDAP(app_user, app_pwd);
            if (authenticated) {
                app_pwd = null;
            }
        } else if (!(app_pwd != null && app_pwd.length() != 0 || ignore_pwd)) {
            log.warning("No Apps Password");
            return null;
        }
        if (app_pwd != null && SecureEngine.isEncrypted(app_pwd)) {
            log.warning("Cannot use Encrypted Password");
            return null;
        }
        KeyNamePair[] retValue = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        StringBuffer sql = new StringBuffer("SELECT u.AD_User_ID, r.AD_Role_ID,r.Name,").append(" u.ConnectionProfile, u.Password ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive='Y')").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive='Y') ").append("WHERE COALESCE(u.LDAPUser,u.Name)=?").append(" AND u.IsActive='Y'").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE r.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
        if (app_pwd != null) {
            sql.append(" AND (u.Password=? OR u.Password=?)");
        }
        sql.append(" ORDER BY r.Name");
        CPreparedStatement pstmt = null;
        try {
            CConnection cc;
            ResultSet rs;
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setString(1, app_user);
            if (app_pwd != null) {
                pstmt.setString(2, app_pwd);
                pstmt.setString(3, SecureEngine.encrypt(app_pwd));
            }
            if (!(rs = pstmt.executeQuery()).next()) {
                if (force) {
                    this.m_ctx.setAD_User_ID(0);
                    this.m_ctx.setContext("##AD_User_Name", "System (force)");
                    this.m_ctx.setContext("##AD_User_Description", "System Forced Login");
                    this.m_ctx.setContext("#User_Level", "S  ");
                    this.m_ctx.setContext("#User_Client", "0");
                    this.m_ctx.setContext("#User_Org", "0");
                    this.m_user = new KeyNamePair(0, app_user + " (force)");
                    rs.close();
                    pstmt.close();
                    retValue = new KeyNamePair[]{new KeyNamePair(0, "System Administrator (force)")};
                    return retValue;
                }
                rs.close();
                pstmt.close();
                log.saveError("UserPwdError", app_user, false);
                return null;
            }
            int AD_User_ID = rs.getInt(1);
            this.m_ctx.setAD_User_ID(AD_User_ID);
            this.m_user = new KeyNamePair(AD_User_ID, app_user);
            this.m_ctx.setContext("##AD_User_Name", app_user);
            if (MUser.isSalesRep(AD_User_ID)) {
                this.m_ctx.setContext("#SalesRep_ID", AD_User_ID);
            }
            Ini.setProperty("ApplicationUserID", app_user);
            if (Ini.isPropertyBool("StorePassword")) {
                Ini.setProperty("ApplicationPassword", app_pwd);
            }
            this.m_connectionProfile = rs.getString(4);
            if (this.m_connectionProfile != null && !(cc = CConnection.get()).getConnectionProfile().equals(this.m_connectionProfile)) {
                cc.setConnectionProfile(this.m_connectionProfile);
                Ini.setProperty("Connection", cc.toStringLong());
                Ini.saveProperties(false);
            }
            this.m_roles.clear();
            this.m_users.clear();
            do {
                AD_User_ID = rs.getInt(1);
                this.m_users.add(AD_User_ID);
                int AD_Role_ID = rs.getInt(2);
                if (AD_Role_ID == 0) {
                    this.m_ctx.setContext("#SysAdmin", "Y");
                }
                String Name2 = rs.getString(3);
                KeyNamePair p = new KeyNamePair(AD_Role_ID, Name2);
                this.m_roles.add(p);
                list.add(p);
            } while (rs.next());
            rs.close();
            pstmt.close();
            pstmt = null;
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            log.fine("User=" + app_user + " - roles #" + retValue.length);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, sql.toString(), ex);
            log.saveError("DBLogin", ex);
            retValue = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        long ms = System.currentTimeMillis() - start;
        log.finest("ms=" + ms);
        return retValue;
    }

    private KeyNamePair[] getRolesByEmail(String eMail, String password, int W_Store_ID) {
        log.info("EMail=" + eMail + ", W_Store_ID=" + W_Store_ID);
        long start = System.currentTimeMillis();
        if (eMail == null || eMail.length() == 0 || password == null || password.length() == 0 || W_Store_ID == 0) {
            log.warning("Invalid Arguments - EMail=" + eMail + ", Password=" + password + ", W_Store_ID=" + W_Store_ID);
            return null;
        }
        if (SecureEngine.isEncrypted(password)) {
            log.warning("Cannot use Encrypted Password");
            return null;
        }
        KeyNamePair[] retValue = null;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        String sql = "SELECT u.AD_User_ID, r.AD_Role_ID, u.Name FROM AD_User u INNER JOIN W_Store ws ON (u.AD_Client_ID=ws.AD_Client_ID)  INNER JOIN AD_Role r ON (ws.AD_Role_ID=r.AD_Role_ID) WHERE u.EMail=? AND (u.Password=? OR u.Password=?) AND ws.W_Store_ID=? AND (r.IsActive='Y' OR r.IsActive IS NULL) AND u.isActive='Y' AND ws.IsActive='Y' AND u.AD_Client_ID=ws.AD_Client_ID ORDER BY r.Name";
        this.m_roles.clear();
        this.m_users.clear();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setString(1, eMail);
            pstmt.setString(2, password);
            pstmt.setString(3, SecureEngine.encrypt(password));
            pstmt.setInt(4, W_Store_ID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                log.saveError("UserPwdError", eMail, false);
                return null;
            }
            int AD_User_ID = rs.getInt(1);
            this.m_ctx.setAD_User_ID(AD_User_ID);
            this.m_user = new KeyNamePair(AD_User_ID, eMail);
            this.m_users.add(AD_User_ID);
            int AD_Role_ID = rs.getInt(2);
            this.m_ctx.setAD_Role_ID(AD_Role_ID);
            String Name2 = rs.getString(3);
            this.m_ctx.setContext("##AD_User_Name", Name2);
            if (AD_Role_ID == 0) {
                this.m_ctx.setContext("#SysAdmin", "Y");
            }
            KeyNamePair p = new KeyNamePair(AD_Role_ID, Name2);
            this.m_roles.add(p);
            list.add(p);
            rs.close();
            pstmt.close();
            pstmt = null;
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            log.fine("EMail=" + eMail + " - roles #" + retValue.length);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, sql.toString(), ex);
            log.saveError("DBLogin", ex);
            retValue = null;
            this.m_ctx.setContext("##AD_User_Name", eMail);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        long ms = System.currentTimeMillis() - start;
        log.finest("ms=" + ms);
        return retValue;
    }

    public int getAD_Role_ID() {
        if (this.m_role != null) {
            return this.m_role.getKey();
        }
        return -1;
    }

    public int getAD_User_ID() {
        if (this.m_user != null) {
            return this.m_user.getKey();
        }
        return -1;
    }

    public KeyNamePair[] getClients(KeyNamePair role) {
        if (role == null) {
            throw new IllegalArgumentException("Role missing");
        }
        this.m_role = role;
        if (this.m_store != null) {
            return new KeyNamePair[]{new KeyNamePair(this.m_store.getAD_Client_ID(), this.m_store.getName() + " Tenant")};
        }
        int AD_Role_ID = role.getKey();
        for (int i = 0; i < this.m_roles.size(); ++i) {
            if (AD_Role_ID != this.m_roles.get(i).getKey()) continue;
            int AD_User_ID = this.m_users.get(i);
            this.m_ctx.setAD_User_ID(AD_User_ID);
            if (MUser.isSalesRep(AD_User_ID)) {
                this.m_ctx.setContext("#SalesRep_ID", AD_User_ID);
            }
            this.m_user = new KeyNamePair(AD_User_ID, this.m_user.getName());
            break;
        }
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair[] retValue = null;
        String sql = "SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID=? AND r.IsActive='Y' AND c.IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, role.getKey());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                log.log(Level.SEVERE, "No Clients for Role: " + role.toStringX());
                return null;
            }
            this.m_ctx.setAD_Role_ID(role.getKey());
            this.m_ctx.setContext("#AD_Role_Name", role.getName());
            Ini.setProperty("Role", role.getName());
            this.m_ctx.setContext("#User_Level", rs.getString(1));
            CConnection cc = CConnection.get();
            if (this.m_connectionProfile == null) {
                this.m_connectionProfile = rs.getString(2);
                if (this.m_connectionProfile != null && !cc.getConnectionProfile().equals(this.m_connectionProfile)) {
                    cc.setConnectionProfile(this.m_connectionProfile);
                    Ini.setProperty("Connection", cc.toStringLong());
                    Ini.saveProperties(false);
                }
            }
            do {
                int AD_Client_ID = rs.getInt(3);
                String Name2 = rs.getString(4);
                KeyNamePair p = new KeyNamePair(AD_Client_ID, Name2);
                list.add(p);
            } while (rs.next());
            rs.close();
            pstmt.close();
            pstmt = null;
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            log.fine("Role: " + role.toStringX() + " - clients #" + retValue.length);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, sql, ex);
            retValue = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public KeyNamePair[] getOrgs(KeyNamePair client) {
        if (client == null) {
            throw new IllegalArgumentException("Client missing");
        }
        if (this.m_store != null) {
            return new KeyNamePair[]{new KeyNamePair(this.m_store.getAD_Org_ID(), this.m_store.getName() + " Org")};
        }
        if (this.m_ctx.getContext("#AD_Role_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
        }
        int AD_Role_ID = this.m_ctx.getAD_Role_ID();
        int AD_User_ID = this.m_ctx.getAD_User_ID();
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair[] retValue = null;
        String sql = "SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID=? AND c.AD_Client_ID=? AND o.IsActive='Y' AND o.IsSummary='N' AND (r.IsAccessAllOrgs='Y' OR (r.IsUseUserOrgAccess='N' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive='Y')) OR (r.IsUseUserOrgAccess='Y' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID=? AND ua.IsActive='Y'))) ORDER BY o.Name";
        CPreparedStatement pstmt = null;
        MRole role = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Role_ID);
            pstmt.setInt(2, client.getKey());
            pstmt.setInt(3, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Org_ID = rs.getInt(1);
                String Name2 = rs.getString(2);
                boolean summary = "Y".equals(rs.getString(3));
                if (summary) {
                    if (role == null) {
                        role = MRole.get(this.m_ctx, AD_Role_ID, AD_User_ID, false);
                    }
                    this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                    continue;
                }
                KeyNamePair p = new KeyNamePair(AD_Org_ID, Name2);
                if (list.contains(p)) continue;
                list.add(p);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            log.fine("Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + " - orgs #" + retValue.length);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, sql, ex);
            retValue = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null || retValue.length == 0) {
            log.log(Level.WARNING, "No Org for Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID);
            return null;
        }
        this.m_ctx.setContext("#AD_Client_ID", client.getKey());
        this.m_ctx.setContext("#AD_Client_Name", client.getName());
        Ini.setProperty("Client", client.getName());
        return retValue;
    }

    private void getOrgsAddSummary(ArrayList<KeyNamePair> list, int Summary_Org_ID, String Summary_Name, MRole role) {
        if (role == null) {
            log.warning("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Role");
            return;
        }
        if (role.getAD_Tree_Org_ID() == 0) {
            log.config("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Org Tree: " + role);
            return;
        }
        MTree tree = MTree.get(this.m_ctx, role.getAD_Tree_Org_ID(), null);
        String sql = "SELECT AD_Client_ID, AD_Org_ID, Name, IsSummary FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y') " + "ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, Summary_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Org_ID = rs.getInt(2);
                String Name2 = rs.getString(3);
                boolean summary = "Y".equals(rs.getString(4));
                if (summary) {
                    this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                    continue;
                }
                KeyNamePair p = new KeyNamePair(AD_Org_ID, Name2);
                if (list.contains(p)) continue;
                list.add(p);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    public KeyNamePair[] getWarehouses(KeyNamePair org) {
        if (org == null) {
            throw new IllegalArgumentException("Org missing");
        }
        this.m_org = org;
        if (this.m_store != null) {
            return new KeyNamePair[]{new KeyNamePair(this.m_store.getM_Warehouse_ID(), this.m_store.getName() + " Warehouse")};
        }
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair[] retValue = null;
        String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse WHERE AD_Org_ID=? AND IsActive='Y' ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, org.getKey());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                pstmt.close();
                log.info("No Warehouses for Org: " + org.toStringX());
                return null;
            }
            do {
                int AD_Warehouse_ID = rs.getInt(1);
                String Name2 = rs.getString(2);
                KeyNamePair p = new KeyNamePair(AD_Warehouse_ID, Name2);
                list.add(p);
            } while (rs.next());
            rs.close();
            pstmt.close();
            pstmt = null;
            retValue = new KeyNamePair[list.size()];
            list.toArray(retValue);
            log.fine("Org: " + org.toStringX() + " - warehouses #" + retValue.length);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, sql, ex);
            retValue = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public String validateLogin(KeyNamePair org) {
        String error;
        String info = this.m_user + ",R:" + this.m_role.toStringX() + ",O=" + this.m_org.toStringX();
        int AD_Client_ID = this.m_ctx.getAD_Client_ID();
        int AD_Org_ID = org.getKey();
        int AD_Role_ID = this.m_ctx.getAD_Role_ID();
        int AD_User_ID = this.m_ctx.getAD_User_ID();
        MSession session = MSession.get(this.m_ctx, true);
        if (AD_Client_ID != session.getAD_Client_ID()) {
            session.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != session.getAD_Org_ID()) {
            session.setAD_Org_ID(AD_Org_ID);
        }
        if (AD_Role_ID != session.getAD_Role_ID()) {
            session.setAD_Role_ID(AD_Role_ID);
        }
        if ((error = ModelValidationEngine.get().loginComplete(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID)) != null && error.length() > 0) {
            log.severe("Refused: " + info + ": " + error);
            session.setDescription(error);
            session.save();
            return error;
        }
        log.info(info);
        session.save();
        return null;
    }

    public String loadPreferences(KeyNamePair org, KeyNamePair warehouse, Timestamp timestamp, String printerName) {
        this.m_org = org;
        log.info("Org: " + org.toStringX());
        if (this.m_ctx == null || org == null) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        if (this.m_ctx.getContext("#AD_Client_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
        }
        if (this.m_ctx.getContext("##AD_User_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context ##AD_User_ID");
        }
        if (this.m_ctx.getContext("#AD_Role_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
        }
        this.m_ctx.setAD_Org_ID(org.getKey());
        this.m_ctx.setContext("#AD_Org_Name", org.getName());
        Ini.setProperty("Organization", org.getName());
        if (warehouse != null) {
            this.m_ctx.setContext("#M_Warehouse_ID", warehouse.getKey());
            Ini.setProperty("Warehouse", warehouse.getName());
        }
        long today = System.currentTimeMillis();
        if (timestamp != null) {
            today = timestamp.getTime();
        }
        this.m_ctx.setContext("#Date", String.valueOf(today));
        MUser user = MUser.get(this.m_ctx, this.getAD_User_ID());
        MUserPreference preference = user.getPreference();
        MRole role = MRole.getDefault(this.m_ctx, true);
        if (printerName == null) {
            printerName = "";
        }
        if (printerName.length() == 0 && preference.getPrinterName() != null) {
            printerName = preference.getPrinterName();
        }
        this.m_ctx.setPrinterName(printerName);
        if (preference.getPrinterName() == null && printerName.length() > 0) {
            preference.setPrinterName(printerName);
        }
        this.m_ctx.setAutoCommit(preference.isAutoCommit());
        this.m_ctx.setAutoNew(Ini.isPropertyBool("AutoNew"));
        if (role.isShowAcct()) {
            this.m_ctx.setContext("#ShowAcct", preference.isShowAcct());
        } else {
            this.m_ctx.setContext("#ShowAcct", "N");
        }
        this.m_ctx.setContext("#ShowTrl", preference.isShowTrl());
        this.m_ctx.setContext("#ShowAdvanced", preference.isShowAdvanced());
        if (preference.getUITheme() != null) {
            this.m_ctx.setContext("#UITheme", preference.getUITheme());
        }
        String retValue = "";
        int AD_Client_ID = this.m_ctx.getAD_Client_ID();
        int AD_Role_ID = this.m_ctx.getAD_Role_ID();
        this.m_ctx.setContext("#YYYY", "Y");
        String sql = "SELECT a.C_AcctSchema_ID, a.C_Currency_ID, a.HasAlias, c.ISO_Code, c.StdPrecision FROM C_AcctSchema a INNER JOIN AD_ClientInfo ci ON (a.C_AcctSchema_ID=ci.C_AcctSchema1_ID) INNER JOIN C_Currency c ON (a.C_Currency_ID=c.C_Currency_ID) WHERE ci.AD_Client_ID=?";
        CPreparedStatement pstmt = null;
        try {
            int C_AcctSchema_ID = 0;
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                if (AD_Role_ID != 0) {
                    retValue = "NoValidAcctInfo";
                }
            } else {
                C_AcctSchema_ID = rs.getInt(1);
                this.m_ctx.setContext("$C_AcctSchema_ID", C_AcctSchema_ID);
                this.m_ctx.setContext("$C_Currency_ID", rs.getInt(2));
                this.m_ctx.setContext("$HasAlias", rs.getString(3));
                this.m_ctx.setContext("$CurrencyISO", rs.getString(4));
                this.m_ctx.setStdPrecision(rs.getInt(5));
            }
            rs.close();
            pstmt.close();
            sql = "SELECT ElementType FROM C_AcctSchema_Element WHERE C_AcctSchema_ID=? AND IsActive='Y'";
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_AcctSchema_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_ctx.setContext("$Element_" + rs.getString("ElementType"), "Y");
            }
            rs.close();
            pstmt.close();
            sql = "SELECT Attribute, Value, AD_Window_ID FROM AD_Preference WHERE AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@##AD_User_ID@) AND IsActive='Y' ORDER BY Attribute, AD_Client_ID, AD_User_ID DESC, AD_Org_ID";
            sql = Env.parseContext(this.m_ctx, 0, sql, false);
            if (sql.length() == 0) {
                log.log(Level.SEVERE, "Missing Environment");
            } else {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Window_ID = rs.getInt(3);
                    String at = "";
                    at = rs.wasNull() ? "P|" + rs.getString(1) : "P" + AD_Window_ID + "|" + rs.getString(1);
                    String va = rs.getString(2);
                    this.m_ctx.setContext(at, va);
                }
                rs.close();
                pstmt.close();
            }
            log.info("Default Values ...");
            sql = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey='Y' AND t.IsActive='Y' AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive='Y')";
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.loadDefault(rs.getString(1), rs.getString(2));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        Ini.saveProperties(Ini.isClient());
        this.m_ctx.setContext("#C_Country_ID", MCountry.getDefault(this.m_ctx).getC_Country_ID());
        return retValue;
    }

    private void loadDefault(String TableName, String ColumnName) {
        if (TableName.startsWith("AD_Window") || TableName.startsWith("AD_PrintFormat") || TableName.startsWith("AD_Workflow")) {
            return;
        }
        String value = null;
        String sql = "SELECT " + ColumnName + " FROM " + TableName + " WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC";
        sql = MRole.getDefault(this.m_ctx, false).addAccessSQL(sql, TableName, false, false);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, TableName + " (" + sql + ")", e);
            return;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (value != null && value.length() != 0) {
            if (TableName.equals("C_DocType")) {
                this.m_ctx.setContext("#C_DocTypeTarget_ID", value);
            } else {
                this.m_ctx.setContext("#" + ColumnName, value);
            }
        }
    }

    public boolean batchLogin(Timestamp loginDate, String printerName) {
        int i;
        int i2;
        int i3;
        int i4;
        String pwd;
        String uid = Ini.getProperty("ApplicationUserID");
        KeyNamePair[] roles = this.getRoles(uid, pwd = Ini.getProperty("ApplicationPassword"));
        if (roles == null || roles.length == 0) {
            log.severe("User/Password invalid: " + uid);
            return false;
        }
        log.info("User: " + uid);
        String role = Ini.getProperty("Role");
        KeyNamePair rolePP = null;
        for (i4 = 0; i4 < roles.length; ++i4) {
            KeyNamePair pair = roles[i4];
            if (!pair.getName().equalsIgnoreCase(role)) continue;
            rolePP = pair;
            break;
        }
        if (rolePP == null) {
            log.severe("Role invalid: " + role);
            for (i4 = 0; i4 < roles.length; ++i4) {
                log.info("Option: " + roles[i4]);
            }
            return false;
        }
        log.info("Role: " + role);
        String client = Ini.getProperty("Client");
        KeyNamePair[] clients = this.getClients(rolePP);
        if (clients == null || clients.length == 0) {
            log.severe("No Clients for Role: " + role);
            return false;
        }
        KeyNamePair clientPP = null;
        for (i3 = 0; i3 < clients.length; ++i3) {
            KeyNamePair pair = clients[i3];
            if (!pair.getName().equalsIgnoreCase(client)) continue;
            clientPP = pair;
            break;
        }
        if (clientPP == null) {
            log.severe("Client invalid: " + client);
            for (i3 = 0; i3 < clients.length; ++i3) {
                log.info("Option: " + clients[i3]);
            }
            return false;
        }
        String org = Ini.getProperty("Organization");
        KeyNamePair[] orgs = this.getOrgs(clientPP);
        if (orgs == null || orgs.length == 0) {
            log.severe("No Orgs for Client: " + client);
            return false;
        }
        KeyNamePair orgPP = null;
        for (i2 = 0; i2 < orgs.length; ++i2) {
            KeyNamePair pair = orgs[i2];
            if (!pair.getName().equalsIgnoreCase(org)) continue;
            orgPP = pair;
            break;
        }
        if (orgPP == null) {
            log.severe("Org invalid: " + org);
            for (i2 = 0; i2 < orgs.length; ++i2) {
                log.info("Option: " + orgs[i2]);
            }
            return false;
        }
        String error = this.validateLogin(orgPP);
        if (error != null && error.length() > 0) {
            return false;
        }
        String wh = Ini.getProperty("Warehouse");
        KeyNamePair[] whs = this.getWarehouses(orgPP);
        if (whs == null || whs.length == 0) {
            log.severe("No Warehouses for Org: " + org);
            return false;
        }
        KeyNamePair whPP = null;
        for (i = 0; i < whs.length; ++i) {
            KeyNamePair pair = whs[i];
            if (!pair.getName().equalsIgnoreCase(wh)) continue;
            whPP = pair;
            break;
        }
        if (whPP == null) {
            log.severe("Warehouse invalid: " + wh);
            for (i = 0; i < whs.length; ++i) {
                log.info("Option: " + whs[i]);
            }
            return false;
        }
        String langName = Ini.getProperty("Language");
        Locale.setDefault(this.setLanguage(langName));
        if (loginDate == null) {
            loginDate = new Timestamp(System.currentTimeMillis());
        }
        this.loadPreferences(orgPP, whPP, loginDate, printerName);
        log.info("complete");
        return true;
    }

    public Locale setLanguage(String langInfo) {
        Language language = Language.getLanguage(langInfo);
        Language.setLoginLanguage(language);
        language = Env.verifyLanguage(this.m_ctx, language);
        this.m_ctx.setContext("#AD_Language", language.getAD_Language());
        Locale loc = language.getLocale();
        Msg.getMsg(this.m_ctx, "0");
        return loc;
    }

    public boolean batchLogin() {
        return this.batchLogin(new Timestamp(System.currentTimeMillis()), "");
    }

    public Principal getPrincipal() {
        return null;
    }
}

