/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.logging.Level;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class Trx
implements VetoableChangeListener {
    private static CCache<String, Trx> s_cache = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Connection m_connection = null;
    private String m_trxName = null;
    private Savepoint m_savepoint = null;
    private boolean m_active = false;

    public static synchronized Trx get(String trxName, boolean createNew) {
        Trx retValue;
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        if (s_cache == null) {
            s_cache = new CCache("Trx", 10, -1);
            s_cache.addVetoableChangeListener(new Trx("controller"));
        }
        if ((retValue = s_cache.get(trxName)) == null && createNew) {
            retValue = new Trx(trxName);
            s_cache.put(trxName, retValue);
        }
        return retValue;
    }

    public static String createTrxName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            prefix = "Trx";
        }
        prefix = prefix + "_" + System.currentTimeMillis();
        return prefix;
    }

    public static String createTrxName() {
        return Trx.createTrxName(null);
    }

    private Trx(String trxName) {
        this(trxName, null);
    }

    private Trx(String trxName, Connection con) {
        this.setTrxName(trxName);
        this.setConnection(con);
    }

    public Connection getConnection() {
        this.log.log(Level.ALL, "Active=" + this.isActive() + ", Connection=" + this.m_connection);
        if (this.m_connection == null) {
            this.setConnection(DB.createConnection(false, 2));
        }
        if (!this.isActive()) {
            this.start();
        }
        return this.m_connection;
    }

    private void setConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.m_connection = conn;
        this.log.finest("Connection=" + conn);
        try {
            this.m_connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "connection", e);
        }
    }

    private void setTrxName(String trxName) {
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        this.m_trxName = trxName;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    public boolean start() {
        if (this.m_savepoint != null || this.m_active) {
            this.log.warning("Trx in progress " + this.m_trxName + " - " + this.m_savepoint);
            return false;
        }
        this.m_active = true;
        try {
            if (this.m_connection != null) {
                this.m_savepoint = this.m_connection.setSavepoint(this.m_trxName);
                this.log.info("**** " + this.getTrxName());
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
            this.m_savepoint = null;
            return false;
        }
        return true;
    }

    public Savepoint getSavepoint() {
        return this.m_savepoint;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public boolean rollback() {
        try {
            if (this.m_connection != null) {
                this.m_connection.rollback();
                this.log.info("**** " + this.m_trxName);
                this.m_savepoint = null;
                this.m_active = false;
                return true;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
        }
        this.m_savepoint = null;
        this.m_active = false;
        return false;
    }

    public boolean commit() {
        try {
            if (this.m_connection != null) {
                this.m_connection.commit();
                this.log.info("**** " + this.m_trxName);
                this.m_savepoint = null;
                this.m_active = false;
                return true;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
        }
        this.m_savepoint = null;
        this.m_active = false;
        return false;
    }

    public synchronized boolean close() {
        if (s_cache != null) {
            s_cache.remove(this.getTrxName());
        }
        if (this.m_connection == null) {
            return true;
        }
        if (this.m_savepoint != null || this.isActive()) {
            this.commit();
        }
        try {
            this.m_connection.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
        }
        this.m_savepoint = null;
        this.m_connection = null;
        this.m_active = false;
        this.log.config(this.m_trxName);
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Trx[");
        sb.append(this.getTrxName()).append(",Active=").append(this.isActive()).append("]");
        return sb.toString();
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.log.info(evt.toString());
    }
}

