/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static Logger log = Logger.getLogger(Util.class.getName());

    public static StringBuffer replace(StringBuffer value, String oldPart, String newPart) {
        if (value == null || value.length() == 0 || oldPart == null || oldPart.length() == 0) {
            return value;
        }
        int oldPartLength = oldPart.length();
        String oldValue = value.toString();
        StringBuffer retValue = new StringBuffer();
        int pos = oldValue.indexOf(oldPart);
        while (pos != -1) {
            retValue.append(oldValue.substring(0, pos));
            if (newPart != null && newPart.length() > 0) {
                retValue.append(newPart);
            }
            oldValue = oldValue.substring(pos + oldPartLength);
            pos = oldValue.indexOf(oldPart);
        }
        retValue.append(oldValue);
        return retValue;
    }

    public static String replace(String value, String oldPart, String newPart) {
        if (value == null) {
            return null;
        }
        return Util.replace(new StringBuffer(value), oldPart, newPart).toString();
    }

    public static String removeCRLF(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\n' || c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String cleanWhitespace(String in) {
        if (in == null) {
            return null;
        }
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        boolean lastWasSpace = false;
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (Character.isWhitespace(c)) {
                if (!lastWasSpace) {
                    out.append(' ');
                }
                lastWasSpace = true;
                continue;
            }
            out.append(c);
            lastWasSpace = false;
        }
        return out.toString();
    }

    public static String maskHTML(String content) {
        return Util.maskHTML(content, false);
    }

    public static String maskHTML(String content, boolean maskCR) {
        if (content == null || content.length() == 0 || content.equals(" ")) {
            return "&nbsp";
        }
        StringBuffer out = new StringBuffer();
        char[] chars = content.toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block8;
                }
                case '>': {
                    out.append("&gt;");
                    continue block8;
                }
                case '&': {
                    out.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    out.append("&#039;");
                    continue block8;
                }
                case '\n': {
                    if (maskCR) {
                        out.append("<br>");
                    }
                }
                default: {
                    char ii = c;
                    if (ii > '\u00ff') {
                        out.append("&#").append((int)ii).append(";");
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static int getCount(String string, char countChar) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int counter = 0;
        char[] array = string.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != countChar) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getBackupName() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String nowString = now.toString();
        nowString = nowString.substring(0, 19);
        nowString = Util.replace(nowString, "-", "_");
        nowString = Util.replace(nowString, " ", "_");
        nowString = Util.replace(nowString, ":", "_");
        return nowString;
    }

    public static File createBackup(File file) {
        if (!file.exists()) {
            return null;
        }
        String backupName = file.getAbsolutePath() + Util.getBackupName();
        File backup = new File(backupName);
        try {
            FileOutputStream fo = new FileOutputStream(backup);
            FileInputStream fi = new FileInputStream(file);
            boolean eof = false;
            while (!eof) {
                int c = fi.read();
                if (c == -1) {
                    eof = true;
                    continue;
                }
                fo.write(c);
            }
            fi.close();
            fo.flush();
            fo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (file.length() == backup.length()) {
            return backup;
        }
        return null;
    }

    public static int findIndexOf(String str, char search) {
        return Util.findIndexOf(str, search, search);
    }

    public static int findIndexOf(String str, char search1, char search2) {
        if (str == null) {
            return -1;
        }
        int endIndex = -1;
        int parCount = 0;
        boolean ignoringText = false;
        int size = str.length();
        while (++endIndex < size) {
            char c = str.charAt(endIndex);
            if (c == '\'') {
                ignoringText = !ignoringText;
                continue;
            }
            if (ignoringText) continue;
            if (parCount == 0 && (c == search1 || c == search2)) {
                return endIndex;
            }
            if (c == ')') {
                --parCount;
                continue;
            }
            if (c != '(') continue;
            ++parCount;
        }
        return -1;
    }

    public static int findIndexOf(String str, String search) {
        if (str == null || search == null || search.length() == 0) {
            return -1;
        }
        int endIndex = -1;
        int parCount = 0;
        boolean ignoringText = false;
        int size = str.length();
        while (++endIndex < size) {
            char c = str.charAt(endIndex);
            if (c == '\'') {
                ignoringText = !ignoringText;
                continue;
            }
            if (ignoringText) continue;
            if (parCount == 0 && c == search.charAt(0)) {
                if (!str.substring(endIndex).startsWith(search)) continue;
                return endIndex;
            }
            if (c == ')') {
                --parCount;
                continue;
            }
            if (c != '(') continue;
            ++parCount;
        }
        return -1;
    }

    public static String toHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String toHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return Util.toHex(hi) + Util.toHex(lo);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        StringBuffer retString = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            retString.append(Integer.toHexString(256 + (bytes[i] & 0xFF)).substring(1));
        }
        return retString.toString();
    }

    public static byte[] toByteArray(String s) {
        if (s == null || s.length() <= 0) {
            return null;
        }
        byte[] bytes = new byte[s.length() / 2];
        int j = 0;
        for (int i = 0; i < s.length(); i += 2) {
            int ii = Integer.parseInt(s.substring(i, i + 2), 16);
            bytes[j++] = (byte)(ii & 0xFF);
        }
        return bytes;
    }

    public static String initCap(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        boolean capitalize = true;
        char[] data = in.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ' || Character.isWhitespace(data[i])) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                data[i] = Character.toUpperCase(data[i]);
                capitalize = false;
                continue;
            }
            data[i] = Character.toLowerCase(data[i]);
        }
        return new String(data);
    }

    public static AttributedCharacterIterator getIterator(AttributedString aString, AttributedCharacterIterator.Attribute[] relevantAttributes) {
        AttributedCharacterIterator iter = aString.getIterator();
        Set<AttributedCharacterIterator.Attribute> set = iter.getAllAttributeKeys();
        if (set.size() == 0) {
            return iter;
        }
        HashSet<AttributedCharacterIterator.Attribute> unwanted = new HashSet<AttributedCharacterIterator.Attribute>(iter.getAllAttributeKeys());
        for (int i = 0; i < relevantAttributes.length; ++i) {
            unwanted.remove(relevantAttributes[i]);
        }
        if (unwanted.size() == 0) {
            return iter;
        }
        StringBuffer sb = new StringBuffer();
        char c = iter.first();
        while (c != '\uffff') {
            sb.append(c);
            c = iter.next();
        }
        aString = new AttributedString(sb.toString());
        for (AttributedCharacterIterator.Attribute att : iter.getAllAttributeKeys()) {
            if (unwanted.contains(att)) continue;
            char c2 = iter.first();
            while (c2 != '\uffff') {
                Object value = iter.getAttribute(att);
                if (value != null) {
                    int start = iter.getRunStart(att);
                    int limit = iter.getRunLimit(att);
                    aString.addAttribute(att, value, start, limit);
                    iter.setIndex(limit);
                }
                c2 = iter.next();
            }
        }
        return aString.getIterator();
    }

    public static void dump(Map<?, ?> map) {
        System.out.println("Dump Map - size=" + map.size());
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            System.out.println(key + "=" + value);
        }
    }

    public static void printActionInputMap(JComponent comp) {
        InputMap im;
        KeyStroke[] kStrokes;
        ActionMap am = comp.getActionMap();
        Object[] amKeys = am.allKeys();
        if (amKeys != null) {
            System.out.println("-------------------------");
            System.out.println("ActionMap for Component " + comp.toString());
            for (int i = 0; i < amKeys.length; ++i) {
                Action a = am.get(amKeys[i]);
                StringBuffer sb = new StringBuffer("- ");
                sb.append(a.getValue("Name"));
                if (a.getValue("ActionCommandKey") != null) {
                    sb.append(", Cmd=").append(a.getValue("ActionCommandKey"));
                }
                if (a.getValue("ShortDescription") != null) {
                    sb.append(" - ").append(a.getValue("ShortDescription"));
                }
                System.out.println(sb.toString() + " - " + a);
            }
        }
        if ((kStrokes = (im = comp.getInputMap(0)).allKeys()) != null) {
            System.out.println("-------------------------");
            System.out.println("InputMap for Component When Focused - " + comp.toString());
            for (int i = 0; i < kStrokes.length; ++i) {
                System.out.println("- " + kStrokes[i].toString() + " - " + im.get(kStrokes[i]).toString());
            }
        }
        if ((kStrokes = (im = comp.getInputMap(2)).allKeys()) != null) {
            System.out.println("-------------------------");
            System.out.println("InputMap for Component When Focused in Window - " + comp.toString());
            for (int i = 0; i < kStrokes.length; ++i) {
                System.out.println("- " + kStrokes[i].toString() + " - " + im.get(kStrokes[i]).toString());
            }
        }
        if ((kStrokes = (im = comp.getInputMap(1)).allKeys()) != null) {
            System.out.println("-------------------------");
            System.out.println("InputMap for Component When Ancestor - " + comp.toString());
            for (int i = 0; i < kStrokes.length; ++i) {
                System.out.println("- " + kStrokes[i].toString() + " - " + im.get(kStrokes[i]).toString());
            }
        }
        System.out.println("-------------------------");
    }

    public static boolean is8Bit(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        char[] cc = str.toCharArray();
        for (int i = 0; i < cc.length; ++i) {
            if (cc[i] <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static String cleanMnemonic(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        int pos = in.indexOf(38);
        if (pos == -1) {
            return in;
        }
        if (pos + 1 < in.length() && in.charAt(pos + 1) != ' ') {
            in = in.substring(0, pos) + in.substring(pos + 1);
        }
        return in;
    }

    public static String trimLength(String str, int length) {
        if (str == null) {
            return str;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Trim length invalid: " + length);
        }
        if (str.length() > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static int size(String str) {
        int length;
        if (str == null) {
            return 0;
        }
        int size = length = str.length();
        try {
            size = str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, str, e);
        }
        return size;
    }

    public static String trimSize(String str, int size) {
        if (str == null) {
            return str;
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Trim size invalid: " + size);
        }
        int length = str.length();
        if (length < size / 2) {
            return str;
        }
        try {
            byte[] bytes = str.getBytes("UTF-8");
            if (bytes.length <= size) {
                return str;
            }
            byte[] result = new byte[size];
            System.arraycopy(bytes, 0, result, 0, size);
            return new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, str, e);
            return str;
        }
    }

    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            byte[] b1 = (byte[])o1;
            byte[] b2 = (byte[])o2;
            return Arrays.equals(b1, b2);
        }
        return o1.equals(o2);
    }

    public static void main(String[] args) {
        String str = "a\ufffdb\ufffdc?d?e?f?g?";
        System.out.println(str + " = " + str.length() + " - " + Util.size(str));
        String str1 = Util.trimLength(str, 10);
        System.out.println(str1 + " = " + str1.length() + " - " + Util.size(str1));
        String str2 = Util.trimSize(str, 10);
        System.out.println(str2 + " = " + str2.length() + " - " + Util.size(str2));
        AttributedString aString = new AttributedString("test test");
        aString.addAttribute(TextAttribute.FOREGROUND, Color.blue);
        aString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 2, 4);
        Util.getIterator(aString, new AttributedCharacterIterator.Attribute[]{TextAttribute.UNDERLINE});
    }
}

