/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.ldap.LdapProcessor;
import org.compiere.model.CompiereProcessor;
import org.compiere.model.CompiereProcessorLog;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MSchedule;
import org.compiere.model.MScheduler;
import org.compiere.model.MSystem;
import org.compiere.server.AcctProcessor;
import org.compiere.server.AlertProcessor;
import org.compiere.server.CompiereServerGroup;
import org.compiere.server.RequestProcessor;
import org.compiere.server.Scheduler;
import org.compiere.server.WorkflowProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflowProcessor;

public abstract class CompiereServer
extends Thread {
    protected CompiereProcessor p_model;
    private int m_initialNap = 0;
    private long m_sleepMS = 600000L;
    private volatile boolean m_sleeping = false;
    private long m_start = 0L;
    protected int p_runCount = 0;
    protected long p_startWork = 0L;
    private long m_runLastMS = 0L;
    private long m_runTotalMS = 0L;
    private long m_nextWork = 0L;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Ctx m_ctx = null;
    protected static MSystem p_system = null;
    protected MClient p_client = null;

    public static CompiereServer create(CompiereProcessor model) {
        if (model instanceof MRequestProcessor) {
            return new RequestProcessor((MRequestProcessor)model);
        }
        if (model instanceof MWorkflowProcessor) {
            return new WorkflowProcessor((MWorkflowProcessor)model);
        }
        if (model instanceof MAcctProcessor) {
            return new AcctProcessor((MAcctProcessor)model);
        }
        if (model instanceof MAlertProcessor) {
            return new AlertProcessor((MAlertProcessor)model);
        }
        if (model instanceof MScheduler) {
            return new Scheduler((MScheduler)model);
        }
        if (model instanceof MLdapProcessor) {
            return new LdapProcessor((MLdapProcessor)model);
        }
        throw new IllegalArgumentException("Unknown Processor");
    }

    protected CompiereServer(CompiereProcessor model, int initialNap) {
        super(CompiereServerGroup.get(), null, model.getName(), 0L);
        this.p_model = model;
        this.m_ctx = new Ctx(model.getCtx());
        if (p_system == null) {
            p_system = MSystem.get(this.m_ctx);
        }
        this.p_client = MClient.get(this.m_ctx);
        this.m_ctx.setContext("#AD_Client_ID", this.p_client.getAD_Client_ID());
        this.m_initialNap = initialNap;
    }

    public Ctx getCtx() {
        return this.m_ctx;
    }

    public long getSleepMS() {
        return this.m_sleepMS;
    }

    public boolean sleep() {
        if (this.isInterrupted()) {
            this.log.info(this.getName() + ": interrupted");
            return false;
        }
        if (this.m_sleepMS < 10L) {
            return true;
        }
        this.log.fine(this.getName() + ": sleeping " + TimeUtil.formatElapsed(this.m_sleepMS));
        this.m_sleeping = true;
        try {
            CompiereServer.sleep(this.m_sleepMS);
        }
        catch (InterruptedException e) {
            this.log.info(this.getName() + ": interrupted");
            this.m_sleeping = false;
            return false;
        }
        this.m_sleeping = false;
        return true;
    }

    public void runNow() {
        this.log.info(this.getName());
        this.p_startWork = System.currentTimeMillis();
        this.doWork();
        long now = System.currentTimeMillis();
        ++this.p_runCount;
        this.m_runLastMS = now - this.p_startWork;
        this.m_runTotalMS += this.m_runLastMS;
        this.p_model.setDateLastRun(new Timestamp(now));
        this.p_model.save();
        this.log.fine(this.getName() + ": " + this.getStatistics());
    }

    public void run() {
        int AD_Schedule_ID = this.p_model.getAD_Schedule_ID();
        MSchedule schedule = null;
        if (AD_Schedule_ID != 0 && !(schedule = MSchedule.get(this.getCtx(), AD_Schedule_ID)).isOKtoRunOnIP()) {
            this.log.warning(this.getName() + ": Stopped - IP Restriction " + schedule);
            return;
        }
        try {
            this.log.fine(this.getName() + ": pre-nap - " + this.m_initialNap);
            CompiereServer.sleep(this.m_initialNap * 1000);
        }
        catch (InterruptedException e) {
            this.log.log(Level.SEVERE, this.getName() + ": pre-nap interrupted", e);
            return;
        }
        this.m_start = System.currentTimeMillis();
        do {
            long now;
            Timestamp dateNextRun;
            if (this.m_nextWork == 0L && (dateNextRun = this.getDateNextRun(true)) != null) {
                this.m_nextWork = dateNextRun.getTime();
            }
            if (this.m_nextWork > (now = System.currentTimeMillis())) {
                this.m_sleepMS = this.m_nextWork - now;
                if (!this.sleep()) break;
            }
            if (this.isInterrupted()) {
                this.log.info(this.getName() + ": interrupted");
                break;
            }
            this.p_startWork = System.currentTimeMillis();
            this.doWork();
            now = System.currentTimeMillis();
            ++this.p_runCount;
            this.m_runLastMS = now - this.p_startWork;
            this.m_runTotalMS += this.m_runLastMS;
            this.m_sleepMS = this.calculateSleep(now);
            this.m_nextWork = now + this.m_sleepMS;
            this.p_model.setDateLastRun(new Timestamp(now));
            this.p_model.setDateNextRun(new Timestamp(this.m_nextWork));
            this.p_model.save();
            this.log.fine(this.getName() + ": " + this.getStatistics());
        } while (this.sleep());
        this.m_start = 0L;
    }

    public String getStatistics() {
        return "Run #" + this.p_runCount + " - Last=" + TimeUtil.formatElapsed(this.m_runLastMS) + " - Total=" + TimeUtil.formatElapsed(this.m_runTotalMS) + " - Next " + TimeUtil.formatElapsed(this.m_nextWork - System.currentTimeMillis());
    }

    protected abstract void doWork();

    public abstract String getServerInfo();

    public String getServerID() {
        return this.p_model.getServerID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        return this.p_model.getDateNextRun(requery);
    }

    public Timestamp getDateLastRun() {
        return this.p_model.getDateLastRun();
    }

    public String getDescription() {
        return this.p_model.getDescription();
    }

    public CompiereProcessor getModel() {
        return this.p_model;
    }

    private long calculateSleep(long now) {
        String frequencyType = this.p_model.getFrequencyType();
        int frequency = this.p_model.getFrequency();
        if (frequency < 1) {
            frequency = 1;
        }
        long typeSec = 600L;
        if (frequencyType == null) {
            typeSec = 300L;
        } else if ("M".equals(frequencyType)) {
            typeSec = 60L;
        } else if ("H".equals(frequencyType)) {
            typeSec = 3600L;
        } else if ("D".equals(frequencyType)) {
            typeSec = 86400L;
        }
        long sleep = typeSec * 1000L * (long)frequency;
        if (this.p_model.getAD_Schedule_ID() == 0) {
            return sleep;
        }
        MSchedule schedule = MSchedule.get(this.getCtx(), this.p_model.getAD_Schedule_ID());
        long next = schedule.getNextRunMS(now);
        long delta = next - now;
        if (delta < 0L) {
            this.log.warning("Negative Delta=" + delta + " - set to " + sleep);
            delta = sleep;
        }
        return delta;
    }

    public boolean isSleeping() {
        return this.m_sleeping;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName()).append(",Prio=").append(this.getPriority()).append(",").append(this.getThreadGroup()).append(",Alive=").append(this.isAlive()).append(",Sleeping=").append(this.m_sleeping).append(",Last=").append(this.getDateLastRun());
        if (this.m_sleeping) {
            sb.append(",Next=").append(this.getDateNextRun(false));
        }
        return sb.toString();
    }

    public int getSecondsAlive() {
        if (this.m_start == 0L) {
            return 0;
        }
        long now = System.currentTimeMillis();
        long ms = (now - this.m_start) / 1000L;
        return (int)ms;
    }

    public Timestamp getStartTime() {
        if (this.m_start == 0L) {
            return null;
        }
        return new Timestamp(this.m_start);
    }

    public CompiereProcessorLog[] getLogs() {
        return this.p_model.getLogs();
    }
}

