/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DelegatingChangeListenerCollection;
import com.google.gwt.user.client.ui.DelegatingClickListenerCollection;
import com.google.gwt.user.client.ui.DelegatingFocusListenerCollection;
import com.google.gwt.user.client.ui.DelegatingKeyboardListenerCollection;
import com.google.gwt.user.client.ui.FiresSuggestionEvents;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerAdapter;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesFocusEvents;
import com.google.gwt.user.client.ui.SourcesKeyboardEvents;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestionEvent;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class SuggestBox
extends Composite
implements HasText,
HasFocus,
SourcesClickEvents,
SourcesFocusEvents,
SourcesChangeEvents,
SourcesKeyboardEvents,
FiresSuggestionEvents {
    private static final String STYLENAME_DEFAULT = "gwt-SuggestBox";
    private int limit = 20;
    private SuggestOracle oracle;
    private String currentText;
    private final SuggestionMenu suggestionMenu;
    private final SuggestionPopup suggestionPopup;
    private final TextBoxBase box;
    private ArrayList suggestionHandlers = null;
    private DelegatingClickListenerCollection clickListeners;
    private DelegatingChangeListenerCollection changeListeners;
    private DelegatingFocusListenerCollection focusListeners;
    private DelegatingKeyboardListenerCollection keyboardListeners;
    private final SuggestOracle.Callback callBack = new SuggestOracle.Callback(){

        public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
            SuggestBox.this.showSuggestions(response.getSuggestions());
        }
    };

    public SuggestBox() {
        this(new MultiWordSuggestOracle());
    }

    public SuggestBox(SuggestOracle oracle) {
        this(oracle, new TextBox());
    }

    public SuggestBox(SuggestOracle oracle, TextBoxBase box) {
        this.box = box;
        this.initWidget(box);
        this.suggestionMenu = new SuggestionMenu(true);
        this.suggestionPopup = new SuggestionPopup();
        this.addKeyboardSupport();
        this.setOracle(oracle);
        this.setStyleName(STYLENAME_DEFAULT);
    }

    public final void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new DelegatingChangeListenerCollection(this, this.box);
        }
        this.changeListeners.add(listener);
    }

    public final void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new DelegatingClickListenerCollection(this, this.box);
        }
        this.clickListeners.add(listener);
    }

    public final void addEventHandler(SuggestionHandler handler) {
        if (this.suggestionHandlers == null) {
            this.suggestionHandlers = new ArrayList();
        }
        this.suggestionHandlers.add(handler);
    }

    public final void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new DelegatingFocusListenerCollection(this, this.box);
        }
        this.focusListeners.add(listener);
    }

    public final void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new DelegatingKeyboardListenerCollection(this, this.box);
        }
        this.keyboardListeners.add(listener);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final SuggestOracle getSuggestOracle() {
        return this.oracle;
    }

    public final int getTabIndex() {
        return this.box.getTabIndex();
    }

    public final String getText() {
        return this.box.getText();
    }

    public final void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public final void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public final void removeEventHandler(SuggestionHandler handler) {
        if (this.suggestionHandlers == null) {
            return;
        }
        this.suggestionHandlers.remove(handler);
    }

    public final void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public final void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    public final void setAccessKey(char key) {
        this.box.setAccessKey(key);
    }

    public final void setFocus(boolean focused) {
        this.box.setFocus(focused);
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setPopupStyleName(String style) {
        this.suggestionPopup.setStyleName(style);
    }

    public final void setTabIndex(int index) {
        this.box.setTabIndex(index);
    }

    public final void setText(String text) {
        this.box.setText(text);
    }

    private void showSuggestions(Collection suggestions) {
        if (suggestions.size() > 0) {
            this.suggestionPopup.setVisible(false);
            this.suggestionMenu.clearItems();
            Iterator suggestionsIter = suggestions.iterator();
            while (suggestionsIter.hasNext()) {
                SuggestOracle.Suggestion curSuggestion = (SuggestOracle.Suggestion)suggestionsIter.next();
                final SuggestionMenuItem menuItem = new SuggestionMenuItem(curSuggestion, this.oracle.isDisplayStringHTML());
                menuItem.setCommand(new Command(){

                    public void execute() {
                        SuggestBox.this.setNewSelection(menuItem);
                    }
                });
                this.suggestionMenu.addItem(menuItem);
            }
            this.suggestionMenu.selectItem(0);
            this.suggestionPopup.showAlignedPopup();
        } else {
            this.suggestionPopup.hide();
        }
    }

    private void addKeyboardSupport() {
        this.box.addKeyboardListener(new KeyboardListenerAdapter(){

            public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                if (SuggestBox.this.suggestionPopup.isAttached()) {
                    switch (keyCode) {
                        case '(': {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() + 1);
                            break;
                        }
                        case '&': {
                            SuggestBox.this.suggestionMenu.selectItem(SuggestBox.this.suggestionMenu.getSelectedItemIndex() - 1);
                            break;
                        }
                        case '\t': 
                        case '\r': {
                            SuggestBox.this.suggestionMenu.doSelectedItemAction();
                        }
                    }
                }
            }

            public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                this.refreshSuggestions();
            }

            private void refreshSuggestions() {
                String text = SuggestBox.this.box.getText();
                if (text.equals(SuggestBox.this.currentText)) {
                    return;
                }
                SuggestBox.this.currentText = text;
                if (text.length() == 0) {
                    SuggestBox.this.suggestionPopup.hide();
                    SuggestBox.this.suggestionMenu.clearItems();
                } else {
                    SuggestBox.this.showSuggestions(text);
                }
            }
        });
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        if (this.suggestionHandlers != null) {
            SuggestionEvent event = new SuggestionEvent(this, selectedSuggestion);
            Iterator it = this.suggestionHandlers.iterator();
            while (it.hasNext()) {
                SuggestionHandler handler = (SuggestionHandler)it.next();
                handler.onSuggestionSelected(event);
            }
        }
    }

    private void setNewSelection(SuggestionMenuItem menuItem) {
        SuggestOracle.Suggestion curSuggestion = menuItem.getSuggestion();
        this.currentText = curSuggestion.getReplacementString();
        this.box.setText(this.currentText);
        this.suggestionPopup.hide();
        this.fireSuggestionEvent(curSuggestion);
    }

    private void setOracle(SuggestOracle oracle) {
        this.oracle = oracle;
    }

    private void showSuggestions(String query) {
        this.oracle.requestSuggestions(new SuggestOracle.Request(query, this.limit), this.callBack);
    }

    private class SuggestionPopup
    extends PopupPanel {
        private static final String STYLENAME_DEFAULT = "gwt-SuggestBoxPopup";

        public SuggestionPopup() {
            super(true);
            this.setWidget(SuggestBox.this.suggestionMenu);
            this.setStyleName(STYLENAME_DEFAULT);
        }

        public void showAlignedPopup() {
            this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    int left = SuggestBox.this.box.getAbsoluteLeft();
                    int offsetWidthDiff = offsetWidth - SuggestBox.this.box.getOffsetWidth();
                    if (offsetWidthDiff > 0) {
                        int windowRight = Window.getClientWidth() + Window.getScrollLeft();
                        int windowLeft = Window.getScrollLeft();
                        int distanceToWindowRight = windowRight - left;
                        int distanceFromWindowLeft = left - windowLeft;
                        if (distanceToWindowRight < offsetWidth && distanceFromWindowLeft >= offsetWidth - SuggestBox.this.box.getOffsetWidth()) {
                            left -= offsetWidthDiff;
                        }
                    }
                    int top = SuggestBox.this.box.getAbsoluteTop();
                    int windowTop = Window.getScrollTop();
                    int windowBottom = Window.getScrollTop() + Window.getClientHeight();
                    int distanceFromWindowTop = top - windowTop;
                    int distanceToWindowBottom = windowBottom - (top + SuggestBox.this.box.getOffsetHeight());
                    top = distanceToWindowBottom < offsetHeight && distanceFromWindowTop >= offsetHeight ? (top -= offsetHeight) : (top += SuggestBox.this.box.getOffsetHeight());
                    SuggestionPopup.this.setPopupPosition(left, top);
                }
            });
        }
    }

    private static class SuggestionMenuItem
    extends MenuItem {
        private static final String STYLENAME_DEFAULT = "item";
        private SuggestOracle.Suggestion suggestion;

        public SuggestionMenuItem(SuggestOracle.Suggestion suggestion, boolean asHTML) {
            super(suggestion.getDisplayString(), asHTML);
            DOM.setStyleAttribute(this.getElement(), "whiteSpace", "nowrap");
            this.setStyleName(STYLENAME_DEFAULT);
            this.setSuggestion(suggestion);
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.suggestion;
        }

        public void setSuggestion(SuggestOracle.Suggestion suggestion) {
            this.suggestion = suggestion;
        }
    }

    private static class SuggestionMenu
    extends MenuBar {
        public SuggestionMenu(boolean vertical) {
            super(vertical);
            this.setStyleName("");
        }

        public void doSelectedItemAction() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                this.doItemAction(selectedItem, true);
            }
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public void selectItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.itemOver((SuggestionMenuItem)items.get(index));
            }
        }
    }
}

