/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.linear.code39;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.CompositeModule;
import net.sourceforge.barbecue.Module;
import net.sourceforge.barbecue.SeparatorModule;
import net.sourceforge.barbecue.linear.code39.ModuleFactory;

public class Code39Barcode
extends Barcode {
    public static final String[] TYPES = new String[]{"Code39", "USD3", "3of9"};
    private final boolean requiresChecksum;
    private final String label;
    private int width = 0;

    public Code39Barcode(String string, boolean bl) throws BarcodeException {
        this(string, bl, false);
    }

    public Code39Barcode(String string, boolean bl, boolean bl2) throws BarcodeException {
        super(bl2 ? Code39Barcode.encodeExtendedChars(string) : Code39Barcode.validateBasicChars(string));
        this.requiresChecksum = bl;
        this.label = string;
    }

    protected String getLabel() {
        return this.label;
    }

    protected double getBarcodeWidth(int n) {
        this.encodeData();
        if (this.requiresChecksum) {
            this.width += 1 + this.calculateChecksum().widthInBars();
        }
        return this.barWidth * (double)this.width;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i = 0; i < this.data.length(); ++i) {
            char c = this.data.charAt(i);
            arrayList.add(new SeparatorModule(1));
            ++this.width;
            Module module = ModuleFactory.getModule(String.valueOf(c));
            arrayList.add(module);
            this.width += module.widthInBars();
        }
        arrayList.add(new SeparatorModule(1));
        ++this.width;
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            int n = Code39Barcode.calculateMod43(this.data);
            CompositeModule compositeModule = new CompositeModule();
            compositeModule.add(ModuleFactory.getModuleForIndex(n));
            compositeModule.add(new SeparatorModule(1));
            return compositeModule;
        }
        return null;
    }

    public static int calculateMod43(String string) {
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        int n2 = stringCharacterIterator.first();
        while (n2 != 65535) {
            n += ModuleFactory.getIndex(String.valueOf((char)n2));
            n2 = stringCharacterIterator.next();
        }
        n2 = n % 43;
        return n2;
    }

    protected Module getPreAmble() {
        return ModuleFactory.START_STOP;
    }

    protected Module getPostAmble() {
        return ModuleFactory.START_STOP;
    }

    private static String validateBasicChars(String string) throws BarcodeException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c), false)) {
                throw new BarcodeException("Illegal character - try using extended mode if you need to encode the full ASCII character set");
            }
            c = stringCharacterIterator.next();
        }
        return string;
    }

    private static String encodeExtendedChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c), true)) {
                stringBuffer.append(ModuleFactory.getExtendedCharacter(c));
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }
}

