/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.util.Properties;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.install.Setup;
import org.compiere.util.CLogMgt;

public class ConfigVMMac
extends Config {
    public ConfigVMMac(ConfigurationData data) {
        super(data);
    }

    public void init() {
        String javaHome = System.getProperty("java.home");
        this.log.fine(javaHome);
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - 4);
        }
        this.p_data.setJavaHome(javaHome);
        this.p_data.setAppsServerJNPPortLabel(Setup.res.getString("JNPPort"));
    }

    public String test() {
        String thisJH;
        File javaHome = new File(this.p_data.getJavaHome());
        boolean pass = javaHome.exists();
        String error = "Not found: Java Home";
        this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        if (!pass) {
            return error;
        }
        if (CLogMgt.isLevelFinest()) {
            CLogMgt.printProperties((Properties)System.getProperties(), (String)"System", (boolean)true);
        }
        this.log.info("OK: JavaHome=" + javaHome.getAbsolutePath());
        this.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        System.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        String VERSION = "1.5.0";
        String VERSION2 = "1.5.0";
        pass = false;
        String jh = javaHome.getAbsolutePath();
        if (jh.indexOf("1.5.0") != -1) {
            pass = true;
        }
        if (!pass && jh.indexOf("1.5.0") != -1) {
            pass = true;
        }
        if ((thisJH = System.getProperty("java.home")).indexOf(jh) != -1) {
            String thisJV = System.getProperty("java.version");
            boolean bl = pass = thisJV.indexOf("1.5.0") != -1;
            if (!pass && thisJV.indexOf("1.5.0") != -1) {
                pass = true;
            }
            if (pass) {
                this.log.info("OK: Version=" + thisJV);
            }
        }
        error = "Wrong Java Version: Should be 1.5.0";
        this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        if (!pass) {
            return error;
        }
        this.setProperty("COMPIERE_JAVA_TYPE", this.p_data.getJavaType());
        return null;
    }
}

