/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.compiler;

import java.io.File;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.Type;
import org.jboss.logging.Logger;
import org.jboss.proxy.compiler.Proxies;
import org.jboss.proxy.compiler.ProxyImplementationFactory;
import org.jboss.proxy.compiler.Runtime;
import org.jboss.proxy.compiler.Utility;

public class ProxyCompiler {
    private static final Logger log = Logger.getLogger((Class)ProxyCompiler.class);
    public static final String CLASS_DUMP_PATH = System.getProperty(ProxyCompiler.class.getName() + ".dumpPath", null);
    public static final String IMPL_SUFFIX = "$Proxy";
    Runtime runtime;
    Class superclass;
    Class[] targetTypes;
    java.lang.reflect.Method[] methods;
    Class proxyType;

    public ProxyCompiler(ClassLoader parent, Class superclass, Class[] targetTypes, java.lang.reflect.Method[] methods) throws Exception {
        this.superclass = superclass;
        this.targetTypes = targetTypes;
        this.methods = methods;
        this.runtime = new Runtime(parent);
        this.runtime.targetTypes = targetTypes;
        this.runtime.methods = methods;
        this.runtime.makeProxyType(this);
    }

    public Class getProxyType() {
        return this.proxyType;
    }

    public String getProxyClassName() {
        return this.targetTypes[0].getName() + IMPL_SUFFIX;
    }

    public byte[] getCode() {
        boolean trace = log.isTraceEnabled();
        String proxyClassName = this.getProxyClassName();
        String superClassName = this.superclass.getName();
        int icount = 1;
        for (int i = 0; i < this.targetTypes.length; ++i) {
            Class targetType = this.targetTypes[i];
            if (!targetType.isInterface()) continue;
            ++icount;
        }
        String[] interfaceNames = new String[icount];
        interfaceNames[0] = Proxies.ProxyTarget.class.getName();
        icount = 1;
        for (int i = 0; i < this.targetTypes.length; ++i) {
            Class targetType = this.targetTypes[i];
            if (targetType.isInterface()) {
                interfaceNames[icount++] = targetType.getName();
                continue;
            }
            if (this.superclass.isAssignableFrom(targetType)) continue;
            throw new RuntimeException("unexpected: " + targetType);
        }
        ClassGen cg = new ClassGen(proxyClassName, superClassName, "<generated>", 17, interfaceNames);
        ProxyImplementationFactory factory = new ProxyImplementationFactory(superClassName, proxyClassName, cg);
        cg.addField(factory.createInvocationHandlerField());
        cg.addField(factory.createRuntimeField());
        cg.addMethod(factory.createConstructor());
        cg.addMethod(factory.createGetInvocationHandler());
        cg.addMethod(factory.createGetTargetTypes());
        boolean haveToString = false;
        if (trace) {
            log.trace((Object)"Creating proxy methods...");
        }
        for (int i = 0; i < this.methods.length; ++i) {
            java.lang.reflect.Method m = this.methods[i];
            if (trace) {
                log.trace((Object)("Reflected method: " + m));
            }
            String name = m.getName();
            Class<?> rTypeClass = m.getReturnType();
            String rTypeName = rTypeClass.getName();
            Type rType = Utility.getType(rTypeClass);
            Type[] pTypes = Utility.getTypes(m.getParameterTypes());
            String[] exceptionNames = this.getNames(m.getExceptionTypes());
            if (name.equals("toString") && pTypes.length == 0) {
                haveToString = true;
            }
            Method proxyMethod = factory.createProxyMethod(name, i, rType, pTypes, exceptionNames);
            if (trace) {
                log.trace((Object)("Created proxy method: " + proxyMethod));
            }
            cg.addMethod(proxyMethod);
        }
        if (!haveToString) {
            cg.addMethod(factory.createToString());
        }
        JavaClass jclass = cg.getJavaClass();
        if (trace) {
            log.trace((Object)("Generated Java class: " + jclass));
        }
        if (CLASS_DUMP_PATH != null) {
            try {
                String filename = CLASS_DUMP_PATH + File.separator + proxyClassName + ".class";
                log.info((Object)("Dumping generated proxy class to " + filename));
                jclass.dump(filename);
            }
            catch (Exception e) {
                log.error((Object)"Failed to dump class file", (Throwable)e);
            }
        }
        return jclass.getBytes();
    }

    private String[] getNames(Class[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }
}

