/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Compiere;
import org.compiere.model.MColumn;
import org.compiere.print.PrintDataColumn;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintDataHandler;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintData
implements Serializable {
    private Ctx m_ctx;
    private String m_name;
    private ArrayList<ArrayList<Object>> m_rows = new ArrayList();
    private ArrayList<Object> m_nodes = null;
    private int m_row = -1;
    private ArrayList<Integer> m_functionRows = new ArrayList();
    private boolean m_hasLevelNo = false;
    private static final String LEVEL_NO = "LEVELNO";
    private PrintDataColumn[] m_columnInfo = null;
    private String m_sql = null;
    private String m_TableName = null;
    public static final String XML_TAG = "compiereData";
    public static final String XML_ROW_TAG = "row";
    public static final String XML_ATTRIBUTE_NAME = "name";
    public static final String XML_ATTRIBUTE_COUNT = "count";
    public static final String XML_ATTRIBUTE_NO = "no";
    public static final String XML_ATTRIBUTE_FUNCTION_ROW = "function_row";
    private static CLogger log = CLogger.getCLogger(PrintData.class);

    public PrintData(Ctx ctx, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.m_ctx = ctx;
        this.m_name = name;
    }

    public PrintData(Ctx ctx, String name, ArrayList<Object> nodes) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.m_ctx = ctx;
        this.m_name = name;
        if (nodes != null) {
            this.m_nodes = nodes;
        }
    }

    public Ctx getCtx() {
        return this.m_ctx;
    }

    public String getName() {
        return this.m_name;
    }

    public void setColumnInfo(PrintDataColumn[] newInfo) {
        this.m_columnInfo = newInfo;
    }

    public PrintDataColumn[] getColumnInfo() {
        return this.m_columnInfo;
    }

    public void setSQL(String sql) {
        this.m_sql = sql;
    }

    public String getSQL() {
        return this.m_sql;
    }

    public void setTableName(String TableName) {
        this.m_TableName = TableName;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PrintData[");
        sb.append(this.m_name).append(",Rows=").append(this.m_rows.size());
        if (this.m_TableName != null) {
            sb.append(",TableName=").append(this.m_TableName);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isEmpty() {
        if (this.m_nodes == null) {
            return true;
        }
        return this.m_nodes.size() == 0;
    }

    public int getNodeCount() {
        if (this.m_nodes == null) {
            return 0;
        }
        return this.m_nodes.size();
    }

    public void addRow(boolean functionRow, int levelNo) {
        this.m_nodes = new ArrayList();
        this.m_row = this.m_rows.size();
        this.m_rows.add(this.m_nodes);
        if (functionRow) {
            this.m_functionRows.add(new Integer(this.m_row));
        }
        if (this.m_hasLevelNo && levelNo != 0) {
            this.addNode(new PrintDataElement(LEVEL_NO, new Integer(levelNo), 11));
        }
    }

    public boolean setRowIndex(int row) {
        if (row < 0 || row >= this.m_rows.size()) {
            return false;
        }
        this.m_row = row;
        this.m_nodes = this.m_rows.get(this.m_row);
        return true;
    }

    public boolean setRowNext() {
        return this.setRowIndex(this.m_row + 1);
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public int getRowIndex() {
        return this.m_row;
    }

    public boolean isFunctionRow(int row) {
        return this.m_functionRows.contains(new Integer(row));
    }

    public boolean isFunctionRow() {
        return this.m_functionRows.contains(new Integer(this.m_row));
    }

    public boolean isPageBreak() {
        if (this.isFunctionRow() && this.m_nodes != null) {
            for (int i = 0; i < this.m_nodes.size(); ++i) {
                PrintDataElement pde;
                Object o = this.m_nodes.get(i);
                if (!(o instanceof PrintDataElement) || !(pde = (PrintDataElement)o).isPageBreak()) continue;
                return true;
            }
        }
        return false;
    }

    public void setHasLevelNo(boolean hasLevelNo) {
        this.m_hasLevelNo = hasLevelNo;
    }

    public boolean hasLevelNo() {
        return this.m_hasLevelNo;
    }

    public int getLineLevelNo() {
        if (this.m_nodes == null || !this.m_hasLevelNo) {
            return 0;
        }
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            PrintDataElement pde;
            Object o = this.m_nodes.get(i);
            if (!(o instanceof PrintDataElement) || !LEVEL_NO.equals((pde = (PrintDataElement)o).getColumnName())) continue;
            Integer ii = (Integer)pde.getValue();
            return ii;
        }
        return 0;
    }

    public void addNode(PrintData parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        if (this.m_nodes == null) {
            this.addRow(false, 0);
        }
        this.m_nodes.add(parent);
    }

    public void addNode(PrintDataElement node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        if (this.m_nodes == null) {
            this.addRow(false, 0);
        }
        this.m_nodes.add(node);
    }

    public Object getNode(int index) {
        if (this.m_nodes == null || index < 0 || index >= this.m_nodes.size()) {
            return null;
        }
        return this.m_nodes.get(index);
    }

    public Object getNode(String name) {
        int index = this.getIndex(name);
        if (index < 0) {
            return null;
        }
        return this.m_nodes.get(index);
    }

    public Object getNode(Integer AD_Column_ID) {
        int index = this.getIndex(AD_Column_ID);
        if (index < 0) {
            return null;
        }
        return this.m_nodes.get(index);
    }

    public PrintDataElement getPKey() {
        if (this.m_nodes == null) {
            return null;
        }
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            PrintDataElement pde;
            Object o = this.m_nodes.get(i);
            if (!(o instanceof PrintDataElement) || !(pde = (PrintDataElement)o).isPKey()) continue;
            return pde;
        }
        return null;
    }

    public int getIndex(String columnName) {
        if (this.m_nodes == null) {
            return -1;
        }
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            Object o = this.m_nodes.get(i);
            if (o instanceof PrintDataElement) {
                if (!columnName.equals(((PrintDataElement)o).getColumnName())) continue;
                return i;
            }
            if (o instanceof PrintData) {
                if (!columnName.equals(((PrintData)o).getName())) continue;
                return i;
            }
            log.log(Level.SEVERE, "Element not PrintData(Element) " + o.getClass().getName());
        }
        return -1;
    }

    public int getIndex(int AD_Column_ID) {
        if (this.m_columnInfo == null) {
            return -1;
        }
        for (int i = 0; i < this.m_columnInfo.length; ++i) {
            if (this.m_columnInfo[i].getAD_Column_ID() != AD_Column_ID) continue;
            return this.getIndex(this.m_columnInfo[i].getColumnName());
        }
        MColumn col = MColumn.get((Ctx)this.getCtx(), (int)AD_Column_ID);
        if (col != null && col.isVirtualColumn()) {
            return -1;
        }
        log.log(Level.WARNING, "Column not found - AD_Column_ID=" + AD_Column_ID);
        if (AD_Column_ID == 0) {
            Trace.printStack();
        }
        return -1;
    }

    public void dump() {
        PrintData.dump(this);
    }

    public void dumpHeader() {
        PrintData.dumpHeader(this);
    }

    public void dumpCurrentRow() {
        PrintData.dumpRow(this, this.m_row);
    }

    private static void dump(PrintData pd) {
        PrintData.dumpHeader(pd);
        for (int i = 0; i < pd.getRowCount(); ++i) {
            PrintData.dumpRow(pd, i);
        }
    }

    private static void dumpHeader(PrintData pd) {
        log.info(pd.toString());
        if (pd.getColumnInfo() != null) {
            for (int i = 0; i < pd.getColumnInfo().length; ++i) {
                log.config(i + ": " + pd.getColumnInfo()[i]);
            }
        }
    }

    private static void dumpRow(PrintData pd, int row) {
        log.info("Row #" + row);
        if (row < 0 || row >= pd.getRowCount()) {
            log.warning("- invalid -");
            return;
        }
        pd.setRowIndex(row);
        if (pd.getNodeCount() == 0) {
            log.config("- n/a -");
            return;
        }
        for (int i = 0; i < pd.getNodeCount(); ++i) {
            Object obj = pd.getNode(i);
            if (obj == null) {
                log.config("- NULL -");
                continue;
            }
            if (obj instanceof PrintData) {
                log.config("- included -");
                PrintData.dump((PrintData)obj);
                continue;
            }
            if (obj instanceof PrintDataElement) {
                log.config(((PrintDataElement)obj).toStringX());
                continue;
            }
            log.config("- INVALID: " + obj);
        }
    }

    public Document getDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            document.appendChild(document.createComment(Compiere.getSummaryAscii()));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        Element root = document.createElement(XML_TAG);
        root.setAttribute(XML_ATTRIBUTE_NAME, this.getName());
        root.setAttribute(XML_ATTRIBUTE_COUNT, String.valueOf(this.getRowCount()));
        document.appendChild(root);
        PrintData.processXML(this, document, root);
        return document;
    }

    private static void processXML(PrintData pd, Document document, Element root) {
        for (int r = 0; r < pd.getRowCount(); ++r) {
            pd.setRowIndex(r);
            Element row = document.createElement(XML_ROW_TAG);
            row.setAttribute(XML_ATTRIBUTE_NO, String.valueOf(r));
            if (pd.isFunctionRow()) {
                row.setAttribute(XML_ATTRIBUTE_FUNCTION_ROW, "yes");
            }
            root.appendChild(row);
            for (int i = 0; i < pd.getNodeCount(); ++i) {
                Element element;
                Object o = pd.getNode(i);
                if (o instanceof PrintData) {
                    PrintData pd_x = (PrintData)o;
                    element = document.createElement(XML_TAG);
                    element.setAttribute(XML_ATTRIBUTE_NAME, pd_x.getName());
                    element.setAttribute(XML_ATTRIBUTE_COUNT, String.valueOf(pd_x.getRowCount()));
                    row.appendChild(element);
                    PrintData.processXML(pd_x, document, element);
                    continue;
                }
                if (o instanceof PrintDataElement) {
                    PrintDataElement pde = (PrintDataElement)o;
                    if (pde.isNull()) continue;
                    element = document.createElement("element");
                    element.setAttribute(XML_ATTRIBUTE_NAME, pde.getColumnName());
                    if (pde.hasKey()) {
                        element.setAttribute("key", pde.getValueKey());
                    }
                    element.appendChild(document.createTextNode(pde.getValueDisplay(null)));
                    row.appendChild(element);
                    continue;
                }
                log.log(Level.SEVERE, "Element not PrintData(Element) " + o.getClass().getName());
            }
        }
    }

    public boolean createXML(StreamResult result) {
        try {
            DOMSource source = new DOMSource(this.getDocument());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(StreamResult)", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean createXML(String fileName) {
        try {
            File file = new File(fileName);
            file.createNewFile();
            StreamResult result = new StreamResult(file);
            this.createXML(result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(file)", (Throwable)e);
            return false;
        }
        return true;
    }

    public static PrintData parseXML(Ctx ctx, File input) {
        log.config(input.toString());
        PrintData pd = null;
        try {
            PrintDataHandler handler = new PrintDataHandler(ctx);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(input, (DefaultHandler)handler);
            pd = handler.getPrintData();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        return pd;
    }

    public static void main(String[] args) {
        PrintData pd = new PrintData(new Ctx(), "test1");
        pd.addNode(new PrintDataElement("test1element1", "testvalue<1>", 0));
        pd.addNode(new PrintDataElement("test1element2", "testvalue&2&", 0));
        PrintData pdx = new PrintData(new Ctx(), "test2");
        pdx.addNode(new PrintDataElement("test2element1-1", "testvalue11", 0));
        pdx.addNode(new PrintDataElement("test2element1-2", "testvalue12", 0));
        pdx.addRow(false, 0);
        pdx.addNode(new PrintDataElement("test2element2-1", "testvalue21", 0));
        pdx.addNode(new PrintDataElement("test2element2-2", "testvalue22", 0));
        pd.addNode(pdx);
        pd.addNode(new PrintDataElement("test1element3", "testvalue/3/", 0));
        pd.createXML("C:\\Temp\\printData.xml");
        pd.createXML(new StreamResult(System.out));
        System.out.println("");
        pd.dump();
        System.out.println("");
        PrintData pd1 = PrintData.parseXML(new Ctx(), new File("C:\\Temp\\printData.xml"));
        pd1.createXML(new StreamResult(System.out));
        System.out.println("");
        pd1.dump();
    }
}

