/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.Ctx;

public class BarcodeElement
extends PrintElement {
    private boolean m_valid = true;
    private Barcode m_barcode = null;

    public BarcodeElement(String code, MPrintFormatItem item) {
        if (code == null || code.length() == 0 || item == null || item.getBarcodeType() == null || item.getBarcodeType().length() == 0) {
            this.m_valid = false;
        }
        this.createBarcode(code, item);
        if (this.m_barcode == null) {
            this.m_valid = false;
        }
    }

    private void createBarcode(String code, MPrintFormatItem item) {
        String type = item.getBarcodeType();
        try {
            if (type.equals("2o9")) {
                this.m_barcode = BarcodeFactory.create2of7((String)code);
            } else if (type.equals("MON")) {
                this.m_barcode = BarcodeFactory.createMonarch((String)code);
            } else if (type.equals("NW7")) {
                this.m_barcode = BarcodeFactory.createNW7((String)code);
            } else if (type.equals("US4")) {
                this.m_barcode = BarcodeFactory.createUSD4((String)code);
            } else if (type.equals("28A")) {
                this.m_barcode = BarcodeFactory.createCode128A((String)code);
            } else if (type.equals("28B")) {
                this.m_barcode = BarcodeFactory.createCode128B((String)code);
            } else if (type.equals("28C")) {
                this.m_barcode = BarcodeFactory.createCode128C((String)code);
            } else if (type.equals("C28")) {
                this.m_barcode = BarcodeFactory.createCode128((String)code);
            } else if (type.equals("3O9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)true);
            } else if (type.equals("3o9")) {
                this.m_barcode = BarcodeFactory.create3of9((String)code, (boolean)false);
            } else if (type.equals("C39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)true);
            } else if (type.equals("c39")) {
                this.m_barcode = BarcodeFactory.createCode39((String)code, (boolean)false);
            } else if (type.equals("US3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)true);
            } else if (type.equals("us3")) {
                this.m_barcode = BarcodeFactory.createUSD3((String)code, (boolean)false);
            } else if (type.equals("COD")) {
                this.m_barcode = BarcodeFactory.createCodabar((String)code);
            } else if (type.equals("E28")) {
                this.m_barcode = BarcodeFactory.createEAN128((String)code);
            } else if (type.equals("GTN")) {
                this.m_barcode = BarcodeFactory.createGlobalTradeItemNumber((String)code);
            } else if (type.equals("417")) {
                this.m_barcode = BarcodeFactory.createPDF417((String)code);
            } else if (type.equals("C14")) {
                this.m_barcode = BarcodeFactory.createSCC14ShippingCode((String)code);
            } else if (type.equals("SID")) {
                this.m_barcode = BarcodeFactory.createShipmentIdentificationNumber((String)code);
            } else if (type.equals("C18")) {
                this.m_barcode = BarcodeFactory.createSSCC18((String)code);
            } else if (type.equals("U28")) {
                this.m_barcode = BarcodeFactory.createUCC128((String)"01", (String)code);
            } else if (type.equals("USP")) {
                this.m_barcode = BarcodeFactory.createUSPS((String)code);
                this.m_barcode.setDrawingText(false);
            } else {
                this.log.warning("Invalid Type" + type);
            }
        }
        catch (Exception e) {
            this.log.warning(code + " - " + e.toString());
            this.m_valid = false;
        }
        if (this.m_valid && this.m_barcode != null) {
            MPrintFont mFont;
            this.p_info = "BarCodeType=" + type;
            if (item.getAD_PrintFont_ID() != 0 && (mFont = MPrintFont.get(item.getAD_PrintFont_ID())) != null) {
                this.m_barcode.setFont(mFont.getFont());
            }
            if (item.getMaxWidth() > 0) {
                this.m_barcode.setBarWidth((double)item.getMaxWidth());
            }
            if (item.getMaxHeight() > 0) {
                this.m_barcode.setBarHeight((double)item.getMaxHeight());
            }
            this.p_width = this.m_barcode.getWidth();
            this.p_height = this.m_barcode.getHeight();
            this.log.fine(type + " height=" + this.p_height + ", width=" + this.p_width);
        }
    }

    public Barcode getBarcode() {
        return this.m_barcode;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    protected boolean calculateSize() {
        return true;
    }

    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Ctx ctx, boolean isView) {
        if (!this.m_valid || this.m_barcode == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        this.m_barcode.draw(g2D, x, y);
    }

    public String toString() {
        if (this.m_barcode == null) {
            return super.toString();
        }
        return super.toString() + " " + this.m_barcode.getData();
    }
}

