/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.plugins.helpers.AbstractPluginWrapper;
import org.jboss.management.j2ee.J2EEDomainMBean;
import org.jboss.management.j2ee.J2EEServerMBean;
import org.jboss.mx.util.MBeanProxy;

public class JSR77Lister
extends AbstractPluginWrapper {
    protected static final String JMX_JSR77_DOMAIN = "jboss.management.local";
    public static final String[] DEFAULT_SUFFIX_ORDER = new String[]{"ear", "jar", "war", "sar", "rar", "ds.xml", "service.xml", "wsr", "zip"};
    static /* synthetic */ Class class$org$jboss$management$j2ee$J2EEServerMBean;
    static /* synthetic */ Class class$org$jboss$management$j2ee$J2EEServer;
    static /* synthetic */ Class class$org$jboss$management$j2ee$J2EEDomainMBean;

    TreeNode createSubResources(String[] resources) throws Exception {
        ResourceTreeNode[] deployed = new ResourceTreeNode[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ObjectName objectName = new ObjectName(resources[i]);
            deployed[i] = this.createResourceNode(objectName.getKeyProperty("name"), "J2EE Resource", null, null, null, null, null, resources[i].toString(), this.mbeanServer.getMBeanInfo(objectName).getClassName()).setVisibility(2);
        }
        return this.createTreeNode("J2EE Resources", "J2EE Resources", "images/spirale.gif", null, null, null, deployed);
    }

    ResourceTreeNode[] createDeployedObjects(String[] resources) throws Exception {
        ArrayList<ResourceTreeNode> deployed = new ArrayList<ResourceTreeNode>();
        for (int i = 0; i < resources.length; ++i) {
            ObjectName objectName = new ObjectName(resources[i]);
            deployed.add(this.createResourceNode(objectName.getKeyProperty("name"), "", "images/EspressoMaker.gif", null, null, null, null, resources[i].toString(), this.mbeanServer.getMBeanInfo(objectName).getClassName()).setVisibility(2));
        }
        Collections.sort(deployed, new ListerSorter());
        return deployed.toArray(new ResourceTreeNode[deployed.size()]);
    }

    ResourceTreeNode createServer(String serverName) throws Exception {
        ObjectName objectName = new ObjectName(serverName);
        J2EEServerMBean serv = (J2EEServerMBean)MBeanProxy.get((Class)(class$org$jboss$management$j2ee$J2EEServerMBean == null ? (class$org$jboss$management$j2ee$J2EEServerMBean = JSR77Lister.class$("org.jboss.management.j2ee.J2EEServerMBean")) : class$org$jboss$management$j2ee$J2EEServerMBean), (ObjectName)objectName, (MBeanServer)this.getMBeanServer());
        String[] deployedON = serv.getdeployedObjects();
        ResourceTreeNode[] subResArray = this.createDeployedObjects(deployedON);
        return this.createResourceNode(serv.getserverVendor() + " - " + serv.getserverVersion(), objectName.getKeyProperty("name"), "images/database.gif", null, null, new TreeNode[]{this.createSubResources(serv.getresources())}, subResArray, serverName.toString(), (class$org$jboss$management$j2ee$J2EEServer == null ? (class$org$jboss$management$j2ee$J2EEServer = JSR77Lister.class$("org.jboss.management.j2ee.J2EEServer")) : class$org$jboss$management$j2ee$J2EEServer).getName());
    }

    ResourceTreeNode[] createServers(ObjectName domain) throws Exception {
        J2EEDomainMBean dom = (J2EEDomainMBean)MBeanProxy.get((Class)(class$org$jboss$management$j2ee$J2EEDomainMBean == null ? (class$org$jboss$management$j2ee$J2EEDomainMBean = JSR77Lister.class$("org.jboss.management.j2ee.J2EEDomainMBean")) : class$org$jboss$management$j2ee$J2EEDomainMBean), (ObjectName)domain, (MBeanServer)this.getMBeanServer());
        String[] serversObjectNames = dom.getservers();
        ArrayList<ResourceTreeNode> servers = new ArrayList<ResourceTreeNode>();
        for (int i = 0; i < serversObjectNames.length; ++i) {
            servers.add(this.createServer(serversObjectNames[i]));
        }
        return servers.toArray(new ResourceTreeNode[servers.size()]);
    }

    TreeNode createDomain(ObjectName domain) throws Exception {
        return this.createTreeNode(domain.getKeyProperty("name"), "", "images/spirale.gif", null, null, null, this.createServers(domain));
    }

    TreeNode[] createDomains() throws Exception {
        ObjectInstance[] insts = this.getMBeansForQuery("jboss.management.local:j2eeType=J2EEDomain,*", null);
        TreeNode[] domains = new TreeNode[insts.length];
        for (int i = 0; i < insts.length; ++i) {
            domains[i] = this.createDomain(insts[i].getObjectName());
        }
        return domains;
    }

    protected TreeNode getTreeForResource(String profile, ManageableResource resource) {
        try {
            return this.createTreeNode("J2EE Domains", "Display JSR-77 Managed Objects", "images/elements32.gif", null, null, this.createDomains(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ListerSorter
    implements Comparator {
        protected String[] suffixOrder;

        public ListerSorter(String[] suffixOrder) {
            this.suffixOrder = suffixOrder;
        }

        public ListerSorter() {
            this(DEFAULT_SUFFIX_ORDER);
        }

        public int compare(Object o1, Object o2) {
            return this.getExtensionIndex((ResourceTreeNode)o1) - this.getExtensionIndex((ResourceTreeNode)o2);
        }

        public int getExtensionIndex(ResourceTreeNode node) {
            int i;
            String name = node.getName();
            if (name == null) {
                name = "";
            }
            for (i = 0; i < this.suffixOrder.length && !name.endsWith(this.suffixOrder[i]); ++i) {
            }
            return i;
        }
    }
}

