/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

class ClobAccessor
extends Accessor {
    static final int maxLength = 4000;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:09_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    ClobAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 112, 112, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ClobAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 112, 112, s2, false);
        this.initForDescribe(112, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 4000;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    Object getObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    Object getObject(int n2, Map map) throws SQLException {
        return this.getCLOB(n2);
    }

    Datum getOracleObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    CLOB getCLOB(int n2) throws SQLException {
        CLOB cLOB = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            cLOB = this.formOfUse == 1 ? new CLOB(this.statement.connection, byArray, this.formOfUse) : new NCLOB(this.statement.connection, byArray);
        }
        return cLOB;
    }

    InputStream getAsciiStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    Reader getCharacterStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getCharacterStream();
    }

    InputStream getBinaryStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    String getString(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        Reader reader = cLOB.getCharacterStream();
        int n3 = cLOB.getBufferSize();
        int n4 = 0;
        StringWriter stringWriter = new StringWriter(n3);
        char[] cArray = new char[n3];
        try {
            while ((n4 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 151);
        }
        if (cLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(cLOB);
        }
        return stringWriter.getBuffer().substring(0);
    }

    byte[] privateGetBytes(int n2) throws SQLException {
        return super.getBytes(n2);
    }

    byte[] getBytes(int n2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }
}

