/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public final class ImpFormat {
    private static CLogger log = CLogger.getCLogger(ImpFormat.class);
    private String m_name;
    private String m_formatType;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_tablePK;
    private String m_tableUnique1;
    private String m_tableUnique2;
    private String m_tableUniqueParent;
    private String m_tableUniqueChild;
    private String m_BPartner;
    private ArrayList<ImpFormatRow> m_rows = new ArrayList();
    public static final String FORMATTYPE_FIXED = "F";
    public static final String FORMATTYPE_COMMA = "C";
    public static final String FORMATTYPE_TAB = "T";
    public static final String FORMATTYPE_XML = "X";

    public ImpFormat(String name, int AD_Table_ID, String formatType) {
        this.setName(name);
        this.setTable(AD_Table_ID);
        this.setFormatType(formatType);
    }

    public void setName(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("Name must be at least 1 char");
        }
        this.m_name = newName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setTable(int AD_Table_ID) {
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = null;
        this.m_tablePK = null;
        String sql = "SELECT t.TableName,c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID AND c.IsKey='Y') WHERE t.AD_Table_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_tableName = rs.getString(1);
                this.m_tablePK = rs.getString(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "ImpFormat.setTable", (Throwable)e);
        }
        if (this.m_tableName == null || this.m_tablePK == null) {
            log.log(Level.SEVERE, "Data not found for AD_Table_ID=" + AD_Table_ID);
        }
        this.m_tableUnique1 = "";
        this.m_tableUnique2 = "";
        this.m_tableUniqueParent = "";
        this.m_tableUniqueChild = "";
        if (this.m_AD_Table_ID == 311) {
            this.m_tableUnique1 = "H_UPC";
            this.m_tableUnique2 = "Value";
            this.m_tableUniqueChild = "H_Commodity1";
            this.m_tableUniqueParent = "H_PartnrID";
        } else if (this.m_AD_Table_ID == 532) {
            this.m_tableUnique1 = "UPC";
            this.m_tableUnique2 = "Value";
            this.m_tableUniqueChild = "VendorProductNo";
            this.m_tableUniqueParent = "BPartner_Value";
        } else if (this.m_AD_Table_ID == 533) {
            this.m_tableUnique1 = "Value";
        } else if (this.m_AD_Table_ID == 534) {
            this.m_tableUniqueParent = "ElementName";
            this.m_tableUniqueChild = "Value";
        } else if (this.m_AD_Table_ID == 535) {
            this.m_tableUniqueParent = "ReportLineSetName";
            this.m_tableUniqueChild = "Name";
        }
    }

    public int getAD_Table_ID() {
        return this.m_AD_Table_ID;
    }

    public void setFormatType(String newFormatType) {
        if (!(newFormatType.equals(FORMATTYPE_FIXED) || newFormatType.equals(FORMATTYPE_COMMA) || newFormatType.equals(FORMATTYPE_TAB) || newFormatType.equals(FORMATTYPE_XML))) {
            throw new IllegalArgumentException("FormatType must be F/C/T/X");
        }
        this.m_formatType = newFormatType;
    }

    public String getFormatType() {
        return this.m_formatType;
    }

    public void setBPartner(String newBPartner) {
        this.m_BPartner = newBPartner;
    }

    public String getBPartner() {
        return this.m_BPartner;
    }

    public void addRow(ImpFormatRow row) {
        this.m_rows.add(row);
    }

    public ImpFormatRow getRow(int index) {
        if (index >= 0 && index < this.m_rows.size()) {
            return this.m_rows.get(index);
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public static ImpFormat load(String name) {
        log.config(name);
        ImpFormat retValue = null;
        String sql = "SELECT * FROM AD_ImpFormat WHERE Name=?";
        int ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, name);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new ImpFormat(name, rs.getInt("AD_Table_ID"), rs.getString("FormatType"));
                ID = rs.getInt("AD_ImpFormat_ID");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
            return null;
        }
        ImpFormat.loadRows(retValue, ID);
        return retValue;
    }

    private static void loadRows(ImpFormat format, int ID) {
        String sql = "SELECT f.SeqNo,c.ColumnName,f.StartNo,f.EndNo,f.DataType,c.FieldLength,f.DataFormat,f.DecimalPoint,f.DivideBy100,f.ConstantValue,f.Callout FROM AD_ImpFormat_Row f,AD_Column c WHERE f.AD_ImpFormat_ID=? AND f.AD_Column_ID=c.AD_Column_ID AND f.IsActive='Y'ORDER BY f.SeqNo";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ImpFormatRow row = new ImpFormatRow(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getString(5), rs.getInt(6));
                row.setFormatInfo(rs.getString(7), rs.getString(8), rs.getString(9).equals("Y"), rs.getString(10), rs.getString(11));
                format.addRow(row);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public String[] parseLine(String line, boolean withLabel, boolean trace, boolean ignoreEmpty) {
        if (trace) {
            log.config("" + line);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.m_rows.size(); ++i) {
            ImpFormatRow row = this.m_rows.get(i);
            StringBuffer entry = new StringBuffer();
            if (withLabel) {
                entry.append(row.getColumnName());
                entry.append("=");
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("TO_DATE('");
                }
            }
            String info = null;
            if (row.isConstant()) {
                info = "Constant";
            } else if (this.m_formatType.equals(FORMATTYPE_FIXED)) {
                if (row.getStartNo() > 0 && row.getEndNo() <= line.length()) {
                    info = line.substring(row.getStartNo() - 1, row.getEndNo());
                }
            } else {
                info = this.parseFlexFormat(line, this.m_formatType, row.getStartNo());
            }
            if (info == null) {
                info = "";
            }
            entry.append(row.parse(info));
            if (withLabel) {
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("','YYYY-MM-DD HH24:MI:SS')");
                }
            }
            if (!ignoreEmpty || ignoreEmpty && info.length() != 0) {
                list.add(entry.toString());
            }
            if (!trace) continue;
            log.fine(info + "=>" + entry.toString() + " (Length=" + info.length() + ")");
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private String parseFlexFormat(String line, String formatType, int fieldNo) {
        int QUOTE = 34;
        char delimiter = ' ';
        if (formatType.equals(FORMATTYPE_COMMA)) {
            delimiter = ',';
        } else if (formatType.equals(FORMATTYPE_TAB)) {
            delimiter = '\t';
        } else {
            throw new IllegalArgumentException("ImpFormat.parseFlexFormat - unknown format: " + formatType);
        }
        if (line == null || line.length() == 0 || fieldNo < 0) {
            return "";
        }
        int pos = 0;
        int length = line.length();
        for (int field = 1; field <= fieldNo && pos < length; ++field) {
            StringBuffer content = new StringBuffer();
            if (line.charAt(pos) == delimiter) {
                ++pos;
                continue;
            }
            if (line.charAt(pos) == '\"') {
                ++pos;
                while (pos < length) {
                    if (line.charAt(pos) == '\"' && pos + 1 < length && line.charAt(pos + 1) == '\"') {
                        content.append(line.charAt(pos++));
                        ++pos;
                        continue;
                    }
                    if (line.charAt(pos) == '\"') {
                        ++pos;
                        break;
                    }
                    content.append(line.charAt(pos++));
                }
                if (pos < length && line.charAt(pos) != delimiter) {
                    log.info("Did not find delimiter at pos " + pos + " " + line);
                }
                ++pos;
            } else {
                while (pos < length && line.charAt(pos) != delimiter) {
                    content.append(line.charAt(pos++));
                }
                ++pos;
            }
            if (field != fieldNo) continue;
            return content.toString();
        }
        return "";
    }

    public boolean updateDB(Ctx ctx, String line, String trxName) {
        if (line == null || line.trim().length() == 0) {
            log.finest("No Line");
            return false;
        }
        String[] nodes = this.parseLine(line, true, false, true);
        if (nodes.length == 0) {
            log.finest("Nothing parsed from: " + line);
            return false;
        }
        int AD_Client_ID = ctx.getAD_Client_ID();
        int AD_Org_ID = ctx.getAD_Org_ID();
        if (this.getAD_Table_ID() == 599) {
            AD_Org_ID = 0;
        }
        int UpdatedBy = ctx.getAD_User_ID();
        StringBuffer sql = new StringBuffer("SELECT COUNT(*), MAX(").append(this.m_tablePK).append(") FROM ").append(this.m_tableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID).append(" AND (");
        String where1 = null;
        String where2 = null;
        String whereParentChild = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].endsWith("=''") || nodes[i].endsWith("=0")) continue;
            if (nodes[i].startsWith(this.m_tableUnique1 + "=")) {
                where1 = nodes[i];
                continue;
            }
            if (nodes[i].startsWith(this.m_tableUnique2 + "=")) {
                where2 = nodes[i];
                continue;
            }
            if (!nodes[i].startsWith(this.m_tableUniqueParent + "=") && !nodes[i].startsWith(this.m_tableUniqueChild + "=")) continue;
            whereParentChild = whereParentChild == null ? nodes[i] : whereParentChild + " AND " + nodes[i];
        }
        StringBuffer find = new StringBuffer();
        if (where1 != null) {
            find.append(where1);
        }
        if (where2 != null) {
            if (find.length() > 0) {
                find.append(" OR ");
            }
            find.append(where2);
        }
        if (whereParentChild != null && whereParentChild.indexOf(" AND ") != -1) {
            if (find.length() > 0) {
                find.append(" OR (").append(whereParentChild).append(")");
            } else {
                find.append(whereParentChild);
            }
        }
        sql.append(find).append(")");
        int count = 0;
        int ID = 0;
        try {
            if (find.length() > 0) {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next() && (count = rs.getInt(1)) == 1) {
                    ID = rs.getInt(2);
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            return false;
        }
        if (ID == 0) {
            ID = DB.getNextID((Ctx)ctx, (String)this.m_tableName, null);
            sql = new StringBuffer("INSERT INTO ").append(this.m_tableName).append("(").append(this.m_tablePK).append(",").append("AD_Client_ID,AD_Org_ID,Created,CreatedBy,Updated,UpdatedBy,IsActive").append(") VALUES (").append(ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",SysDate,").append(UpdatedBy).append(",SysDate,").append(UpdatedBy).append(",'Y'").append(")");
            int no = DB.executeUpdate((String)sql.toString(), (String)trxName);
            if (no != 1) {
                log.log(Level.SEVERE, "Insert records=" + no + "; SQL=" + sql.toString());
                return false;
            }
            log.finer("New ID=" + ID + " " + find);
        } else {
            log.finer("Old ID=" + ID + " " + find);
        }
        sql = new StringBuffer("UPDATE ").append(this.m_tableName).append(" SET ");
        for (int i = 0; i < nodes.length; ++i) {
            sql.append(nodes[i]).append(",");
        }
        sql.append("IsActive='Y',Processed='N',I_IsImported='N',Updated=SysDate,UpdatedBy=").append(UpdatedBy);
        sql.append(" WHERE ").append(this.m_tablePK).append("=").append(ID);
        int no = DB.executeUpdate((String)sql.toString(), (String)trxName);
        if (no != 1) {
            log.log(Level.SEVERE, this.m_tablePK + "=" + ID + " - rows updated=" + no);
            return false;
        }
        return true;
    }
}

