/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.compiere.controller.GridFieldVO;
import org.compiere.controller.GridTabVO;
import org.compiere.framework.Query;
import org.compiere.model.Callout;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRole;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Msg;
import org.compiere.util.MultiMap;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridTab
implements DataStatusListener,
Evaluatee,
Serializable {
    private GridTabVO m_vo;
    private GridTable m_mTable = null;
    private String m_keyColumnName = "";
    private String m_linkColumnName = "";
    private String m_extendedWhere;
    private HashMap<Integer, Integer> m_Attachments = null;
    private HashMap<Integer, Integer> m_Chats = null;
    private ArrayList<Integer> m_Lock = null;
    private int m_currentRow = -1;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROPERTY = "CurrentRow";
    protected EventListenerList m_listenerList = new EventListenerList();
    private DataStatusEvent m_DataStatusEvent = null;
    private Query m_query = new Query();
    private String m_oldQuery = "0=9";
    private String m_linkValue = "999999";
    private String[] m_OrderBys = new String[3];
    private ArrayList<String> m_parents = new ArrayList(2);
    private MultiMap<String, GridField> m_depOnField = new MultiMap();
    private Loader m_loader = null;
    private volatile boolean m_loadComplete = false;
    private boolean m_included = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public GridTab(GridTabVO vo, int onlyCurrentDays) {
        this.m_vo = vo;
        this.m_vo.onlyCurrentDays = onlyCurrentDays;
        this.m_mTable = new GridTable(this.m_vo.ctx, this.m_vo.AD_Table_ID, this.m_vo.TableName, this.m_vo.WindowNo, this.m_vo.TabNo, true);
        this.m_mTable.setReadOnly(this.m_vo.IsReadOnly || this.m_vo.IsView);
        this.m_mTable.setDeleteable(this.m_vo.IsDeleteable);
        this.initTab(false);
    }

    private void waitLoadCompete() {
        if (this.m_loadComplete) {
            return;
        }
        this.m_loader.setPriority(5);
        this.log.config("");
        while (this.m_loader.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "", (Throwable)e);
            }
        }
        this.log.config("fini");
    }

    protected boolean initTab(boolean async) {
        this.log.fine("#" + this.m_vo.TabNo + " - Async=" + async + " - Where=" + this.m_vo.WhereClause);
        this.m_extendedWhere = this.m_vo.WhereClause;
        if (!this.loadFields()) {
            this.m_loadComplete = true;
            return false;
        }
        this.m_mTable.setOrderClause(this.getOrderByClause(this.m_vo.onlyCurrentDays));
        if (async) {
            this.log.fine("#" + this.m_vo.TabNo + " - Async=" + async + " - fini");
        }
        this.m_loadComplete = true;
        return true;
    }

    protected void dispose() {
        this.log.fine("#" + this.m_vo.TabNo);
        this.m_OrderBys = null;
        this.m_parents.clear();
        this.m_parents = null;
        this.m_mTable.close(true);
        this.m_mTable = null;
        this.m_depOnField.clear();
        this.m_depOnField = null;
        if (this.m_Attachments != null) {
            this.m_Attachments.clear();
        }
        this.m_Attachments = null;
        if (this.m_Chats != null) {
            this.m_Chats.clear();
        }
        this.m_Chats = null;
        this.m_vo.Fields.clear();
        this.m_vo.Fields = null;
        this.m_vo = null;
    }

    private boolean loadFields() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (this.m_vo.Fields == null) {
            return false;
        }
        for (int f = 0; f < this.m_vo.Fields.size(); ++f) {
            int sortNo;
            GridFieldVO voF = (GridFieldVO)this.m_vo.Fields.get(f);
            if (voF == null) continue;
            GridField field = new GridField(voF);
            String columnName = field.getColumnName();
            if (field.isKey()) {
                this.m_keyColumnName = columnName;
            }
            if (field.isParentColumn()) {
                this.m_parents.add(columnName);
            }
            if ((sortNo = field.getSortNo()) != 0) {
                if (Math.abs(sortNo) == 1) {
                    this.m_OrderBys[0] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[0] = this.m_OrderBys[0] + " DESC";
                    }
                } else if (Math.abs(sortNo) == 2) {
                    this.m_OrderBys[1] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[1] = this.m_OrderBys[1] + " DESC";
                    }
                } else if (Math.abs(sortNo) == 3) {
                    this.m_OrderBys[2] = columnName;
                    if (sortNo < 0) {
                        this.m_OrderBys[2] = this.m_OrderBys[2] + " DESC";
                    }
                }
            }
            this.m_mTable.addField(field);
            ArrayList<String> list = field.getDependentOn();
            for (int i = 0; i < list.size(); ++i) {
                this.m_depOnField.put((Object)list.get(i), (Object)field);
            }
            if (!columnName.equals("IsActive") && !columnName.equals("Processed") && !columnName.equals("Processing")) continue;
            this.m_depOnField.put((Object)columnName, null);
        }
        if (this.m_mTable.getField("Created") == null) {
            GridField created = new GridField(GridFieldVO.createStdField((Ctx)this.m_vo.ctx, (int)this.m_vo.WindowNo, (int)this.m_vo.TabNo, (int)this.m_vo.AD_Window_ID, (int)this.m_vo.AD_Tab_ID, (boolean)false, (boolean)true, (boolean)true));
            this.m_mTable.addField(created);
        }
        if (this.m_mTable.getField("CreatedBy") == null) {
            GridField createdBy = new GridField(GridFieldVO.createStdField((Ctx)this.m_vo.ctx, (int)this.m_vo.WindowNo, (int)this.m_vo.TabNo, (int)this.m_vo.AD_Window_ID, (int)this.m_vo.AD_Tab_ID, (boolean)false, (boolean)true, (boolean)false));
            this.m_mTable.addField(createdBy);
        }
        if (this.m_mTable.getField("Updated") == null) {
            GridField updated = new GridField(GridFieldVO.createStdField((Ctx)this.m_vo.ctx, (int)this.m_vo.WindowNo, (int)this.m_vo.TabNo, (int)this.m_vo.AD_Window_ID, (int)this.m_vo.AD_Tab_ID, (boolean)false, (boolean)false, (boolean)true));
            this.m_mTable.addField(updated);
        }
        if (this.m_mTable.getField("UpdatedBy") == null) {
            GridField updatedBy = new GridField(GridFieldVO.createStdField((Ctx)this.m_vo.ctx, (int)this.m_vo.WindowNo, (int)this.m_vo.TabNo, (int)this.m_vo.AD_Window_ID, (int)this.m_vo.AD_Tab_ID, (boolean)false, (boolean)false, (boolean)false));
            this.m_mTable.addField(updatedBy);
        }
        return true;
    }

    public ArrayList<String> getDependentOn() {
        ArrayList<String> list = new ArrayList<String>();
        Evaluator.parseDepends(list, (String)this.m_vo.DisplayLogic);
        if (list.size() > 0 && CLogMgt.isLevelFiner()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                sb.append(list.get(i)).append(" ");
            }
            this.log.finer("(" + this.m_vo.Name + ") " + sb.toString());
        }
        return list;
    }

    public String getDisplayLogic() {
        return this.m_vo.DisplayLogic;
    }

    public GridTable getTableModel() {
        return this.m_mTable;
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        return null;
    }

    public boolean hasDependants(String columnName) {
        return this.m_depOnField.containsKey((Object)columnName);
    }

    public ArrayList<GridField> getDependantFields(String columnName) {
        return this.m_depOnField.getValues((Object)columnName);
    }

    public void setQuery(Query query) {
        if (query == null) {
            this.m_query = new Query();
        } else {
            this.m_query = query;
            this.m_vo.onlyCurrentDays = 0;
        }
    }

    public Query getQuery() {
        return this.m_query;
    }

    public boolean isQueryActive() {
        if (this.m_query != null) {
            return this.m_query.isActive();
        }
        return false;
    }

    public boolean isQueryNewRecord() {
        if (this.m_query != null) {
            return this.m_query.isNewRecordQuery();
        }
        return false;
    }

    public void enableEvents() {
        this.m_mTable.addDataStatusListener(this);
    }

    public void query(int onlyCurrentDays) {
        this.query(onlyCurrentDays, 0, false);
    }

    public boolean query(int onlyCurrentDays, int maxRows, boolean created) {
        String q;
        this.log.fine("#" + this.m_vo.TabNo + " - OnlyCurrentDays=" + onlyCurrentDays + ", Detail=" + this.isDetail());
        boolean success = true;
        boolean refresh = this.m_oldQuery.equals(this.m_query.getWhereClause()) && this.m_vo.onlyCurrentDays == onlyCurrentDays;
        this.m_oldQuery = this.m_query.getWhereClause();
        this.m_vo.onlyCurrentDays = onlyCurrentDays;
        StringBuffer where = new StringBuffer(this.m_vo.WhereClause);
        if (this.m_vo.onlyCurrentDays > 0) {
            boolean showNotProcessed;
            if (where.length() > 0) {
                where.append(" AND ");
            }
            boolean bl = showNotProcessed = this.findColumn("Processed") != -1;
            if (showNotProcessed) {
                where.append("(Processed='N' OR ");
            }
            if (created) {
                where.append("Created>=");
            } else {
                where.append("Updated>=");
            }
            where.append("addDays(SysDate, -").append(this.m_vo.onlyCurrentDays).append(")");
            if (showNotProcessed) {
                where.append(")");
            }
        }
        if (this.isDetail()) {
            String lc = this.getLinkColumnName();
            if (lc.equals("")) {
                this.log.warning("No link column");
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append(" 2=3");
                success = false;
            } else {
                String value = this.m_vo.ctx.getContext(this.m_vo.WindowNo, lc);
                if (refresh) {
                    refresh = this.m_linkValue.equals(value);
                }
                this.m_linkValue = value;
                if (value.length() == 0) {
                    this.log.warning("No value for link column " + lc);
                    if (where.length() > 0) {
                        where.append(" AND ");
                    }
                    where.append(" 2=4");
                    success = false;
                } else {
                    if (where.length() > 0) {
                        where.append(" AND ");
                    }
                    if ("NULL".equals(value.toUpperCase())) {
                        where.append(lc).append(" IS NULL ");
                        this.log.severe("Null Value of link column " + lc);
                    } else {
                        where.append(lc).append("=");
                        if (lc.endsWith("_ID")) {
                            where.append(value);
                        } else {
                            where.append("'").append(value).append("'");
                        }
                    }
                }
            }
        }
        this.m_extendedWhere = where.toString();
        if (this.m_query.isActive() && (q = this.validateQuery(this.m_query)) != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(q);
        }
        this.log.fine("#" + this.m_vo.TabNo + " - " + where);
        if (this.m_mTable.isOpen()) {
            if (refresh) {
                this.m_mTable.dataRefreshAll();
            } else {
                this.m_mTable.dataRequery(where.toString());
            }
        } else {
            this.m_mTable.setSelectWhereClause(where.toString());
            this.m_mTable.open(maxRows);
        }
        this.setCurrentRow(0, true);
        return success;
    }

    private String validateQuery(Query query) {
        if (query == null || query.getRestrictionCount() == 0) {
            return null;
        }
        if (query.getRestrictionCount() != 1) {
            this.log.fine("Ignored(More than 1 Restriction): " + query);
            return query.getWhereClause();
        }
        String colName = query.getColumnName(0);
        if (colName == null) {
            this.log.fine("Ignored(No Column): " + query);
            return query.getWhereClause();
        }
        if (colName.indexOf(40) != -1) {
            this.log.fine("Ignored(Function): " + colName);
            return query.getWhereClause();
        }
        String refColName = null;
        if (colName.equals("R_RequestRelated_ID")) {
            refColName = "R_Request_ID";
        } else if (colName.startsWith("C_DocType")) {
            refColName = "C_DocType_ID";
        } else if (colName.equals("CreatedBy") || colName.equals("UpdatedBy")) {
            refColName = "AD_User_ID";
        } else if (colName.equals("Orig_Order_ID")) {
            refColName = "C_Order_ID";
        } else if (colName.equals("Orig_InOut_ID")) {
            refColName = "M_InOut_ID";
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                this.log.fine("Column " + colName + " replaced with synonym " + refColName);
                return query.getWhereClause();
            }
            refColName = null;
        }
        if (this.getField(colName) != null) {
            this.log.fine("Field Found: " + colName);
            return query.getWhereClause();
        }
        String sql = "SELECT cc.ColumnName FROM AD_Column c INNER JOIN AD_Ref_Table r ON (c.AD_Reference_Value_ID=r.AD_Reference_ID) INNER JOIN AD_Column cc ON (r.Column_Key_ID=cc.AD_Column_ID) WHERE c.AD_Reference_ID IN (18,30) AND c.ColumnName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, colName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                refColName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "(ref) - Column=" + colName, (Throwable)e);
            return query.getWhereClause();
        }
        if (refColName != null) {
            query.setColumnName(0, refColName);
            if (this.getField(refColName) != null) {
                this.log.fine("Column " + colName + " replaced with " + refColName);
                return query.getWhereClause();
            }
            colName = refColName;
        }
        String tableName = null;
        String tabKeyColumn = this.getKeyColumnName();
        sql = "SELECT t.TableName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.ColumnName=? AND IsKey='Y' AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.ColumnName=?)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, colName);
            pstmt.setString(2, tabKeyColumn);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                tableName = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Column=" + colName + ", Key=" + tabKeyColumn, (Throwable)e);
            return null;
        }
        if (tabKeyColumn.equals("AD_Reference_ID")) {
            sql = "SELECT AD_Reference_ID FROM AD_Column WHERE ColumnName=?";
            int AD_Reference_ID = DB.getSQLValue(null, (String)sql, (String)colName);
            return "AD_Reference_ID=" + AD_Reference_ID;
        }
        if (tableName == null) {
            this.log.info("Not successfull - Column=" + colName + ", Key=" + tabKeyColumn + ", Query=" + query);
            return query.getWhereClause();
        }
        query.setTableName("xx");
        StringBuffer result = new StringBuffer("EXISTS (SELECT * FROM ").append(tableName).append(" xx WHERE ").append(query.getWhereClause(true)).append(" AND xx.").append(tabKeyColumn).append("=").append(this.getTableName()).append(".").append(tabKeyColumn).append(")");
        this.log.fine(result.toString());
        return result.toString();
    }

    public void dataRefreshAll() {
        this.log.fine("#" + this.m_vo.TabNo);
        int keyNo = this.m_mTable.getKeyID(this.m_currentRow);
        this.m_mTable.dataRefreshAll();
        if (keyNo != -1 && keyNo != this.m_mTable.getKeyID(this.m_currentRow)) {
            int size = this.getRowCount();
            for (int i = 0; i < size; ++i) {
                if (keyNo != this.m_mTable.getKeyID(i)) continue;
                this.m_currentRow = i;
                break;
            }
        }
        this.setCurrentRow(this.m_currentRow, true);
    }

    public void dataRefresh() {
        this.dataRefresh(this.m_currentRow);
    }

    public void dataRefresh(int row) {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + row);
        this.m_mTable.dataRefresh(row);
        this.setCurrentRow(row, true);
    }

    public boolean dataSave(boolean manualCmd) {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
        try {
            boolean retValue;
            boolean bl = retValue = this.m_mTable.dataSave(manualCmd) == 'O';
            if (manualCmd) {
                this.setCurrentRow(this.m_currentRow, false);
            }
            return retValue;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "#" + this.m_vo.TabNo + " - row=" + this.m_currentRow, (Throwable)e);
            return false;
        }
    }

    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        if (rowChange) {
            return this.m_mTable.needSave(-2, onlyRealChange);
        }
        if (onlyRealChange) {
            return this.m_mTable.needSave();
        }
        return this.m_mTable.needSave(onlyRealChange);
    }

    public void dataIgnore() {
        this.log.fine("#" + this.m_vo.TabNo);
        this.m_mTable.dataIgnore();
        this.setCurrentRow(this.m_currentRow, false);
        this.log.fine("#" + this.m_vo.TabNo + "- fini");
    }

    public boolean dataNew(boolean copy) {
        int i;
        boolean retValue;
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.isInsertRecord()) {
            this.log.warning("Inset Not allowed in TabNo=" + this.m_vo.TabNo);
            return false;
        }
        if (this.m_vo.TabNo > 0) {
            boolean processed = "Y".equals(this.m_vo.ctx.getContext(this.m_vo.WindowNo, "Processed"));
            if (processed) {
                this.log.warning("Not allowed in TabNo=" + this.m_vo.TabNo + " -> Processed=" + processed);
                return false;
            }
            this.log.finest("Processed=" + processed);
        }
        if (!(retValue = this.m_mTable.dataNew(this.m_currentRow, copy))) {
            return retValue;
        }
        this.setCurrentRow(this.m_currentRow + 1, true);
        for (i = 0; i < this.getFieldCount(); ++i) {
            this.processCallout(this.getField(i));
        }
        for (i = 0; i < this.getFieldCount(); ++i) {
            this.getField(i).refreshLookup();
            this.getField(i).validateValue();
            this.getField(i).setError(false);
        }
        this.m_mTable.setChanged(false);
        return retValue;
    }

    public boolean dataDelete() {
        this.log.fine("#" + this.m_vo.TabNo + " - row=" + this.m_currentRow);
        boolean retValue = this.m_mTable.dataDelete(this.m_currentRow);
        this.setCurrentRow(this.m_currentRow, true);
        return retValue;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public int getTabLevel() {
        return this.m_vo.TabLevel;
    }

    public String getCommitWarning() {
        return this.m_vo.CommitWarning;
    }

    protected GridTable getMTable() {
        return this.m_mTable;
    }

    public String getKeyColumnName() {
        return this.m_keyColumnName;
    }

    public String getLinkColumnName() {
        return this.m_linkColumnName;
    }

    public void setLinkColumnName(String linkColumnName) {
        if (linkColumnName != null) {
            this.m_linkColumnName = linkColumnName;
        } else {
            if (this.m_vo.AD_Column_ID == 0) {
                return;
            }
            String SQL = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)SQL, null);
                pstmt.setInt(1, this.m_vo.AD_Column_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_linkColumnName = rs.getString(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "", (Throwable)e);
            }
            this.log.fine("AD_Column_ID=" + this.m_vo.AD_Column_ID + " - " + this.m_linkColumnName);
        }
        this.m_vo.ctx.setContext(this.m_vo.WindowNo, this.m_vo.TabNo, "LinkColumnName", this.m_linkColumnName);
    }

    public boolean isCurrent() {
        if (!this.m_mTable.isOpen()) {
            return false;
        }
        if (!this.m_oldQuery.equals(this.m_query.getWhereClause())) {
            return false;
        }
        if (!this.isDetail()) {
            return true;
        }
        String value = this.m_vo.ctx.getContext(this.m_vo.WindowNo, this.getLinkColumnName());
        return this.m_linkValue.equals(value);
    }

    public boolean isOpen() {
        if (this.m_mTable != null) {
            return this.m_mTable.isOpen();
        }
        return false;
    }

    public boolean isIncluded() {
        return this.m_included;
    }

    public void setIncluded(boolean isIncluded) {
        this.m_included = isIncluded;
    }

    public int getOnlyCurrentDays() {
        return this.m_vo.onlyCurrentDays;
    }

    public ArrayList<String> getParentColumnNames() {
        return this.m_parents;
    }

    public boolean isDetail() {
        return this.m_parents.size() > 0 || this.m_vo.AD_Column_ID != 0;
    }

    public boolean isPrinted() {
        return this.m_vo.AD_Process_ID != 0;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public int getTabNo() {
        return this.m_vo.TabNo;
    }

    public int getAD_Process_ID() {
        return this.m_vo.AD_Process_ID;
    }

    public boolean isHighVolume() {
        return this.m_vo.IsHighVolume;
    }

    public boolean isReadOnly() {
        if (this.m_vo.IsReadOnly) {
            return true;
        }
        if (this.m_vo.ReadOnlyLogic == null || this.m_vo.ReadOnlyLogic.equals("")) {
            return this.m_vo.IsReadOnly;
        }
        boolean retValue = Evaluator.evaluateLogic((Evaluatee)this, (String)this.m_vo.ReadOnlyLogic);
        this.log.finest(this.m_vo.Name + " (" + this.m_vo.ReadOnlyLogic + ") => " + retValue);
        return retValue;
    }

    public boolean isAlwaysUpdateField() {
        for (int i = 0; i < this.m_mTable.getColumnCount(); ++i) {
            GridField field = this.m_mTable.getField(i);
            if (!field.isAlwaysUpdateable()) continue;
            return true;
        }
        return false;
    }

    public boolean isInsertRecord() {
        if (this.isReadOnly()) {
            return false;
        }
        return this.m_vo.IsInsertRecord;
    }

    public boolean isDisplayed(boolean initialSetup) {
        String dl = this.m_vo.DisplayLogic;
        if (dl == null || dl.equals("")) {
            return true;
        }
        if (initialSetup) {
            String parsed;
            if (dl.indexOf("@#") != -1 && (parsed = Env.parseContext((Ctx)this.m_vo.ctx, (int)0, (String)dl, (boolean)false, (boolean)false).trim()).length() != 0) {
                return Evaluator.evaluateLogic((Evaluatee)this, (String)dl);
            }
            return true;
        }
        boolean retValue = Evaluator.evaluateLogic((Evaluatee)this, (String)dl);
        this.log.config(this.m_vo.Name + " (" + dl + ") => " + retValue);
        return retValue;
    }

    public String get_ValueAsString(String variableName) {
        return this.m_vo.ctx.getContext(this.m_vo.WindowNo, variableName, true);
    }

    public boolean isSingleRow() {
        return this.m_vo.IsSingleRow;
    }

    public void setSingleRow(boolean isSingleRow) {
        this.m_vo.IsSingleRow = isSingleRow;
    }

    public boolean isTreeTab() {
        return this.m_vo.HasTree;
    }

    public int getAD_Tab_ID() {
        return this.m_vo.AD_Tab_ID;
    }

    public int getAD_Table_ID() {
        return this.m_vo.AD_Table_ID;
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getIncluded_Tab_ID() {
        return this.m_vo.Included_Tab_ID;
    }

    public String getTableName() {
        return this.m_vo.TableName;
    }

    public String getWhereClause() {
        return this.m_vo.WhereClause;
    }

    public boolean isSortTab() {
        return this.m_vo.IsSortTab;
    }

    public int getAD_ColumnSortOrder_ID() {
        return this.m_vo.AD_ColumnSortOrder_ID;
    }

    public int getAD_ColumnSortYesNo_ID() {
        return this.m_vo.AD_ColumnSortYesNo_ID;
    }

    public String getWhereExtended() {
        return this.m_extendedWhere;
    }

    private String getOrderByClause(int onlyCurrentDays) {
        if (this.m_vo.OrderByClause.length() > 0) {
            return this.m_vo.OrderByClause;
        }
        this.m_vo.OrderByClause = "";
        for (int i = 0; i < 3; ++i) {
            String order = this.m_OrderBys[i];
            if (order == null || order.length() <= 0) continue;
            if (this.m_vo.OrderByClause.length() > 0) {
                this.m_vo.OrderByClause = this.m_vo.OrderByClause + ",";
            }
            this.m_vo.OrderByClause = this.m_vo.OrderByClause + order;
        }
        if (this.m_vo.OrderByClause.length() > 0) {
            return this.m_vo.OrderByClause;
        }
        this.m_vo.OrderByClause = "Created";
        if (onlyCurrentDays > 0) {
            this.m_vo.OrderByClause = this.m_vo.OrderByClause + " DESC";
        }
        return this.m_vo.OrderByClause;
    }

    public String getTrxInfo() {
        if (this.m_vo.TableName.startsWith("C_InvoiceBatch")) {
            int Record_ID = this.m_vo.ctx.getContextAsInt(this.m_vo.WindowNo, "C_InvoiceBatch_ID");
            this.log.fine(this.m_vo.TableName + " - " + Record_ID);
            MessageFormat mf = null;
            try {
                mf = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"InvoiceBatchSummary"));
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InvoiceBatchSummary=" + Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"InvoiceBatchSummary"), (Throwable)e);
            }
            if (mf == null) {
                return " ";
            }
            Object[] arguments = new Object[3];
            boolean filled = false;
            String sql = "SELECT COUNT(*), NVL(SUM(LineNetAmt),0), NVL(SUM(LineTotalAmt),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=? AND IsActive='Y'";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, Record_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    Integer lines = new Integer(rs.getInt(1));
                    arguments[0] = lines;
                    Double net = new Double(rs.getDouble(2));
                    arguments[1] = net;
                    Double total = new Double(rs.getDouble(3));
                    arguments[2] = total;
                    filled = true;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + sql, (Throwable)e);
            }
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        if (this.m_vo.TableName.startsWith("C_Order") || this.m_vo.TableName.startsWith("C_Invoice")) {
            int Record_ID;
            boolean isOrder = this.m_vo.TableName.startsWith("C_Order");
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) AS Lines,c.ISO_Code,o.TotalLines,o.GrandTotal,currencyBase(o.GrandTotal,o.C_Currency_ID,o.DateAcct, o.AD_Client_ID,o.AD_Org_ID) AS ConvAmt ");
            if (isOrder) {
                Record_ID = this.m_vo.ctx.getContextAsInt(this.m_vo.WindowNo, "C_Order_ID");
                sql.append("FROM C_Order o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_OrderLine l ON (o.C_Order_ID=l.C_Order_ID) WHERE o.C_Order_ID=? ");
            } else {
                Record_ID = this.m_vo.ctx.getContextAsInt(this.m_vo.WindowNo, "C_Invoice_ID");
                sql.append("FROM C_Invoice o INNER JOIN C_Currency c ON (o.C_Currency_ID=c.C_Currency_ID) INNER JOIN C_InvoiceLine l ON (o.C_Invoice_ID=l.C_Invoice_ID) WHERE o.C_Invoice_ID=? ");
            }
            sql.append("GROUP BY o.C_Currency_ID, c.ISO_Code, o.TotalLines, o.GrandTotal, o.DateAcct, o.AD_Client_ID, o.AD_Org_ID");
            this.log.fine(this.m_vo.TableName + " - " + Record_ID);
            MessageFormat mf = null;
            MessageFormat mfMC = null;
            try {
                mf = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"OrderSummary"));
                mfMC = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"OrderSummaryMC"));
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "OrderSummary/MC", (Throwable)e);
            }
            if (mf == null || mfMC == null) {
                return " ";
            }
            Object[] arguments = new Object[6];
            boolean filled = false;
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
                pstmt.setInt(1, Record_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    Integer lines = new Integer(rs.getInt(1));
                    arguments[0] = lines;
                    Double lineTotal = new Double(rs.getDouble(3));
                    arguments[1] = lineTotal;
                    Double grandTotal = new Double(rs.getDouble(4));
                    arguments[2] = grandTotal;
                    String currency = rs.getString(2);
                    arguments[3] = currency;
                    Double grandBase = new Double(rs.getDouble(5));
                    arguments[4] = grandBase;
                    arguments[5] = this.m_vo.ctx.getContext("$CurrencyISO");
                    filled = true;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + sql, (Throwable)e);
            }
            if (filled) {
                if (arguments[2].equals(arguments[4])) {
                    return mf.format(arguments);
                }
                return mfMC.format(arguments);
            }
            return " ";
        }
        if (this.m_vo.TableName.startsWith("S_TimeExpense") && this.m_vo.TabNo == 0) {
            int Record_ID = this.m_vo.ctx.getContextAsInt(this.m_vo.WindowNo, "S_TimeExpense_ID");
            this.log.fine(this.m_vo.TableName + " - " + Record_ID);
            MessageFormat mf = null;
            try {
                mf = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"ExpenseSummary"));
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ExpenseSummary=" + Msg.getMsg((String)Env.getAD_Language((Ctx)this.m_vo.ctx), (String)"ExpenseSummary"), (Throwable)e);
            }
            if (mf == null) {
                return " ";
            }
            Object[] arguments = new Object[3];
            boolean filled = false;
            String SQL = "SELECT COUNT(*) AS Lines, SUM(ConvertedAmt*Qty) FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)SQL, null);
                pstmt.setInt(1, Record_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    Integer lines = new Integer(rs.getInt(1));
                    arguments[0] = lines;
                    Double total = new Double(rs.getDouble(2));
                    arguments[1] = total;
                    arguments[2] = " ";
                    filled = true;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_vo.TableName + "\nSQL=" + SQL, (Throwable)e);
            }
            if (filled) {
                return mf.format(arguments);
            }
            return " ";
        }
        return null;
    }

    private void loadDependentInfo() {
        if (this.m_vo.TableName.equals("C_Order")) {
            int C_DocTyp_ID = 0;
            Integer target = (Integer)this.getValue("C_DocTypeTarget_ID");
            if (target != null) {
                C_DocTyp_ID = target;
            }
            if (C_DocTyp_ID == 0) {
                return;
            }
            String sql = "SELECT DocSubTypeSO FROM C_DocType WHERE C_DocType_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocTyp_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_vo.ctx.setContext(this.m_vo.WindowNo, "OrderType", rs.getString(1));
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
    }

    public void loadAttachments() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.canHaveAttachment()) {
            return;
        }
        String SQL = "SELECT AD_Attachment_ID, Record_ID FROM AD_Attachment WHERE AD_Table_ID=?";
        try {
            if (this.m_Attachments == null) {
                this.m_Attachments = new HashMap();
            } else {
                this.m_Attachments.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement((String)SQL, null);
            pstmt.setInt(1, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(2));
                Integer value = new Integer(rs.getInt(1));
                this.m_Attachments.put(key, value);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "loadAttachments", (Throwable)e);
        }
        this.log.config("#" + this.m_Attachments.size());
    }

    public boolean canHaveAttachment() {
        return this.getKeyColumnName().endsWith("_ID");
    }

    public boolean hasAttachment() {
        if (this.m_Attachments == null) {
            this.loadAttachments();
        }
        if (this.m_Attachments == null || this.m_Attachments.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Attachments.containsKey(key);
    }

    public int getAD_AttachmentID() {
        if (this.m_Attachments == null) {
            this.loadAttachments();
        }
        if (this.m_Attachments.isEmpty()) {
            return 0;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        Integer value = this.m_Attachments.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void loadChats() {
        this.log.fine("#" + this.m_vo.TabNo);
        if (!this.canHaveAttachment()) {
            return;
        }
        String sql = "SELECT CM_Chat_ID, Record_ID FROM CM_Chat WHERE AD_Table_ID=?";
        try {
            if (this.m_Chats == null) {
                this.m_Chats = new HashMap();
            } else {
                this.m_Chats.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(2));
                Integer value = new Integer(rs.getInt(1));
                this.m_Chats.put(key, value);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.config("#" + this.m_Chats.size());
    }

    public boolean hasChat() {
        if (this.m_Chats == null) {
            this.loadChats();
        }
        if (this.m_Chats == null || this.m_Chats.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Chats.containsKey(key);
    }

    public int getCM_ChatID() {
        if (this.m_Chats == null) {
            this.loadChats();
        }
        if (this.m_Chats.isEmpty()) {
            return 0;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        Integer value = this.m_Chats.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void loadLocks() {
        int AD_User_ID = Env.getCtx().getAD_User_ID();
        this.log.fine("#" + this.m_vo.TabNo + " - AD_User_ID=" + AD_User_ID);
        if (!this.canHaveAttachment()) {
            return;
        }
        String sql = "SELECT Record_ID FROM AD_Private_Access WHERE AD_User_ID=? AND AD_Table_ID=? AND IsActive='Y' ORDER BY Record_ID";
        try {
            if (this.m_Lock == null) {
                this.m_Lock = new ArrayList();
            } else {
                this.m_Lock.clear();
            }
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, this.m_vo.AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer key = new Integer(rs.getInt(1));
                this.m_Lock.add(key);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("#" + this.m_Lock.size());
    }

    public boolean isLocked() {
        if (!MRole.getDefault((Ctx)this.m_vo.ctx, (boolean)false).isPersonalLock()) {
            return false;
        }
        if (this.m_Lock == null) {
            this.loadLocks();
        }
        if (this.m_Lock == null || this.m_Lock.isEmpty()) {
            return false;
        }
        Integer key = new Integer(this.m_mTable.getKeyID(this.m_currentRow));
        return this.m_Lock.contains(key);
    }

    public void lock(Ctx ctx, int Record_ID, boolean lock) {
        int AD_User_ID = ctx.getAD_User_ID();
        this.log.fine("Lock=" + lock + ", AD_User_ID=" + AD_User_ID + ", AD_Table_ID=" + this.m_vo.AD_Table_ID + ", Record_ID=" + Record_ID);
        MPrivateAccess access = MPrivateAccess.get((Ctx)ctx, (int)AD_User_ID, (int)this.m_vo.AD_Table_ID, (int)Record_ID);
        if (access == null) {
            access = new MPrivateAccess(ctx, AD_User_ID, this.m_vo.AD_Table_ID, Record_ID);
        }
        access.setIsActive(lock);
        access.save();
        this.loadLocks();
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        this.log.fine("#" + this.m_vo.TabNo + " - " + e.toString());
        int oldCurrentRow = e.getCurrentRow();
        this.m_DataStatusEvent = e;
        String msg = this.m_DataStatusEvent.getAD_Message();
        if (msg != null && msg.equals("Sorted")) {
            this.setCurrentRow(0, true);
        }
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        if (oldCurrentRow == this.m_currentRow) {
            GridField field = this.m_mTable.getField(e.getChangedColumn());
            if (field != null) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, e.getChangedColumn());
                field.setValue(value, this.m_mTable.isInserting());
            }
        } else {
            this.fireDataStatusChanged(this.m_DataStatusEvent);
        }
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.m_listenerList.getListeners(DataStatusListener.class);
        if (listeners.length == 0) {
            return;
        }
        this.log.fine(e.toString());
        if (e.getCurrentRow() >= 0) {
            e.Created = (Timestamp)this.getValue("Created");
            e.CreatedBy = (Integer)this.getValue("CreatedBy");
            e.Updated = (Timestamp)this.getValue("Updated");
            e.UpdatedBy = (Integer)this.getValue("UpdatedBy");
            e.Record_ID = this.getValue(this.m_keyColumnName);
            StringBuffer info = new StringBuffer(this.getTableName());
            if (this.m_keyColumnName != null && this.m_keyColumnName.length() > 0) {
                info.append(" - ").append(this.m_keyColumnName).append("=").append(e.Record_ID);
            } else {
                for (int i = 0; i < this.m_parents.size(); ++i) {
                    String keyCol = this.m_parents.get(i);
                    info.append(" - ").append(keyCol).append("=").append(this.getValue(keyCol));
                }
            }
            e.Info = info.toString();
        }
        e.setInserting(this.m_mTable.isInserting());
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataStatusChanged(e);
        }
    }

    protected void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        this.m_mTable.fireDataStatusEEvent(AD_Message, info, isError);
    }

    protected void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.m_mTable.fireDataStatusEEvent(errorLog);
        }
    }

    public int getCurrentRow() {
        if (this.m_currentRow != this.verifyRow(this.m_currentRow)) {
            this.setCurrentRow(this.m_mTable.getRowCount() - 1, true);
        }
        return this.m_currentRow;
    }

    public int getRecord_ID() {
        return this.m_mTable.getKeyID(this.m_currentRow);
    }

    public int getKeyID(int row) {
        return this.m_mTable.getKeyID(row);
    }

    public int navigate(int targetRow) {
        if (targetRow == this.m_currentRow) {
            return this.m_currentRow;
        }
        this.log.info("Row=" + targetRow);
        int newRow = this.verifyRow(targetRow);
        this.m_mTable.dataSave(newRow, false);
        int row = this.setCurrentRow(newRow, true);
        return row;
    }

    public int navigateRelative(int rowChange) {
        return this.navigate(this.m_currentRow + rowChange);
    }

    public int navigateCurrent() {
        this.log.info("Row=" + this.m_currentRow);
        return this.setCurrentRow(this.m_currentRow, true);
    }

    private int verifyRow(int targetRow) {
        int newRow = targetRow;
        if (!this.m_mTable.isOpen()) {
            this.log.severe("Table not open");
            return -1;
        }
        int rows = this.getRowCount();
        if (rows == 0) {
            this.log.fine("No Rows");
            return -1;
        }
        if (newRow >= rows) {
            newRow = rows - 1;
            this.log.fine("Set to max Row: " + newRow);
        } else if (newRow < 0) {
            newRow = 0;
            this.log.fine("Set to first Row");
        }
        return newRow;
    }

    private int setCurrentRow(int newCurrentRow, boolean fireEvents) {
        int oldCurrentRow = this.m_currentRow;
        this.m_currentRow = this.verifyRow(newCurrentRow);
        this.log.fine("Row=" + this.m_currentRow + " - fire=" + fireEvents);
        int size = this.m_mTable.getColumnCount();
        for (int i = 0; i < size; ++i) {
            GridField mField = this.m_mTable.getField(i);
            if (this.m_currentRow >= 0) {
                Object value = this.m_mTable.getValueAt(this.m_currentRow, i);
                mField.setValue(value, this.m_mTable.isInserting());
                mField.validateValue();
                continue;
            }
            mField.setValue();
        }
        this.loadDependentInfo();
        if (!fireEvents) {
            return this.m_currentRow;
        }
        this.m_propertyChangeSupport.firePropertyChange(PROPERTY, oldCurrentRow, this.m_currentRow);
        if (this.m_DataStatusEvent == null) {
            this.m_DataStatusEvent = new DataStatusEvent(this, this.getRowCount(), this.m_mTable.isInserting(), Env.getCtx().isAutoCommit(this.m_vo.WindowNo), this.m_mTable.isInserting());
        }
        this.m_DataStatusEvent.setCurrentRow(this.m_currentRow);
        String status = this.m_DataStatusEvent.getAD_Message();
        if (status == null || status.length() == 0) {
            this.m_DataStatusEvent.setInfo("NavigateOrUpdate", null, false, false);
        }
        this.fireDataStatusChanged(this.m_DataStatusEvent);
        return this.m_currentRow;
    }

    public int getRowCount() {
        int count = this.m_mTable.getRowCount();
        if (count == 0 && this.m_mTable.isLoading()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            count = this.m_mTable.getRowCount();
        }
        return count;
    }

    public int getFieldCount() {
        return this.m_mTable.getColumnCount();
    }

    public GridField getField(int index) {
        return this.m_mTable.getField(index);
    }

    public int findColumn(String columnName) {
        return this.m_mTable.findColumn(columnName);
    }

    public GridField getField(String columnName) {
        return this.m_mTable.getField(columnName);
    }

    public GridField[] getFields() {
        return this.m_mTable.getFields();
    }

    public String setValue(String columnName, Object value) {
        if (columnName == null) {
            return "NoColumn";
        }
        return this.setValue(this.m_mTable.getField(columnName), value);
    }

    public String setValue(GridField field, Object value) {
        if (field == null) {
            return "NoField";
        }
        this.log.fine(field.getColumnName() + "=" + value + " - Row=" + this.m_currentRow);
        int col = this.m_mTable.findColumn(field.getColumnName());
        this.m_mTable.setValueAt(value, this.m_currentRow, col, false);
        return this.processFieldChange(field);
    }

    public boolean isProcessed() {
        int index = this.m_mTable.findColumn("Processed");
        if (index != -1) {
            Object oo = this.m_mTable.getValueAt(this.m_currentRow, index);
            if (oo instanceof String) {
                return "Y".equals(oo);
            }
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
        }
        return "Y".equals(this.m_vo.ctx.getContext(this.m_vo.WindowNo, "Processed"));
    }

    public String processFieldChange(GridField changedField) {
        this.processDependencies(changedField);
        return this.processCallout(changedField);
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getColumnName();
        if (!this.hasDependants(columnName)) {
            return;
        }
        ArrayList<GridField> list = this.getDependantFields(columnName);
        for (int i = 0; i < list.size(); ++i) {
            MLookup mLookup;
            GridField dependentField = list.get(i);
            if (dependentField != null && dependentField.getLookup() instanceof MLookup && (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + columnName + "@") != -1) {
                this.log.fine(columnName + " changed - " + dependentField.getColumnName() + " set to null");
                this.setValue(dependentField, null);
            }
            if (dependentField == null || !(dependentField.getLookup() instanceof MLocatorLookup)) continue;
            MLocatorLookup locLookup = (MLocatorLookup)dependentField.getLookup();
            int valueAsInt = 0;
            if (changedField.getValue() != null && changedField.getValue() instanceof Number) {
                valueAsInt = ((Number)changedField.getValue()).intValue();
            }
            if (columnName.equals("M_Warehouse_ID")) {
                locLookup.setOnly_Warehouse_ID(valueAsInt);
            }
            if (columnName.equals("M_Product_ID")) {
                locLookup.setOnly_Product_ID(valueAsInt);
            }
            locLookup.setOnly_Outgoing(Boolean.valueOf(Env.getCtx().isSOTrx(this.m_vo.WindowNo)));
            locLookup.refresh();
            if (locLookup.isValid(dependentField.getValue())) continue;
            this.setValue(dependentField, null);
        }
    }

    private String processCallout(GridField field) {
        String callout = field.getCallout();
        if (callout.length() == 0) {
            return "";
        }
        if (this.isProcessed()) {
            return "";
        }
        Object value = field.getValue();
        Object oldValue = field.getOldValue();
        this.log.fine(field.getColumnName() + "=" + value + " (" + callout + ") - old=" + oldValue);
        StringTokenizer st = new StringTokenizer(callout, ";,", false);
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken().trim();
            Callout call = null;
            String method = null;
            int methodStart = cmd.lastIndexOf(".");
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(cmd.substring(0, methodStart));
                    call = (Callout)cClass.newInstance();
                    method = cmd.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "class", (Throwable)e);
                return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
            }
            if (call == null || method == null || method.length() == 0) {
                return "Callout Invalid: " + method;
            }
            String retValue = "";
            try {
                retValue = call.start(this.m_vo.ctx, method, this.m_vo.WindowNo, this, field, value, oldValue);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "start", (Throwable)e);
                retValue = "Callout Invalid: " + e.toString();
                return retValue;
            }
            if (retValue.equals("")) continue;
            this.log.warning(retValue);
            return retValue;
        }
        return "";
    }

    public Object getValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        GridField field = this.m_mTable.getField(columnName);
        return this.getValue(field);
    }

    public Object getValue(GridField field) {
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public Object getValue(int row, String columnName) {
        int col = this.m_mTable.findColumn(columnName);
        if (col == -1) {
            return null;
        }
        return this.m_mTable.getValueAt(row, col);
    }

    public String toString() {
        String retValue = "MTab #" + this.m_vo.TabNo;
        if (this.m_vo != null) {
            retValue = retValue + " " + this.m_vo.Name + " (" + this.m_vo.AD_Tab_ID + ") QueryActive=" + (this.m_query != null && this.m_query.isActive()) + ", CurrentDays=" + this.m_vo.onlyCurrentDays;
        }
        return retValue;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_propertyChangeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.m_listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.m_listenerList.add(DataStatusListener.class, l);
    }

    class Loader
    extends Thread {
        Loader() {
        }

        public void run() {
            GridTab.this.initTab(true);
        }
    }
}

