/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAlertRecipient;
import org.compiere.model.MAlertRule;
import org.compiere.model.MUserRoles;
import org.compiere.model.X_AD_Alert;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MAlert
extends X_AD_Alert {
    private MAlertRule[] m_rules = null;
    private MAlertRecipient[] m_recipients = null;

    public MAlert(Ctx ctx, int AD_Alert_ID, String trxName) {
        super(ctx, AD_Alert_ID, trxName);
        if (AD_Alert_ID == 0) {
            this.setEnforceClientSecurity(true);
            this.setEnforceRoleSecurity(true);
            this.setIsValid(true);
        }
    }

    public MAlert(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAlertRule[] getRules(boolean reload) {
        if (this.m_rules != null && !reload) {
            return this.m_rules;
        }
        String sql = "SELECT * FROM AD_AlertRule WHERE AD_Alert_ID=?";
        ArrayList<MAlertRule> list = new ArrayList<MAlertRule>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_Alert_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAlertRule(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_rules = new MAlertRule[list.size()];
        list.toArray(this.m_rules);
        return this.m_rules;
    }

    public MAlertRecipient[] getRecipients(boolean reload) {
        if (this.m_recipients != null && !reload) {
            return this.m_recipients;
        }
        String sql = "SELECT * FROM AD_AlertRecipient WHERE AD_Alert_ID=?";
        ArrayList<MAlertRecipient> list = new ArrayList<MAlertRecipient>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_Alert_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAlertRecipient(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_recipients = new MAlertRecipient[list.size()];
        list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public int getFirstAD_Role_ID() {
        this.getRecipients(false);
        for (int i2 = 0; i2 < this.m_recipients.length; ++i2) {
            if (this.m_recipients[i2].getAD_Role_ID() == -1) continue;
            return this.m_recipients[i2].getAD_Role_ID();
        }
        return -1;
    }

    public int getFirstUserAD_Role_ID() {
        this.getRecipients(false);
        int AD_User_ID = this.getFirstAD_User_ID();
        if (AD_User_ID != -1) {
            MUserRoles[] urs = MUserRoles.getOfUser((Ctx)this.getCtx(), (int)AD_User_ID);
            for (int i2 = 0; i2 < urs.length; ++i2) {
                if (!urs[i2].isActive()) continue;
                return urs[i2].getAD_Role_ID();
            }
        }
        return -1;
    }

    public int getFirstAD_User_ID() {
        this.getRecipients(false);
        for (int i2 = 0; i2 < this.m_recipients.length; ++i2) {
            if (this.m_recipients[i2].getAD_User_ID() == -1) continue;
            return this.m_recipients[i2].getAD_User_ID();
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAlert[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid());
        if (this.m_rules != null) {
            sb.append(",Rules=").append(this.m_rules.length);
        }
        if (this.m_recipients != null) {
            sb.append(",Recipients=").append(this.m_recipients.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

