/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocation;
import org.compiere.model.X_C_BPartner_Location;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MBPartnerLocation
extends X_C_BPartner_Location {
    private static CLogger s_log = CLogger.getCLogger(MBPartnerLocation.class);
    private MLocation m_location = null;
    private String m_uniqueName = null;
    private int m_unique = 0;

    public MBPartnerLocation[] getForBPartner(Ctx ctx, int C_BPartner_ID, String trxName) {
        ArrayList<MBPartnerLocation> list = new ArrayList<MBPartnerLocation>();
        String sql = "SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBPartnerLocation(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBPartnerLocation[] retValue = new MBPartnerLocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPartnerLocation(Ctx ctx, int C_BPartner_Location_ID, String trxName) {
        super(ctx, C_BPartner_Location_ID, trxName);
        if (C_BPartner_Location_ID == 0) {
            this.setName(".");
            this.setIsShipTo(true);
            this.setIsRemitTo(true);
            this.setIsPayFrom(true);
            this.setIsBillTo(true);
        }
    }

    public MBPartnerLocation(MBPartner bp) {
        this(bp.getCtx(), 0, bp.get_TrxName());
        this.setClientOrg((PO)bp);
        this.set_ValueNoCheck("C_BPartner_ID", new Integer(bp.getC_BPartner_ID()));
    }

    public MBPartnerLocation(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLocation getLocation(boolean requery) {
        if (this.m_location == null || requery) {
            this.m_location = MLocation.get((Ctx)this.getCtx(), (int)this.getC_Location_ID(), (String)this.get_TrxName());
        }
        return this.m_location;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MBPartner_Location[ID=").append(this.get_ID()).append(",C_Location_ID=").append(this.getC_Location_ID()).append(",Name=").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        boolean unique;
        if (this.getC_Location_ID() == 0) {
            return false;
        }
        if (!newRecord) {
            return true;
        }
        MLocation address = this.getLocation(true);
        this.m_uniqueName = this.getName();
        if (this.m_uniqueName != null && this.m_uniqueName.equals(".")) {
            this.m_uniqueName = null;
        }
        this.m_unique = 0;
        this.makeUnique(address);
        MBPartnerLocation[] locations = this.getForBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        boolean bl = unique = locations.length == 0;
        block0: while (!unique) {
            unique = true;
            for (int i2 = 0; i2 < locations.length; ++i2) {
                MBPartnerLocation location = locations[i2];
                if (location.getC_BPartner_Location_ID() == this.get_ID() || !this.m_uniqueName.equals(location.getName())) continue;
                this.makeUnique(address);
                unique = false;
                continue block0;
            }
        }
        this.setName(this.m_uniqueName);
        return true;
    }

    private void makeUnique(MLocation address) {
        String xx;
        if (this.m_uniqueName == null) {
            this.m_uniqueName = "";
        }
        ++this.m_unique;
        if (this.m_uniqueName.length() == 0) {
            xx = address.getCity();
            if (xx != null && xx.length() > 0) {
                this.m_uniqueName = xx;
            }
            this.m_unique = 0;
        }
        if (this.m_unique == 1 || this.m_uniqueName.length() == 0) {
            xx = address.getAddress1();
            if (xx != null && xx.length() > 0) {
                if (this.m_uniqueName.length() > 0) {
                    this.m_uniqueName = this.m_uniqueName + " ";
                }
                this.m_uniqueName = this.m_uniqueName + xx;
            }
            this.m_unique = 1;
        }
        if (this.m_unique == 2 || this.m_uniqueName.length() == 0) {
            xx = address.getAddress2();
            if (xx != null && xx.length() > 0) {
                if (this.m_uniqueName.length() > 0) {
                    this.m_uniqueName = this.m_uniqueName + " ";
                }
                this.m_uniqueName = this.m_uniqueName + xx;
            }
            this.m_unique = 2;
        }
        if (this.m_unique == 3 || this.m_uniqueName.length() == 0) {
            xx = address.getRegionName(true);
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
            this.m_unique = 3;
        }
        if (this.m_unique == 4 || this.m_uniqueName.length() == 0) {
            int id = this.get_ID();
            if (id == 0) {
                id = address.get_ID();
            }
            this.m_uniqueName = this.m_uniqueName + "#" + id;
            this.m_unique = 4;
        }
    }
}

