/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_BankStatement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankStatement
extends X_C_BankStatement
implements DocAction {
    private MBankStatementLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MBankStatement(Ctx ctx, int C_BankStatement_ID, String trxName) {
        super(ctx, C_BankStatement_ID, trxName);
        if (C_BankStatement_ID == 0) {
            this.setStatementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setBeginningBalance(Env.ZERO);
            this.setStatementDifference(Env.ZERO);
            this.setEndingBalance(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(true);
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MBankStatement(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatement(MBankAccount account, boolean isManual) {
        this(account.getCtx(), 0, account.get_TrxName());
        this.setClientOrg((PO)account);
        this.setC_BankAccount_ID(account.getC_BankAccount_ID());
        this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        this.setBeginningBalance(account.getCurrentBalance());
        this.setName(this.getStatementDate().toString());
        this.setIsManual(isManual);
    }

    public MBankStatement(MBankAccount account) {
        this(account, false);
    }

    public MBankStatementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MBankStatementLine> list = new ArrayList<MBankStatementLine>();
        String sql = "SELECT * FROM C_BankStatementLine WHERE C_BankStatement_ID=?ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_BankStatement_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBankStatementLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBankStatementLine[] retValue = new MBankStatementLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE C_BankStatementLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
    }

    public MBankAccount getBankAccount() {
        return MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
    }

    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        super.setC_BankAccount_ID(C_BankAccount_ID);
    }

    @UICallout
    public void setC_BankAccount_ID(String oldC_BankAccount_ID, String newC_BankAccount_ID, int windowNo) throws Exception {
        if (newC_BankAccount_ID == null || newC_BankAccount_ID.length() == 0) {
            return;
        }
        int C_BankAccount_ID = Integer.parseInt(newC_BankAccount_ID);
        if (C_BankAccount_ID == 0) {
            return;
        }
        this.setC_BankAccount_ID(C_BankAccount_ID);
        MBankAccount ba = this.getBankAccount();
        this.setBeginningBalance(ba.getCurrentBalance());
    }

    public String getDocumentNo() {
        return this.getName();
    }

    public String getDocumentInfo() {
        return this.getBankAccount().getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        Timestamp minDate;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getStatementDate(), "CMB")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MBankStatementLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal total = Env.ZERO;
        Timestamp maxDate = minDate = this.getStatementDate();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MBankStatementLine line = lines[i2];
            total = total.add(line.getStmtAmt());
            if (line.getDateAcct().before(minDate)) {
                minDate = line.getDateAcct();
            }
            if (!line.getDateAcct().after(maxDate)) continue;
            maxDate = line.getDateAcct();
        }
        this.setStatementDifference(total);
        this.setEndingBalance(this.getBeginningBalance().add(total));
        if (!MPeriod.isOpen(this.getCtx(), minDate, "CMB") || !MPeriod.isOpen(this.getCtx(), maxDate, "CMB")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        MBankStatementLine[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MBankStatementLine line = lines[i2];
            if (line.getC_Payment_ID() == 0) continue;
            MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
            payment.setIsReconciled(true);
            payment.save(this.get_TrxName());
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        ba.setCurrentBalance(this.getEndingBalance());
        ba.save(this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            if (!MPeriod.isOpen(this.getCtx(), this.getStatementDate(), "CMB")) {
                this.m_processMsg = "@PeriodClosed@";
                return false;
            }
            if (MFactAcct.delete(392, this.getC_BankStatement_ID(), this.get_TrxName()) < 0) {
                return false;
            }
        }
        MBankStatementLine[] lines = this.getLines(true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MBankStatementLine line = lines[i2];
            if (line.getStmtAmt().compareTo(Env.ZERO) == 0) continue;
            String description = Msg.getMsg((Ctx)this.getCtx(), (String)"Voided") + " (" + Msg.translate((Ctx)this.getCtx(), (String)"StmtAmt") + "=" + line.getStmtAmt();
            if (line.getTrxAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate((Ctx)this.getCtx(), (String)"TrxAmt") + "=" + line.getTrxAmt();
            }
            if (line.getChargeAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate((Ctx)this.getCtx(), (String)"ChargeAmt") + "=" + line.getChargeAmt();
            }
            if (line.getInterestAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate((Ctx)this.getCtx(), (String)"InterestAmt") + "=" + line.getInterestAmt();
            }
            description = description + ")";
            line.addDescription(description);
            line.setStmtAmt(Env.ZERO);
            line.setTrxAmt(Env.ZERO);
            line.setChargeAmt(Env.ZERO);
            line.setInterestAmt(Env.ZERO);
            line.save(this.get_TrxName());
            if (line.getC_Payment_ID() == 0) continue;
            MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
            payment.setIsReconciled(false);
            payment.save(this.get_TrxName());
        }
        this.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided"));
        BigDecimal voidedDifference = this.getStatementDifference();
        this.setStatementDifference(Env.ZERO);
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        ba.setCurrentBalance(ba.getCurrentBalance().subtract(voidedDifference));
        ba.save(this.get_TrxName());
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"StatementDifference")).append("=").append(this.getStatementDifference()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    public int getC_Currency_ID() {
        return 0;
    }
}

