/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MCStageElement;
import org.compiere.model.MTemplate;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_CStage;
import org.compiere.model.X_CM_CStageTTable;
import org.compiere.model.X_CM_TemplateTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MCStage
extends X_CM_CStage {
    private static CLogger s_log = CLogger.getCLogger(MCStage.class);
    private MTemplate m_template = null;
    private MWebProject m_project = null;

    public static MCStage[] getStages(MWebProject project) {
        ArrayList<MCStage> list = new ArrayList<MCStage>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_CStage WHERE CM_WebProject_ID=? ORDER BY CM_CStage_ID";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCStage(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCStage[] retValue = new MCStage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MCStage getByName(MWebProject project, String RelativeURL, int parent_ID) {
        MCStage retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_CStage WHERE CM_WebProject_ID=? AND RelativeURL LIKE ? AND CM_CStage_ID IN (SELECT Node_ID FROM AD_TreeNodeCMS WHERE  AD_Tree_ID=? AND Parent_ID=?)ORDER BY CM_CStage_ID";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            pstmt.setString(2, RelativeURL);
            pstmt.setInt(3, project.getAD_TreeCMS_ID());
            pstmt.setInt(4, parent_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCStage(project.getCtx(), rs, project.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MCStage[] getStagesByTemplate(MWebProject project, int CM_Template_ID) {
        ArrayList<MCStage> list = new ArrayList<MCStage>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_CStage WHERE CM_WebProject_ID=? AND CM_Template_ID=?";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            pstmt.setInt(2, CM_Template_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCStage(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCStage[] retValue = new MCStage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MTemplate getTemplate() {
        if (this.getCM_Template_ID() > 0 && this.m_template == null) {
            this.m_template = MTemplate.get(this.getCtx(), this.getCM_Template_ID(), null);
        }
        return this.m_template;
    }

    public MCStage(Ctx ctx, int CM_CStage_ID, String trxName) {
        super(ctx, CM_CStage_ID, trxName);
        if (CM_CStage_ID == 0) {
            this.setIsValid(false);
            this.setIsModified(false);
            this.setIsSecure(false);
            this.setIsSummary(false);
            this.setIsIndexed(false);
        }
    }

    public MCStage(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setRelativeURL(String RelativeURL) {
        if (RelativeURL != null) {
            int index;
            if (RelativeURL.endsWith("/")) {
                RelativeURL = RelativeURL.substring(0, RelativeURL.length() - 1);
            }
            if ((index = RelativeURL.lastIndexOf("/")) != -1) {
                RelativeURL = RelativeURL.substring(index + 1);
            }
        }
        super.setRelativeURL(RelativeURL);
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMS_ID();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCStage[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if ((!this.isSummary() || this.getContainerType().equals("L")) && this.getCM_Template_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"Template"));
            return false;
        }
        if (this.is_Changed() && !this.is_ValueChanged("IsModified")) {
            this.setIsModified(true);
        }
        this.setRelativeURL(this.getRelativeURL());
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!this.isSummary()) {
            this.checkElements();
            this.checkTemplateTable();
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMS (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMS");
            } else {
                this.log.warning("#" + no + " - TreeType=CMS");
            }
            return no > 0;
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMS ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMS");
        } else {
            this.log.warning("#" + no + " - TreeType=CMS");
        }
        return no > 0;
    }

    public String validate() {
        return "";
    }

    protected boolean checkElements() {
        String thisElement;
        MTemplate thisTemplate = new MTemplate(this.getCtx(), this.getCM_Template_ID(), this.get_TrxName());
        StringBuffer thisElementList = new StringBuffer(thisTemplate.getElements());
        while (thisElementList.indexOf("\n") >= 0) {
            thisElement = thisElementList.substring(0, thisElementList.indexOf("\n"));
            thisElementList.delete(0, thisElementList.indexOf("\n") + 1);
            if (thisElement == null || thisElement.equals("")) continue;
            this.checkElement(thisElement);
        }
        thisElement = thisElementList.toString();
        if (thisElement != null && !thisElement.equals("")) {
            this.checkElement(thisElement);
        }
        return true;
    }

    protected MCStageElement getElementByName(String elementName) {
        return MCStageElement.getByName(this.getCtx(), this.get_ID(), elementName, this.get_TrxName());
    }

    protected void checkElement(String elementName) {
        MCStageElement thisElement = this.getElementByName(elementName);
        if (thisElement == null) {
            thisElement = new MCStageElement(this.getCtx(), 0, this.get_TrxName());
            thisElement.setAD_Client_ID(this.getAD_Client_ID());
            thisElement.setAD_Org_ID(this.getAD_Org_ID());
            thisElement.setCM_CStage_ID(this.get_ID());
            thisElement.setContentHTML(" ");
            thisElement.setName(elementName);
            thisElement.save(this.get_TrxName());
        }
    }

    protected boolean checkTemplateTable() {
        int[] tableKeys = X_CM_TemplateTable.getAllIDs((String)"CM_TemplateTable", (String)("CM_Template_ID=" + this.getCM_Template_ID()), (String)this.get_TrxName());
        if (tableKeys != null) {
            for (int i2 = 0; i2 < tableKeys.length; ++i2) {
                X_CM_TemplateTable thisTemplateTable = new X_CM_TemplateTable(this.getCtx(), tableKeys[i2], this.get_TrxName());
                int[] existingKeys = X_CM_CStageTTable.getAllIDs((String)"CM_CStageTTable", (String)("CM_TemplateTable_ID=" + thisTemplateTable.get_ID()), (String)this.get_TrxName());
                if (existingKeys != null && existingKeys.length != 0) continue;
                X_CM_CStageTTable newCStageTTable = new X_CM_CStageTTable(this.getCtx(), 0, this.get_TrxName());
                newCStageTTable.setAD_Client_ID(this.getAD_Client_ID());
                newCStageTTable.setAD_Org_ID(this.getAD_Org_ID());
                newCStageTTable.setCM_CStage_ID(this.get_ID());
                newCStageTTable.setCM_TemplateTable_ID(thisTemplateTable.get_ID());
                newCStageTTable.setDescription(thisTemplateTable.getDescription());
                newCStageTTable.setName(thisTemplateTable.getName());
                newCStageTTable.setOtherClause(thisTemplateTable.getOtherClause());
                newCStageTTable.setWhereClause(thisTemplateTable.getWhereClause());
                newCStageTTable.save();
            }
        }
        return true;
    }
}

