/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.p;
import org.compiere.model.MChatEntry;
import org.compiere.model.MUser;
import org.compiere.model.X_CM_Chat;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class MChat
extends X_CM_Chat {
    private static CLogger s_log = CLogger.getCLogger(MChat.class);
    private MChatEntry[] m_entries = null;
    private SimpleDateFormat m_format = null;

    public static MChat[] getOfTable(Ctx ctx, int AD_Table_ID) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        ArrayList<MChat> list = new ArrayList<MChat>();
        String sql = "SELECT * FROM CM_Chat WHERE AD_Client_ID=? AND AD_Table_ID=? ORDER BY Record_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MChat(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MChat[] retValue = new MChat[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MChat(Ctx ctx, int CM_Chat_ID, String trxName) {
        super(ctx, CM_Chat_ID, trxName);
        if (CM_Chat_ID == 0) {
            this.setConfidentialType("A");
            this.setModerationType("N");
        }
    }

    public MChat(Ctx ctx, int AD_Table_ID, int Record_ID, String Description, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
        this.setDescription(Description);
    }

    public MChat(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MChatEntry[] getEntries(boolean reload) {
        if (this.m_entries != null && !reload) {
            return this.m_entries;
        }
        ArrayList<MChatEntry> list = new ArrayList<MChatEntry>();
        String sql = "SELECT * FROM CM_ChatEntry WHERE CM_Chat_ID=? ORDER BY Created";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getCM_Chat_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MChatEntry(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_entries = new MChatEntry[list.size()];
        list.toArray(this.m_entries);
        return this.m_entries;
    }

    public void setDescription(String Description) {
        if (Description != null && Description.length() > 0) {
            super.setDescription(Description);
        } else {
            super.setDescription(this.getAD_Table_ID() + "#" + this.getRecord_ID());
        }
    }

    public p getHistory(String ConfidentialType) {
        p history = new p();
        this.getEntries(false);
        boolean first = true;
        for (int i2 = 0; i2 < this.m_entries.length; ++i2) {
            MChatEntry entry = this.m_entries[i2];
            if (!entry.isActive() || !entry.isConfidentialType(ConfidentialType)) continue;
            if (first) {
                first = false;
            } else {
                history.addElement((Element)new hr());
            }
            b b2 = new b();
            MUser user = MUser.get((Ctx)this.getCtx(), (int)entry.getCreatedBy());
            b2.addElement(user.getName());
            b2.addElement(" \t");
            Timestamp created = entry.getCreated();
            if (this.m_format == null) {
                this.m_format = DisplayType.getDateFormat((int)16);
            }
            b2.addElement(this.m_format.format(created));
            history.addElement((Element)b2);
            p p2 = new p();
            String data = entry.getCharacterData();
            data = Util.maskHTML((String)data, (boolean)true);
            p2.addElement(data);
            history.addElement((Element)p2);
        }
        return history;
    }
}

