/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MCommissionLine;
import org.compiere.model.X_C_Commission;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MCommission
extends X_C_Commission {
    public MCommission(Ctx ctx, int C_Commission_ID, String trxName) {
        super(ctx, C_Commission_ID, trxName);
        if (C_Commission_ID == 0) {
            this.setDocBasisType("I");
            this.setFrequencyType("M");
            this.setListDetails(false);
        }
    }

    public MCommission(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionLine[] getLines() {
        String sql = "SELECT * FROM C_CommissionLine WHERE C_Commission_ID=? ORDER BY Line";
        ArrayList<MCommissionLine> list = new ArrayList<MCommissionLine>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Commission_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCommissionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCommissionLine[] retValue = new MCommissionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void setDateLastRun(Timestamp DateLastRun) {
        if (DateLastRun != null) {
            super.setDateLastRun(DateLastRun);
        }
    }

    public int copyLinesFrom(MCommission otherCom) {
        if (otherCom == null) {
            return 0;
        }
        MCommissionLine[] fromLines = otherCom.getLines();
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MCommissionLine line = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)fromLines[i2], (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            line.set_ValueNoCheck("C_CommissionLine_ID", null);
            line.setC_Commission_ID(this.getC_Commission_ID());
            if (!line.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

