/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.X_C_CommissionAmt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCommissionAmt
extends X_C_CommissionAmt {
    public MCommissionAmt(Ctx ctx, int C_CommissionAmt_ID, String trxName) {
        super(ctx, C_CommissionAmt_ID, trxName);
        if (C_CommissionAmt_ID == 0) {
            this.setActualQty(Env.ZERO);
            this.setCommissionAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
    }

    public MCommissionAmt(MCommissionRun run, int C_CommissionLine_ID) {
        this(run.getCtx(), 0, run.get_TrxName());
        this.setClientOrg((PO)run);
        this.setC_CommissionRun_ID(run.getC_CommissionRun_ID());
        this.setC_CommissionLine_ID(C_CommissionLine_ID);
    }

    public MCommissionAmt(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionDetail[] getDetails() {
        String sql = "SELECT * FROM C_CommissionDetail WHERE C_CommissionAmt_ID=?";
        ArrayList<MCommissionDetail> list = new ArrayList<MCommissionDetail>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_CommissionAmt_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCommissionDetail(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCommissionDetail[] retValue = new MCommissionDetail[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void calculateCommission() {
        BigDecimal amt;
        MCommissionDetail[] details = this.getDetails();
        BigDecimal ConvertedAmt = Env.ZERO;
        BigDecimal ActualQty = Env.ZERO;
        for (int i2 = 0; i2 < details.length; ++i2) {
            MCommissionDetail detail = details[i2];
            amt = detail.getConvertedAmt();
            if (amt == null) {
                amt = Env.ZERO;
            }
            ConvertedAmt = ConvertedAmt.add(amt);
            ActualQty = ActualQty.add(detail.getActualQty());
        }
        this.setConvertedAmt(ConvertedAmt);
        this.setActualQty(ActualQty);
        MCommissionLine cl = new MCommissionLine(this.getCtx(), this.getC_CommissionLine_ID(), this.get_TrxName());
        BigDecimal qty = this.getActualQty().subtract(cl.getQtySubtract());
        if (cl.isPositiveOnly() && qty.signum() < 0) {
            qty = Env.ZERO;
        }
        qty = qty.multiply(cl.getQtyMultiplier());
        amt = this.getConvertedAmt().subtract(cl.getAmtSubtract());
        if (cl.isPositiveOnly() && amt.signum() < 0) {
            amt = Env.ZERO;
        }
        amt = amt.multiply(cl.getAmtMultiplier());
        this.setCommissionAmt(amt.add(qty));
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            this.updateRunHeader();
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateRunHeader();
        }
        return success;
    }

    private void updateRunHeader() {
        MCommissionRun run = new MCommissionRun(this.getCtx(), this.getC_CommissionRun_ID(), this.get_TrxName());
        run.updateFromAmt();
        run.save();
    }
}

