/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.compiere.framework.PO;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MConversionRate;
import org.compiere.model.X_C_CommissionDetail;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class MCommissionDetail
extends X_C_CommissionDetail {
    public MCommissionDetail(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MCommissionDetail(MCommissionAmt amt, int C_Currency_ID, BigDecimal Amt, BigDecimal Qty) {
        super(amt.getCtx(), 0, amt.get_TrxName());
        this.setClientOrg((PO)amt);
        this.setC_CommissionAmt_ID(amt.getC_CommissionAmt_ID());
        this.setC_Currency_ID(C_Currency_ID);
        this.setActualAmt(Amt);
        this.setActualQty(Qty);
        this.setConvertedAmt(Env.ZERO);
    }

    public MCommissionDetail(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setLineIDs(int C_OrderLine_ID, int C_InvoiceLine_ID) {
        if (C_OrderLine_ID != 0) {
            this.setC_OrderLine_ID(C_OrderLine_ID);
        }
        if (C_InvoiceLine_ID != 0) {
            this.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        }
    }

    public void setConvertedAmt(Timestamp date) {
        BigDecimal amt = MConversionRate.convertBase((Ctx)this.getCtx(), (BigDecimal)this.getActualAmt(), (int)this.getC_Currency_ID(), (Timestamp)date, (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        if (amt != null) {
            this.setConvertedAmt(amt);
        }
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            this.updateAmtHeader();
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateAmtHeader();
        }
        return success;
    }

    private void updateAmtHeader() {
        MCommissionAmt amt = new MCommissionAmt(this.getCtx(), this.getC_CommissionAmt_ID(), this.get_TrxName());
        amt.calculateCommission();
        amt.save();
    }
}

