/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.model.X_C_DunningRunEntry;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDunningRunEntry
extends X_C_DunningRunEntry {
    private static CLogger s_log = CLogger.getCLogger(MPayment.class);
    private MDunningRun m_parent = null;

    public MDunningRunEntry(Ctx ctx, int C_DunningRunEntry_ID, String trxName) {
        super(ctx, C_DunningRunEntry_ID, trxName);
        if (C_DunningRunEntry_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MDunningRunEntry(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningRunEntry(MDunningRun parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setC_DunningRun_ID(parent.getC_DunningRun_ID());
        this.m_parent = parent;
    }

    public void setBPartner(MBPartner bp, boolean isSOTrx) {
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locations = bp.getLocations(false);
        if (locations.length == 1) {
            this.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
        } else {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                MBPartnerLocation location = locations[i2];
                if (!location.isActive() || (!location.isPayFrom() || !isSOTrx) && (!location.isRemitTo() || isSOTrx)) continue;
                this.setC_BPartner_Location_ID(location.getC_BPartner_Location_ID());
                break;
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            String msg = "@C_BPartner_ID@ " + bp.getName();
            msg = isSOTrx ? msg + " @No@ @IsPayFrom@" : msg + " @No@ @IsRemitTo@";
            throw new IllegalArgumentException(msg);
        }
        MUser[] users = MUser.getOfBPartner((Ctx)this.getCtx(), (int)bp.getC_BPartner_ID());
        if (users.length == 1) {
            this.setAD_User_ID(users[0].getAD_User_ID());
        } else {
            for (int i3 = 0; i3 < users.length; ++i3) {
                MUser user = users[i3];
                if (user.getC_BPartner_Location_ID() != this.getC_BPartner_Location_ID()) continue;
                this.setAD_User_ID(users[i3].getAD_User_ID());
                break;
            }
        }
        int SalesRep_ID = bp.getSalesRep_ID();
        if (SalesRep_ID != 0) {
            this.setSalesRep_ID(SalesRep_ID);
        }
    }

    public MDunningRunLine[] getLines() {
        return this.getLines(false);
    }

    public MDunningRunLine[] getLines(boolean onlyInvoices) {
        ArrayList<MDunningRunLine> list = new ArrayList<MDunningRunLine>();
        String sql = "SELECT * FROM C_DunningRunLine WHERE C_DunningRunEntry_ID=?";
        if (onlyInvoices) {
            sql = sql + " AND C_Invoice_ID IS NOT NULL";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDunningRunLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MDunningRunLine[] retValue = new MDunningRunLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public boolean hasInvoices() {
        boolean retValue = false;
        String sql = "SELECT COUNT(*) FROM C_DunningRunLine WHERE C_DunningRunEntry_ID=? AND C_Invoice_ID IS NOT NULL";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                retValue = true;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    private MDunningRun getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDunningRun(this.getCtx(), this.getC_DunningRun_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isProcessed() && this.is_ValueChanged("Processed")) {
            MDunningRunLine[] theseLines = this.getLines();
            for (int i2 = 0; i2 < theseLines.length; ++i2) {
                theseLines[i2].setProcessed(true);
                theseLines[i2].save(this.get_TrxName());
            }
        }
        return true;
    }
}

