/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRefList;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_InOutConfirm;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInOutConfirm
extends X_M_InOutConfirm
implements DocAction {
    private static CLogger s_log = CLogger.getCLogger(MInOutConfirm.class);
    private MInOutLineConfirm[] m_lines = null;
    private MInvoice m_creditMemo = null;
    private MInventory m_inventory = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MInOutConfirm create(MInOut ship, String confirmType, boolean checkExisting) {
        if (checkExisting) {
            MInOutConfirm[] confirmations = ship.getConfirmations(false);
            for (int i2 = 0; i2 < confirmations.length; ++i2) {
                MInOutConfirm confirm = confirmations[i2];
                if (!confirm.getConfirmType().equals(confirmType)) continue;
                s_log.info("create - existing: " + (Object)((Object)confirm));
                return confirm;
            }
        }
        MInOutConfirm confirm = new MInOutConfirm(ship, confirmType);
        confirm.save(ship.get_TrxName());
        MInOutLine[] shipLines = ship.getLines(false);
        for (int i3 = 0; i3 < shipLines.length; ++i3) {
            MInOutLine sLine = shipLines[i3];
            MInOutLineConfirm cLine = new MInOutLineConfirm(confirm);
            cLine.setInOutLine(sLine);
            cLine.save(ship.get_TrxName());
        }
        s_log.info("New: " + (Object)((Object)confirm));
        return confirm;
    }

    public MInOutConfirm(Ctx ctx, int M_InOutConfirm_ID, String trxName) {
        super(ctx, M_InOutConfirm_ID, trxName);
        if (M_InOutConfirm_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setIsCancelled(false);
            this.setIsInDispute(false);
            super.setProcessed(false);
        }
    }

    public MInOutConfirm(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutConfirm(MInOut ship, String confirmType) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg((PO)ship);
        this.setM_InOut_ID(ship.getM_InOut_ID());
        this.setConfirmType(confirmType);
    }

    public MInOutLineConfirm[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        String sql = "SELECT * FROM M_InOutLineConfirm WHERE M_InOutConfirm_ID=?";
        ArrayList<MInOutLineConfirm> list = new ArrayList<MInOutLineConfirm>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_InOutConfirm_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOutLineConfirm(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MInOutLineConfirm[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String getConfirmTypeName() {
        return MRefList.getListName((Ctx)this.getCtx(), (int)320, (String)this.getConfirmType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutConfirm[");
        sb.append(this.get_ID()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        return Msg.getElement((Ctx)this.getCtx(), (String)"M_InOutConfirm_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public void setIsApproved(boolean IsApproved) {
        if (IsApproved && !this.isApproved()) {
            int AD_User_ID = this.getCtx().getAD_User_ID();
            MUser user = MUser.get((Ctx)this.getCtx(), (int)AD_User_ID);
            String info = user.getName() + ": " + Msg.translate((Ctx)this.getCtx(), (String)"IsApproved") + " - " + new Timestamp(System.currentTimeMillis());
            this.addDescription(info);
        }
        super.setIsApproved(IsApproved);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MInOutLineConfirm[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        boolean difference = false;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            if (lines[i2].isFullyConfirmed()) continue;
            difference = true;
            break;
        }
        this.setIsInDispute(difference);
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MDocType dt;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MInOut inout = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        MInOutLineConfirm[] lines = this.getLines(false);
        if (this.isInDispute() && (dt = MDocType.get((Ctx)this.getCtx(), (int)inout.getC_DocType_ID())).isSplitWhenDifference()) {
            if (dt.getC_DocTypeDifference_ID() == 0) {
                this.m_processMsg = "No Split Document Type defined for: " + dt.getName();
                return "IN";
            }
            this.splitInOut(inout, dt.getC_DocTypeDifference_ID(), lines);
            this.m_lines = null;
        }
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MInOutLineConfirm confirmLine = lines[i2];
            confirmLine.set_TrxName(this.get_TrxName());
            if (!confirmLine.processLine(inout.isSOTrx(), this.getConfirmType())) {
                this.m_processMsg = "ShipLine not saved - " + (Object)((Object)confirmLine);
                return "IN";
            }
            if (confirmLine.isFullyConfirmed()) {
                confirmLine.setProcessed(true);
                confirmLine.save(this.get_TrxName());
                continue;
            }
            if (this.createDifferenceDoc(inout, confirmLine)) {
                confirmLine.setProcessed(true);
                confirmLine.save(this.get_TrxName());
                continue;
            }
            this.log.log(Level.SEVERE, "Scrapped=" + confirmLine.getScrappedQty() + " - Difference=" + confirmLine.getDifferenceQty());
            return "IN";
        }
        if (this.m_creditMemo != null) {
            this.m_processMsg = this.m_processMsg + " @C_Invoice_ID@=" + this.m_creditMemo.getDocumentNo();
        }
        if (this.m_inventory != null) {
            this.m_processMsg = this.m_processMsg + " @M_Inventory_ID@=" + this.m_inventory.getDocumentNo();
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void splitInOut(MInOut original, int C_DocType_ID, MInOutLineConfirm[] confirmLines) {
        MInOut split = new MInOut(original, C_DocType_ID, original.getMovementDate());
        split.addDescription("Splitted from " + original.getDocumentNo());
        split.setIsInDispute(true);
        split.setRef_InOut_ID(original.get_ID());
        if (!split.save(this.get_TrxName())) {
            throw new IllegalStateException("Cannot save Split");
        }
        original.addDescription("Split: " + split.getDocumentNo());
        if (!original.save(this.get_TrxName())) {
            throw new IllegalStateException("Cannot update original Shipment");
        }
        for (int i2 = 0; i2 < confirmLines.length; ++i2) {
            MInOutLineConfirm confirmLine = confirmLines[i2];
            BigDecimal differenceQty = confirmLine.getDifferenceQty();
            if (differenceQty.compareTo(Env.ZERO) == 0) continue;
            MInOutLine oldLine = confirmLine.getLine();
            this.log.fine("Qty=" + differenceQty + ", Old=" + (Object)((Object)oldLine));
            MInOutLine splitLine = new MInOutLine(split);
            splitLine.setC_OrderLine_ID(oldLine.getC_OrderLine_ID());
            splitLine.setC_UOM_ID(oldLine.getC_UOM_ID());
            splitLine.setDescription(oldLine.getDescription());
            splitLine.setIsDescription(oldLine.isDescription());
            splitLine.setLine(oldLine.getLine());
            splitLine.setM_AttributeSetInstance_ID(oldLine.getM_AttributeSetInstance_ID());
            splitLine.setM_Locator_ID(oldLine.getM_Locator_ID());
            splitLine.setM_Product_ID(oldLine.getM_Product_ID());
            splitLine.setM_Warehouse_ID(oldLine.getM_Warehouse_ID());
            splitLine.setRef_InOutLine_ID(oldLine.getRef_InOutLine_ID());
            splitLine.addDescription("Split: from " + oldLine.getMovementQty());
            splitLine.setQty(differenceQty);
            if (!splitLine.save(this.get_TrxName())) {
                throw new IllegalStateException("Cannot save Split Line");
            }
            oldLine.addDescription("Splitted: from " + oldLine.getMovementQty());
            oldLine.setQty(oldLine.getMovementQty().subtract(differenceQty));
            if (!oldLine.save(this.get_TrxName())) {
                throw new IllegalStateException("Cannot save Splited Line");
            }
            confirmLine.setTargetQty(confirmLine.getTargetQty().subtract(differenceQty));
            confirmLine.setDifferenceQty(Env.ZERO);
            if (confirmLine.save(this.get_TrxName())) continue;
            throw new IllegalStateException("Cannot save Split Confirmation");
        }
        this.m_processMsg = "Split @M_InOut_ID@=" + split.getDocumentNo() + " - @M_InOutConfirm_ID@=";
        split.processIt("PR");
        split.save(this.get_TrxName());
        MInOutConfirm[] splitConfirms = split.getConfirmations(true);
        if (splitConfirms.length > 0) {
            int index = 0;
            if (splitConfirms[index].isProcessed()) {
                if (splitConfirms.length > 1) {
                    ++index;
                }
                if (splitConfirms[index].isProcessed()) {
                    this.m_processMsg = this.m_processMsg + splitConfirms[index].getDocumentNo() + " processed??";
                    return;
                }
            }
            splitConfirms[index].setIsInDispute(true);
            splitConfirms[index].save(this.get_TrxName());
            this.m_processMsg = this.m_processMsg + splitConfirms[index].getDocumentNo();
            MInOutLineConfirm[] splitConfirmLines = splitConfirms[index].getLines(false);
            for (int i3 = 0; i3 < splitConfirmLines.length; ++i3) {
                MInOutLineConfirm splitConfirmLine = splitConfirmLines[i3];
                splitConfirmLine.setScrappedQty(Env.ZERO);
                splitConfirmLine.setConfirmedQty(Env.ZERO);
                splitConfirmLine.save(this.get_TrxName());
            }
        } else {
            this.m_processMsg = this.m_processMsg + "??";
        }
    }

    private boolean createDifferenceDoc(MInOut inout, MInOutLineConfirm confirm) {
        if (this.m_processMsg == null) {
            this.m_processMsg = "";
        } else if (this.m_processMsg.length() > 0) {
            this.m_processMsg = this.m_processMsg + "; ";
        }
        if (confirm.getDifferenceQty().signum() != 0 && !inout.isSOTrx() && !inout.isReturnTrx() && inout.getRef_InOut_ID() != 0) {
            this.log.info("Difference=" + confirm.getDifferenceQty());
            if (this.m_creditMemo == null) {
                this.m_creditMemo = new MInvoice(inout, null);
                this.m_creditMemo.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"M_InOutConfirm_ID") + " " + this.getDocumentNo());
                this.m_creditMemo.setC_DocTypeTarget_ID("APC");
                if (!this.m_creditMemo.save(this.get_TrxName())) {
                    this.m_processMsg = this.m_processMsg + "Credit Memo not created";
                    return false;
                }
                this.setC_Invoice_ID(this.m_creditMemo.getC_Invoice_ID());
            }
            MInvoiceLine line = new MInvoiceLine(this.m_creditMemo);
            line.setShipLine(confirm.getLine());
            line.setQty(confirm.getDifferenceQty());
            if (!line.save(this.get_TrxName())) {
                this.m_processMsg = this.m_processMsg + "Credit Memo Line not created";
                return false;
            }
            confirm.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        }
        if (confirm.getScrappedQty().signum() != 0) {
            MInOutLine ioLine;
            MInventoryLine line;
            this.log.info("Scrapped=" + confirm.getScrappedQty());
            if (this.m_inventory == null) {
                MWarehouse wh = MWarehouse.get((Ctx)this.getCtx(), (int)inout.getM_Warehouse_ID());
                this.m_inventory = new MInventory(wh);
                this.m_inventory.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"M_InOutConfirm_ID") + " " + this.getDocumentNo());
                if (!this.m_inventory.save(this.get_TrxName())) {
                    this.m_processMsg = this.m_processMsg + "Inventory not created";
                    return false;
                }
                this.setM_Inventory_ID(this.m_inventory.getM_Inventory_ID());
            }
            if (!(line = new MInventoryLine(this.m_inventory, (ioLine = confirm.getLine()).getM_Locator_ID(), ioLine.getM_Product_ID(), ioLine.getM_AttributeSetInstance_ID(), confirm.getScrappedQty(), Env.ZERO)).save(this.get_TrxName())) {
                this.m_processMsg = this.m_processMsg + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        if (!confirm.save(this.get_TrxName())) {
            this.m_processMsg = this.m_processMsg + "Confirmation Line not saved";
            return false;
        }
        return true;
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    public int getC_Currency_ID() {
        return 0;
    }
}

