/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.model.MIndexLog;
import org.compiere.model.X_K_Index;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIndex
extends X_K_Index {
    private static CLogger s_log = CLogger.getCLogger(MIndex.class);
    private static final char[] s_char = new char[]{'\u00c4', '\u00d6', '\u00dc', '\u00df'};
    private static final String[] s_string = new String[]{"AE", "OE", "UE", "SS"};

    public MIndex(Ctx ctx, int K_Index_ID, String trxName) {
        super(ctx, K_Index_ID, trxName);
    }

    public MIndex(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static int cleanUp(String trxName, int AD_Client_ID, int AD_Table_ID, int Record_ID) {
        StringBuffer sb = new StringBuffer("DELETE FROM K_Index WHERE AD_Client_ID=" + AD_Client_ID + " AND " + "AD_Table_ID=" + AD_Table_ID + " AND " + "Record_ID=" + Record_ID);
        int no = DB.executeUpdate((String)sb.toString(), (String)trxName);
        return no;
    }

    public void setKeyword(String Keyword) {
        String kw = MIndex.standardizeKeyword(Keyword);
        if (kw == null) {
            kw = "?";
        }
        super.setKeyword(kw);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("Keyword")) {
            this.setKeyword(this.getKeyword());
        }
        if (this.getKeyword().equals("?")) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"Keyword"));
            return false;
        }
        return true;
    }

    public static Hashtable indexStringBuffer(StringBuffer thisText) {
        return MIndex.indexString(thisText.toString());
    }

    public static Hashtable<String, String> indexString(String thisText) {
        if ((thisText = MIndex.removeHTML(thisText)) != null) {
            String[] keywords = thisText.toUpperCase().split("\\t|\\p{Punct}|\\p{Space}");
            Hashtable<String, String> keyhash = new Hashtable<String, String>(keywords.length);
            int currentPos = 0;
            for (int i2 = 0; i2 < keywords.length; ++i2) {
                int endExcerpt;
                String thisExcerpt = "";
                if (keywords[i2].length() < 2 || keyhash.contains(keywords[i2])) continue;
                int startExcerpt = thisText.toUpperCase().indexOf(keywords[i2], currentPos);
                if (startExcerpt > 50) {
                    startExcerpt -= 50;
                }
                if (startExcerpt > thisText.length() && startExcerpt > 50 && thisText.length() > 50) {
                    startExcerpt = thisText.length() - 50;
                }
                if ((endExcerpt = thisText.toUpperCase().indexOf(keywords[i2], currentPos) + keywords[i2].length()) > currentPos) {
                    currentPos = endExcerpt;
                }
                if (endExcerpt < thisText.length() - 50) {
                    endExcerpt += 50;
                }
                if (endExcerpt > thisText.length()) {
                    endExcerpt = thisText.length();
                }
                thisExcerpt = thisText.substring(startExcerpt, endExcerpt);
                keyhash.put(keywords[i2], thisExcerpt);
            }
            return keyhash;
        }
        return null;
    }

    public static boolean runIndex(String thisText, Ctx ctx, String trxName, int tableID, int recordID, int CMWebProjectID, Timestamp sourceUpdated) {
        if (thisText != null) {
            Hashtable<String, String> keyHash = MIndex.indexString(thisText);
            Enumeration<String> e = keyHash.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String value = keyHash.get(name);
                MIndex thisIndex = new MIndex(ctx, 0, trxName);
                thisIndex.setAD_Table_ID(tableID);
                if (CMWebProjectID > 0) {
                    thisIndex.setCM_WebProject_ID(CMWebProjectID);
                }
                thisIndex.setExcerpt(value);
                thisIndex.setKeyword(name);
                thisIndex.setRecord_ID(recordID);
                thisIndex.setSourceUpdated(sourceUpdated);
                thisIndex.save();
            }
            return true;
        }
        return false;
    }

    public static void reIndex(boolean runCleanUp, String[] toBeIndexed, Ctx ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, int CM_WebProject_ID, Timestamp lastUpdated) {
        String trxName = "ReIndex_" + AD_Table_ID + "_" + Record_ID;
        try {
            if (!runCleanUp) {
                MIndex.cleanUp(trxName, AD_Client_ID, AD_Table_ID, Record_ID);
            }
            for (int i2 = 0; i2 < toBeIndexed.length; ++i2) {
                MIndex.runIndex(toBeIndexed[i2], ctx, trxName, AD_Table_ID, Record_ID, CM_WebProject_ID, lastUpdated);
            }
            DB.commit((boolean)true, (String)trxName);
        }
        catch (SQLException sqlE) {
            try {
                DB.rollback((boolean)true, (String)trxName);
            }
            catch (SQLException sqlE2) {
                // empty catch block
            }
        }
    }

    protected static String removeHTML(String textElement) {
        String retValue = textElement.replaceAll("<?\\w+((\\s+\\w+(\\s*=\\s*(?:\"b(.|\\n)*?\"|'(.|\\n)*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>", " ");
        retValue = retValue.replaceAll("</", " ");
        retValue = retValue.replaceAll("\\\\n", " ");
        return retValue.toString();
    }

    protected static String standardizeKeyword(String keyword) {
        if (keyword == null) {
            return null;
        }
        if ((keyword = keyword.trim()).length() == 0) {
            return null;
        }
        keyword = keyword.toUpperCase();
        StringBuffer sb = new StringBuffer();
        char[] chars = keyword.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char c = chars[i2];
            sb.append(MIndex.standardizeCharacter(c));
        }
        return sb.toString();
    }

    private static String standardizeCharacter(char c) {
        if (c >= '!' && c <= 'Z') {
            return String.valueOf(c);
        }
        int index = Arrays.binarySearch(s_char, c);
        if (index < 0) {
            return String.valueOf(c);
        }
        return s_string[index];
    }

    public static MIndex[] getResults(String query, Ctx ctx, String trxName) {
        String sql = "SELECT * FROM K_Index WHERE K_Index_ID IN (SELECT MAX(K_Index_ID) FROM K_Index WHERE Keyword LIKE ? GROUP BY AD_Table_ID, Record_ID)";
        Hashtable<Integer, MIndex> tTable = new Hashtable<Integer, MIndex>();
        CPreparedStatement pstmt = null;
        try {
            MIndex tIndex;
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setString(1, query.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                tIndex = new MIndex(ctx, rs, trxName);
                tTable.put(tIndex.get_ID(), tIndex);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setString(1, query.toUpperCase() + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tIndex = new MIndex(ctx, rs, trxName);
                if (tTable.containsKey(tIndex.get_ID())) continue;
                tTable.put(tIndex.get_ID(), tIndex);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setString(1, "%" + query.toUpperCase() + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tIndex = new MIndex(ctx, rs, trxName);
                if (tTable.containsKey(tIndex.get_ID())) continue;
                tTable.put(tIndex.get_ID(), tIndex);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getResults", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MIndexLog thisLog = new MIndexLog(ctx, 0, trxName);
        thisLog.setIndexQuery(query);
        thisLog.setIndexQueryResult(tTable.size());
        thisLog.setQuerySource("C");
        thisLog.save();
        MIndex[] entries = new MIndex[tTable.size()];
        Enumeration E = tTable.keys();
        int i2 = 0;
        while (E.hasMoreElements()) {
            entries[i2++] = (MIndex)((Object)tTable.get(E.nextElement()));
        }
        return entries;
    }
}

