/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MLead;
import org.compiere.model.MLocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRequest;
import org.compiere.model.MRole;
import org.compiere.model.MSource;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class MInvoiceLine
extends X_C_InvoiceLine {
    private static CLogger s_log = CLogger.getCLogger(MInvoiceLine.class);
    private int m_M_PriceList_ID = 0;
    private Timestamp m_DateInvoiced = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner_Location_ID = 0;
    private boolean m_IsSOTrx = true;
    private boolean m_priceSet = false;
    private MProduct m_product = null;
    private String m_name = null;
    private Integer m_precision = null;
    private MProductPricing m_productPricing = null;
    private MInvoice m_parent = null;

    public static MInvoiceLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        MInvoiceLine retValue = null;
        String sql = "SELECT * FROM C_InvoiceLine WHERE M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)sLine.get_TrxName());
            pstmt.setInt(1, sLine.getM_InOutLine_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MInvoiceLine(sLine.getCtx(), rs, sLine.get_TrxName());
                if (rs.next()) {
                    s_log.warning("More than one C_InvoiceLine of " + (Object)((Object)sLine));
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MInvoiceLine(Ctx ctx, int C_InvoiceLine_ID, String trxName) {
        super(ctx, C_InvoiceLine_ID, trxName);
        if (C_InvoiceLine_ID == 0) {
            this.setIsDescription(false);
            this.setIsPrinted(true);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setTaxAmt(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
        }
    }

    public MInvoiceLine(MInvoice invoice) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setInvoice(invoice);
    }

    public MInvoiceLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setInvoice(MInvoice invoice) {
        this.m_parent = invoice;
        this.m_M_PriceList_ID = invoice.getM_PriceList_ID();
        this.m_DateInvoiced = invoice.getDateInvoiced();
        this.m_C_BPartner_ID = invoice.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = invoice.getC_BPartner_Location_ID();
        this.m_IsSOTrx = invoice.isSOTrx();
        this.m_precision = new Integer(invoice.getPrecision());
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setOrderLine(MOrderLine oLine) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setIsDescription(oLine.isDescription());
        this.setDescription(oLine.getDescription());
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setM_Product_ID(oLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        this.setPriceEntered(oLine.getPriceEntered());
        this.setPriceActual(oLine.getPriceActual());
        this.setPriceLimit(oLine.getPriceLimit());
        this.setPriceList(oLine.getPriceList());
        this.setC_Tax_ID(oLine.getC_Tax_ID());
        this.setLineNetAmt(oLine.getLineNetAmt());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
        this.setRRAmt(oLine.getRRAmt());
        this.setRRStartDate(oLine.getRRStartDate());
    }

    public void setShipLine(MInOutLine sLine) {
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        this.setLine(sLine.getLine());
        this.setIsDescription(sLine.isDescription());
        this.setDescription(sLine.getDescription());
        this.setM_Product_ID(sLine.getM_Product_ID());
        this.setC_UOM_ID(sLine.getC_UOM_ID());
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        this.setC_Charge_ID(sLine.getC_Charge_ID());
        int C_OrderLine_ID = sLine.getC_OrderLine_ID();
        if (C_OrderLine_ID != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
            this.setPriceEntered(oLine.getPriceEntered());
            this.setPriceActual(oLine.getPriceActual());
            this.setPriceLimit(oLine.getPriceLimit());
            this.setPriceList(oLine.getPriceList());
            this.setC_Tax_ID(oLine.getC_Tax_ID());
            this.setLineNetAmt(oLine.getLineNetAmt());
            this.setC_Project_ID(oLine.getC_Project_ID());
        } else {
            this.setPrice();
            this.setTax();
        }
        this.setC_Project_ID(sLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(sLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(sLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(sLine.getC_Activity_ID());
        this.setC_Campaign_ID(sLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(sLine.getAD_OrgTrx_ID());
        this.setUser1_ID(sLine.getUser1_ID());
        this.setUser2_ID(sLine.getUser2_ID());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", new Integer(0));
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setInvoice(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        this.m_productPricing = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), this.getM_Product_ID(), C_BPartner_ID, this.getQtyInvoiced(), this.m_IsSOTrx);
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPricing.setPriceDate(this.m_DateInvoiced);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyInvoiced()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyInvoiced().divide(this.getQtyEntered(), 6, 4)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        MOrg org = MOrg.get((Ctx)this.getCtx(), (int)this.getAD_Org_ID());
        int M_Warehouse_ID = org.getM_Warehouse_ID();
        int C_Tax_ID = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.m_DateInvoiced, this.m_DateInvoiced, this.getAD_Org_ID(), M_Warehouse_ID, this.m_C_BPartner_Location_ID, this.m_C_BPartner_Location_ID, this.m_IsSOTrx);
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        if (this.m_IsSOTrx) {
            // empty if block
        }
        return true;
    }

    public void setTaxAmt() {
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MTax tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setLineNetAmt() {
        BigDecimal net = this.getPriceActual().multiply(this.getQtyInvoiced());
        if (net.scale() > this.getPrecision()) {
            net = net.setScale(this.getPrecision(), 4);
        }
        super.setLineNetAmt(net);
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyInvoiced(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setQtyInvoiced(BigDecimal QtyInvoiced) {
        MProduct product = this.getProduct();
        if (QtyInvoiced != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyInvoiced = QtyInvoiced.setScale(precision, 4);
        }
        super.setQtyInvoiced(QtyInvoiced);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoiceLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyInvoiced=").append(this.getQtyInvoiced()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.m_name == null) {
            String sql = "SELECT COALESCE (p.Name, c.Name) FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE C_InvoiceLine_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getC_InvoiceLine_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (this.m_name == null) {
                    this.m_name = "??";
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getName", (Throwable)e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {}
                pstmt = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Invoice x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Invoice_ID=?";
        int i2 = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
        if (i2 < 0) {
            this.log.warning("Precision=" + i2 + " - set to 2");
            i2 = 2;
        }
        this.m_precision = new Integer(i2);
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM C_Invoice WHERE C_Invoice_ID=?", (int)this.getC_Invoice_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    public void createLeadRequest(MInvoice invoice) {
        if (this.getProduct() == null || this.m_product.getR_Source_ID() == 0) {
            return;
        }
        String summary = "Purchased: " + this.m_product.getName() + " - " + this.getQtyEntered() + " * " + this.getPriceEntered();
        MSource source = MSource.get(this.getCtx(), this.m_product.getR_Source_ID());
        if ("B".equals(source.getSourceCreateType()) || "R".equals(source.getSourceCreateType())) {
            MRequest request = new MRequest(this.getCtx(), 0, this.get_TrxName());
            request.setClientOrg((PO)this);
            request.setSummary(summary);
            request.setAD_User_ID(invoice.getAD_User_ID());
            request.setC_BPartner_ID(invoice.getC_BPartner_ID());
            request.setC_Invoice_ID(invoice.getC_Invoice_ID());
            request.setC_Order_ID(invoice.getC_Order_ID());
            request.setC_Activity_ID(invoice.getC_Activity_ID());
            request.setC_Campaign_ID(invoice.getC_Campaign_ID());
            request.setC_Project_ID(invoice.getC_Project_ID());
            request.setM_Product_ID(this.getM_Product_ID());
            request.setR_Source_ID(source.getR_Source_ID());
            request.save();
        }
        if ("B".equals(source.getSourceCreateType()) || "L".equals(source.getSourceCreateType())) {
            MLead lead = new MLead(this.getCtx(), 0, this.get_TrxName());
            lead.setClientOrg((PO)this);
            lead.setDescription(summary);
            lead.setAD_User_ID(invoice.getAD_User_ID());
            lead.setC_BPartner_Location_ID(invoice.getC_BPartner_Location_ID());
            lead.setC_BPartner_ID(invoice.getC_BPartner_ID());
            lead.setC_Campaign_ID(invoice.getC_Campaign_ID());
            lead.setC_Project_ID(invoice.getC_Project_ID());
            MBPartnerLocation bpLoc = new MBPartnerLocation(this.getCtx(), invoice.getC_BPartner_Location_ID(), null);
            MLocation loc = bpLoc.getLocation(false);
            lead.setAddress1(loc.getAddress1());
            lead.setAddress2(loc.getAddress2());
            lead.setCity(loc.getCity());
            lead.setPostal(loc.getPostal());
            lead.setPostal_Add(loc.getPostal_Add());
            lead.setRegionName(loc.getRegionName(false));
            lead.setC_Region_ID(loc.getC_Region_ID());
            lead.setC_City_ID(loc.getC_City_ID());
            lead.setC_Country_ID(loc.getC_Country_ID());
            lead.setR_Source_ID(source.getR_Source_ID());
            lead.save();
        }
    }

    @UICallout
    public void setS_ResourceAssignment_ID(String oldS_ResourceAssignment_ID, String newS_ResourceAssignment_ID, int windowNo) throws Exception {
        if (newS_ResourceAssignment_ID == null || newS_ResourceAssignment_ID.length() == 0) {
            return;
        }
        int S_ResourceAssignment_ID = Integer.parseInt(newS_ResourceAssignment_ID);
        if (S_ResourceAssignment_ID == 0) {
            return;
        }
        super.setS_ResourceAssignment_ID(S_ResourceAssignment_ID);
        int M_Product_ID = 0;
        String Name = null;
        String Description = null;
        BigDecimal Qty = null;
        String sql = "SELECT p.M_Product_ID, ra.Name, ra.Description, ra.Qty FROM S_ResourceAssignment ra INNER JOIN M_Product p ON (p.S_Resource_ID=ra.S_Resource_ID) WHERE ra.S_ResourceAssignment_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, S_ResourceAssignment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Product_ID = rs.getInt(1);
                Name = rs.getString(2);
                Description = rs.getString(3);
                Qty = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine("S_ResourceAssignment_ID=" + S_ResourceAssignment_ID + " - M_Product_ID=" + M_Product_ID);
        if (M_Product_ID != 0) {
            this.setM_Product_ID(M_Product_ID);
            if (Description != null) {
                Name = Name + " (" + Description + ")";
            }
            if (!".".equals(Name)) {
                this.setDescription(Name);
            }
            if (Qty != null) {
                this.setQtyInvoiced(Qty);
            }
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("New=" + newRecord);
        if (this.getC_Charge_ID() != 0) {
            if (this.getM_Product_ID() != 0) {
                this.setM_Product_ID(0);
            }
        } else if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
            this.setPrice();
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_InvoiceLine WHERE C_Invoice_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyInvoiced")) {
            this.setQtyInvoiced(this.getQtyInvoiced());
        }
        this.setLineNetAmt();
        if (this.getTaxAmt().compareTo(Env.ZERO) == 0) {
            this.setTaxAmt();
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MInvoiceTax tax;
        if (!success || this.isProcessed()) {
            return success;
        }
        if (!newRecord && this.is_ValueChanged("C_Tax_ID") && (tax = MInvoiceTax.get(this, this.getPrecision(), true, this.get_TrxName())) != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return true;
            }
        }
        return this.updateHeaderTax();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        String sql;
        int no;
        MInvoiceTax tax = MInvoiceTax.get(this, this.getPrecision(), false, this.get_TrxName());
        if (tax != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (!tax.save(this.get_TrxName())) {
                return false;
            }
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = this.isTaxIncluded() ? "UPDATE C_Invoice i SET GrandTotal=TotalLines WHERE C_Invoice_ID=" + this.getC_Invoice_ID() : "UPDATE C_Invoice i SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_InvoiceTax it WHERE i.C_Invoice_ID=it.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID()), (String)this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public String allocateLandedCosts() {
        int i2;
        MInOutLine iol;
        if (this.isProcessed()) {
            return "Processed";
        }
        MLandedCost[] lcs = MLandedCost.getLandedCosts(this);
        if (lcs.length == 0) {
            return "";
        }
        String sql = "DELETE FROM C_LandedCostAllocation WHERE C_InvoiceLine_ID=" + this.getC_InvoiceLine_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 0) {
            this.log.info("Deleted #" + no);
        }
        int inserted = 0;
        if (lcs.length == 1) {
            MLandedCost lc = lcs[0];
            if (lc.getM_InOut_ID() != 0) {
                MInOutLine iol2;
                int i3;
                ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i4 = 0; i4 < lines.length; ++i4) {
                    if (lines[i4].isDescription() || lines[i4].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i4].getM_Product_ID()) continue;
                    list.add(lines[i4]);
                }
                if (list.size() == 0) {
                    return "No Matching Lines (with Product) in Shipment";
                }
                BigDecimal total = Env.ZERO;
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)((Object)list.get(i3));
                    total = total.add(iol2.getBase(lc.getLandedCostDistribution()));
                }
                if (total.signum() == 0) {
                    return "Total of Base values is 0 - " + lc.getLandedCostDistribution();
                }
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)((Object)list.get(i3));
                    MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                    lca.setM_Product_ID(iol2.getM_Product_ID());
                    lca.setM_AttributeSetInstance_ID(iol2.getM_AttributeSetInstance_ID());
                    BigDecimal base = iol2.getBase(lc.getLandedCostDistribution());
                    lca.setBase(base);
                    if (base.signum() != 0) {
                        double result = this.getLineNetAmt().multiply(base).doubleValue();
                        lca.setAmt(result /= total.doubleValue(), this.getPrecision());
                    }
                    if (!lca.save()) {
                        return "Cannot save line Allocation = " + (Object)((Object)lca);
                    }
                    ++inserted;
                }
                this.log.info("Inserted " + inserted);
                this.allocateLandedCostRounding();
                return "";
            }
            if (lc.getM_InOutLine_ID() != 0) {
                MInOutLine iol3 = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName());
                if (iol3.isDescription() || iol3.getM_Product_ID() == 0) {
                    return "Invalid Receipt Line - " + (Object)((Object)iol3);
                }
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(iol3.getM_Product_ID());
                lca.setM_AttributeSetInstance_ID(iol3.getM_AttributeSetInstance_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save single line Allocation = " + (Object)((Object)lc);
            }
            if (lc.getM_Product_ID() != 0) {
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(lc.getM_Product_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save Product Allocation = " + (Object)((Object)lc);
            }
            return "No Reference for " + (Object)((Object)lc);
        }
        String LandedCostDistribution = lcs[0].getLandedCostDistribution();
        int M_CostElement_ID = lcs[0].getM_CostElement_ID();
        for (int i5 = 0; i5 < lcs.length; ++i5) {
            MLandedCost lc = lcs[i5];
            if (!LandedCostDistribution.equals(lc.getLandedCostDistribution())) {
                return "Multiple Landed Cost Rules must have consistent Landed Cost Distribution";
            }
            if (lc.getM_Product_ID() != 0 && lc.getM_InOut_ID() == 0 && lc.getM_InOutLine_ID() == 0) {
                return "Multiple Landed Cost Rules cannot directly allocate to a Product";
            }
            if (M_CostElement_ID == lc.getM_CostElement_ID()) continue;
            return "Multiple Landed Cost Rules cannot different Cost Elements";
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        for (int ii = 0; ii < lcs.length; ++ii) {
            MLandedCost lc = lcs[ii];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i6 = 0; i6 < lines.length; ++i6) {
                    if (lines[i6].isDescription() || lines[i6].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i6].getM_Product_ID()) continue;
                    list.add(lines[i6]);
                }
                continue;
            }
            if (lc.getM_InOutLine_ID() == 0 || (iol = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName())).isDescription() || iol.getM_Product_ID() == 0) continue;
            list.add(iol);
        }
        if (list.size() == 0) {
            return "No Matching Lines (with Product)";
        }
        BigDecimal total = Env.ZERO;
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)((Object)list.get(i2));
            total = total.add(iol.getBase(LandedCostDistribution));
        }
        if (total.signum() == 0) {
            return "Total of Base values is 0 - " + LandedCostDistribution;
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)((Object)list.get(i2));
            MLandedCostAllocation lca = new MLandedCostAllocation(this, lcs[0].getM_CostElement_ID());
            lca.setM_Product_ID(iol.getM_Product_ID());
            lca.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            BigDecimal base = iol.getBase(LandedCostDistribution);
            lca.setBase(base);
            if (base.signum() != 0) {
                double result = this.getLineNetAmt().multiply(base).doubleValue();
                lca.setAmt(result /= total.doubleValue(), this.getPrecision());
            }
            if (!lca.save()) {
                return "Cannot save line Allocation = " + (Object)((Object)lca);
            }
            ++inserted;
        }
        this.log.info("Inserted " + inserted);
        this.allocateLandedCostRounding();
        return "";
    }

    private void allocateLandedCostRounding() {
        MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        MLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        for (int i2 = 0; i2 < allocations.length; ++i2) {
            MLandedCostAllocation allocation = allocations[i2];
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
        }
        BigDecimal difference = this.getLineNetAmt().subtract(allocationAmt);
        if (difference.signum() != 0) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.save();
            this.log.config("Difference=" + difference + ", C_LandedCostAllocation_ID=" + largestAmtAllocation.getC_LandedCostAllocation_ID() + ", Amt" + largestAmtAllocation.getAmt());
        }
    }

    private boolean setQty(int WindowNo, String columnName) {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = this.getQtyEntered();
            this.setQtyInvoiced(QtyEntered);
        } else if (columnName.equals("C_UOM_ID")) {
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = this.getC_UOM_ID();
            BigDecimal QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            BigDecimal PriceActual = this.getPriceActual();
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyInvoiced/PriceEntered=" + QtyInvoiced + "/" + PriceEntered);
            this.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            this.setQtyInvoiced(QtyInvoiced);
            this.setPriceEntered(PriceEntered);
        } else if (columnName.equals("QtyEntered")) {
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = this.getC_UOM_ID();
            BigDecimal QtyEntered = this.getQtyEntered();
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(this.getCtx(), C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                this.setQtyEntered(QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyInvoiced=" + QtyInvoiced);
            this.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            this.setQtyInvoiced(QtyInvoiced);
        } else if (columnName.equals("QtyInvoiced")) {
            BigDecimal QtyEntered;
            int precision;
            BigDecimal QtyInvoiced1;
            int C_UOM_To_ID = this.getC_UOM_ID();
            BigDecimal QtyInvoiced = this.getQtyInvoiced();
            if (QtyInvoiced.compareTo(QtyInvoiced1 = QtyInvoiced.setScale(precision = MProduct.get(this.getCtx(), M_Product_ID).getUOMPrecision(), 4)) != 0) {
                this.log.fine("Corrected QtyInvoiced Scale " + QtyInvoiced + "->" + QtyInvoiced1);
                QtyInvoiced = QtyInvoiced1;
                this.setQtyInvoiced(QtyInvoiced);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyInvoiced)) == null) {
                QtyEntered = QtyInvoiced;
            }
            boolean conversion = QtyInvoiced.compareTo(QtyEntered) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyInvoiced=" + QtyInvoiced + " -> " + conversion + " QtyEntered=" + QtyEntered);
            this.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            this.setQtyEntered(QtyEntered);
        }
        return true;
    }

    private boolean setAmt(int WindowNo, String columnName) {
        BigDecimal LineNetAmt;
        boolean enforce;
        int C_UOM_To_ID = this.getC_UOM_ID();
        int M_Product_ID = this.getM_Product_ID();
        int M_PriceList_ID = this.getCtx().getContextAsInt(WindowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getPricePrecision(this.getCtx(), M_PriceList_ID);
        BigDecimal QtyEntered = this.getQtyEntered();
        BigDecimal QtyInvoiced = this.getQtyInvoiced();
        this.log.fine("QtyEntered=" + QtyEntered + ", Invoiced=" + QtyInvoiced + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = this.getPriceEntered();
        BigDecimal PriceActual = this.getPriceActual();
        BigDecimal PriceLimit = this.getPriceLimit();
        BigDecimal PriceList = this.getPriceList();
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual);
        if ((columnName.equals("QtyInvoiced") || columnName.equals("QtyEntered") || columnName.equals("M_Product_ID")) && !"N".equals(this.getCtx().getContext(WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = this.getCtx().getContextAsInt(WindowNo, "C_BPartner_ID");
            if (columnName.equals("QtyEntered")) {
                QtyInvoiced = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyInvoiced == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean IsSOTrx = this.getCtx().isSOTrx(WindowNo);
            MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, QtyInvoiced, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = this.getCtx().getContextAsInt(WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = new Timestamp(this.getCtx().getContextAsTime(WindowNo, "DateInvoiced"));
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("amt - QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            this.setPriceActual(PriceActual);
            this.setPriceEntered(PriceEntered);
            this.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (columnName.equals("PriceActual")) {
            PriceActual = this.getPriceActual();
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("amt - PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            this.setPriceEntered(PriceEntered);
        } else if (columnName.equals("PriceEntered")) {
            PriceEntered = this.getPriceEntered();
            PriceActual = MUOMConversion.convertProductTo(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("amt - PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            this.setPriceActual(PriceActual);
        }
        String epl = this.getCtx().getContext(WindowNo, "EnforcePriceLimit");
        boolean bl = enforce = this.getCtx().isSOTrx(WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            BigDecimal Discount;
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(this.getCtx(), M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("amt =(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            this.setPriceActual(PriceLimit);
            this.setPriceEntered(PriceEntered);
            this.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"UnderLimitPrice"));
            if (PriceList.intValue() != 0 && (Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0)).scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
        }
        if ((LineNetAmt = QtyInvoiced.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("amt = LineNetAmt=" + LineNetAmt);
        this.setLineNetAmt(LineNetAmt);
        boolean IsSOTrx = this.getCtx().isSOTrx(WindowNo);
        if (!IsSOTrx) {
            BigDecimal TaxAmt = Env.ZERO;
            if (columnName.equals("TaxAmt")) {
                TaxAmt = this.getTaxAmt();
            } else {
                Integer taxID = this.getC_Tax_ID();
                if (taxID != null) {
                    int C_Tax_ID = taxID;
                    MTax tax = new MTax(this.getCtx(), C_Tax_ID, null);
                    TaxAmt = tax.calculateTax(LineNetAmt, this.isTaxIncluded(), StdPrecision);
                    this.setTaxAmt(TaxAmt);
                }
            }
            this.setLineTotalAmt(LineNetAmt.add(TaxAmt));
        }
        return true;
    }

    @UICallout
    public void setC_UOM_ID(String oldC_UOM_ID, String newC_UOM_ID, int windowNo) throws Exception {
        if (newC_UOM_ID == null || newC_UOM_ID.length() == 0) {
            return;
        }
        int C_UOM_ID = Integer.parseInt(newC_UOM_ID);
        if (C_UOM_ID == 0) {
            return;
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setQty(windowNo, "C_UOM_ID");
        this.setAmt(windowNo, "C_UOM_ID");
    }

    @UICallout
    public void setQtyEntered(String oldQtyEntered, String newQtyEntered, int windowNo) throws Exception {
        if (newQtyEntered == null || newQtyEntered.length() == 0) {
            return;
        }
        BigDecimal QtyEntered = new BigDecimal(newQtyEntered);
        super.setQtyEntered(QtyEntered);
        this.setQty(windowNo, "QtyEntered");
        this.setAmt(windowNo, "QtyEntered");
    }

    @UICallout
    public void setQtyInvoiced(String oldQtyInvoiced, String newQtyInvoiced, int windowNo) throws Exception {
        if (newQtyInvoiced == null || newQtyInvoiced.length() == 0) {
            return;
        }
        BigDecimal qtyInvoiced = new BigDecimal(newQtyInvoiced);
        super.setQtyInvoiced(qtyInvoiced);
        this.setQty(windowNo, "QtyInvoiced");
        this.setAmt(windowNo, "QtyInvoiced");
    }

    @UICallout
    public void setC_Tax_ID(String oldC_Tax_ID, String newC_Tax_ID, int windowNo) throws Exception {
        if (newC_Tax_ID == null || newC_Tax_ID.length() == 0) {
            return;
        }
        BigDecimal C_Tax_ID = new BigDecimal(newC_Tax_ID);
        super.setTaxAmt(C_Tax_ID);
        this.setAmt(windowNo, "C_Tax_ID");
    }

    @UICallout
    public void setPriceActual(String oldPriceActual, String newPriceActual, int windowNo) throws Exception {
        if (newPriceActual == null || newPriceActual.length() == 0) {
            return;
        }
        BigDecimal PriceActual = new BigDecimal(newPriceActual);
        super.setPriceActual(PriceActual);
        this.setAmt(windowNo, "PriceActual");
    }

    @UICallout
    public void setPriceEntered(String oldPriceEntered, String newPriceEntered, int windowNo) throws Exception {
        if (newPriceEntered == null || newPriceEntered.length() == 0) {
            return;
        }
        BigDecimal PriceEntered = new BigDecimal(newPriceEntered);
        super.setPriceEntered(PriceEntered);
        this.setAmt(windowNo, "PriceEntered");
    }

    @UICallout
    public void setTaxAmt(String oldTaxAmt, String newTaxAmt, int windowNo) throws Exception {
        if (newTaxAmt == null || newTaxAmt.length() == 0) {
            return;
        }
        BigDecimal taxAmt = new BigDecimal(newTaxAmt);
        super.setTaxAmt(taxAmt);
        this.setAmt(windowNo, "TaxAmt");
    }

    @UICallout
    public void setM_Product_ID(String oldM_Product_ID, String newM_Product_ID, int WindowNo) throws Exception {
        if (newM_Product_ID == null || newM_Product_ID.length() == 0) {
            return;
        }
        int M_Product_ID = Integer.parseInt(newM_Product_ID);
        if (M_Product_ID == 0) {
            return;
        }
        this.setC_Charge_ID(0);
        if (this.getCtx().getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID && this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            this.setM_AttributeSetInstance_ID(new Integer(this.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID")));
        } else {
            this.setM_AttributeSetInstance_ID(-1);
        }
        boolean IsSOTrx = this.getCtx().isSOTrx(WindowNo);
        int C_BPartner_ID = this.getCtx().getContextAsInt(WindowNo, "C_BPartner_ID");
        BigDecimal Qty = this.getQtyInvoiced();
        MProductPricing pp = new MProductPricing(this.getAD_Client_ID(), this.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = this.getCtx().getContextAsInt(WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        int M_PriceList_Version_ID = this.getCtx().getContextAsInt(WindowNo, "M_PriceList_Version_ID");
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        long time = this.getCtx().getContextAsTime(WindowNo, "DateInvoiced");
        pp.setPriceDate(time);
        this.setPriceList(pp.getPriceList());
        this.setPriceLimit(pp.getPriceLimit());
        this.setPriceActual(pp.getPriceStd());
        this.setPriceEntered(pp.getPriceStd());
        this.setContext(WindowNo, "C_Currency_ID", Integer.toString(pp.getC_Currency_ID()));
        this.setC_UOM_ID(new Integer(pp.getC_UOM_ID()));
        this.setContext(WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        this.setContext(WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        this.setTax(WindowNo, "M_Product_ID");
    }

    @UICallout
    public void setC_Charge_ID(String oldC_Charge_ID, String newC_Charge_ID, int WindowNo) throws Exception {
        if (newC_Charge_ID == null || newC_Charge_ID.length() == 0) {
            return;
        }
        int C_Charge_ID = Integer.parseInt(newC_Charge_ID);
        if (C_Charge_ID == 0) {
            return;
        }
        if (this.getM_Product_ID() != 0) {
            this.setC_Charge_ID(0);
            this.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"ChargeExclusively"));
        }
        this.setM_AttributeSetInstance_ID(-1);
        this.setS_ResourceAssignment_ID(0);
        this.setC_UOM_ID(new Integer(100));
        this.setContext(WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Charge_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setPriceEntered(rs.getBigDecimal(1));
                this.setPriceActual(rs.getBigDecimal(1));
                this.setPriceLimit(Env.ZERO);
                this.setPriceList(Env.ZERO);
                this.setContext(WindowNo, "Discount", Env.ZERO.toString());
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql + e);
            this.addError(e.getLocalizedMessage());
        }
        this.setTax(WindowNo, "C_Charge_ID");
    }

    private boolean setTax(int WindowNo, String columnName) {
        int M_Product_ID = this.getM_Product_ID();
        int C_Charge_ID = this.getC_Charge_ID();
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.setAmt(WindowNo, columnName);
        }
        int shipC_BPartner_Location_ID = this.getCtx().getContextAsInt(WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.setAmt(WindowNo, columnName);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        int billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        Timestamp billDate = new Timestamp(this.getCtx().getContextAsTime(WindowNo, "DateInvoiced"));
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = billDate;
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = this.getAD_Org_ID();
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = this.getCtx().getContextAsInt("#M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int C_Tax_ID = Tax.get(this.getCtx(), M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, this.getCtx().isSOTrx(WindowNo));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            ValueNamePair pp = CLogger.retrieveError();
            if (pp != null) {
                this.addError(pp.getValue());
            } else {
                this.addError(Msg.getMsg((Ctx)this.getCtx(), (String)"Tax Error"));
            }
        } else {
            this.setC_Tax_ID(new Integer(C_Tax_ID));
        }
        return this.setAmt(WindowNo, columnName);
    }
}

