/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.X_M_MatchInv;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MMatchInv
extends X_M_MatchInv {
    private static CLogger s_log = CLogger.getCLogger(MMatchInv.class);

    public static MMatchInv[] get(Ctx ctx, int M_InOutLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (M_InOutLine_ID == 0 || C_InvoiceLine_ID == 0) {
            return new MMatchInv[0];
        }
        String sql = "SELECT * FROM M_MatchInv WHERE M_InOutLine_ID=? AND C_InvoiceLine_ID=?";
        ArrayList<MMatchInv> list = new ArrayList<MMatchInv>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_InOutLine_ID);
            pstmt.setInt(2, C_InvoiceLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchInv(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMatchInv[] retValue = new MMatchInv[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchInv[] get(Ctx ctx, int M_InOutLine_ID, String trxName) {
        if (M_InOutLine_ID == 0) {
            return new MMatchInv[0];
        }
        String sql = "SELECT * FROM M_MatchInv WHERE M_InOutLine_ID=?";
        ArrayList<MMatchInv> list = new ArrayList<MMatchInv>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_InOutLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchInv(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMatchInv[] retValue = new MMatchInv[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchInv[] getInOut(Ctx ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID == 0) {
            return new MMatchInv[0];
        }
        String sql = "SELECT * FROM M_MatchInv m INNER JOIN M_InOutLine l ON (m.M_InOutLine_ID=l.M_InOutLine_ID) WHERE l.M_InOut_ID=?";
        ArrayList<MMatchInv> list = new ArrayList<MMatchInv>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_InOut_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchInv(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMatchInv[] retValue = new MMatchInv[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchInv[] getInvoice(Ctx ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchInv[0];
        }
        String sql = "SELECT * FROM M_MatchInv mi INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) WHERE il.C_Invoice_ID=?";
        ArrayList<MMatchInv> list = new ArrayList<MMatchInv>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMatchInv(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMatchInv[] retValue = new MMatchInv[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMatchInv(Ctx ctx, int M_MatchInv_ID, String trxName) {
        super(ctx, M_MatchInv_ID, trxName);
        if (M_MatchInv_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchInv(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchInv(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg((PO)iLine);
        this.setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(iLine.getM_InOutLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    private Timestamp getNewerDateAcct() {
        ResultSet rs;
        Timestamp invoiceDate = null;
        Timestamp shipDate = null;
        String sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getC_InvoiceLine_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                invoiceDate = rs.getTimestamp(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getM_InOutLine_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                shipDate = rs.getTimestamp(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    protected boolean beforeDelete() {
        if (this.isPosted()) {
            if (!MPeriod.isOpen(this.getCtx(), this.getDateTrx(), "MXI")) {
                return false;
            }
            this.setPosted(false);
            return MFactAcct.delete(472, this.get_ID(), this.get_TrxName()) >= 0;
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            int C_OrderLine_ID = iLine.getC_OrderLine_ID();
            if (C_OrderLine_ID == 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                C_OrderLine_ID = ioLine.getC_OrderLine_ID();
            }
            if (C_OrderLine_ID == 0) {
                return success;
            }
            MMatchPO[] mPO = MMatchPO.get(this.getCtx(), C_OrderLine_ID, this.getC_InvoiceLine_ID(), this.get_TrxName());
            for (int i2 = 0; i2 < mPO.length; ++i2) {
                if (mPO[i2].getM_InOutLine_ID() == 0) {
                    mPO[i2].delete(true);
                    continue;
                }
                mPO[i2].setC_InvoiceLine_ID(null);
                mPO[i2].save();
            }
        }
        return success;
    }
}

