/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.X_PA_Measure;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MMeasure
extends X_PA_Measure {
    private static CCache<Integer, MMeasure> s_cache = new CCache("PA_Measure", 10);

    public static MMeasure get(Ctx ctx, int PA_Measure_ID) {
        Integer key = new Integer(PA_Measure_ID);
        MMeasure retValue = (MMeasure)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MMeasure(ctx, PA_Measure_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MMeasure(Ctx ctx, int PA_Measure_ID, String trxName) {
        super(ctx, PA_Measure_ID, trxName);
    }

    public MMeasure(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMeasure[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("C".equals(this.getMeasureType()) && this.getPA_MeasureCalc_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"PA_MeasureCalc_ID"));
            return false;
        }
        if ("R".equals(this.getMeasureType()) && this.getPA_Ratio_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"PA_Ratio_ID"));
            return false;
        }
        if ("U".equals(this.getMeasureType()) && (this.getCalculationClass() == null || this.getCalculationClass().length() == 0)) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"CalculationClass"));
            return false;
        }
        if ("Q".equals(this.getMeasureType()) && this.getR_RequestType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"R_RequestType_ID"));
            return false;
        }
        if ("P".equals(this.getMeasureType()) && this.getC_ProjectType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"C_ProjectType_ID"));
            return false;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && "M".equals(this.getMeasureType())) {
            this.updateManualGoals();
        }
        return success;
    }

    public boolean updateGoals() {
        String mt = this.getMeasureType();
        try {
            if ("M".equals(mt)) {
                return this.updateManualGoals();
            }
            if ("A".equals(mt)) {
                return this.updateAchievementGoals();
            }
            if ("C".equals(mt)) {
                return this.updateCalculatedGoals();
            }
            if ("R".equals(mt)) {
                return this.updateRatios();
            }
            if ("Q".equals(mt)) {
                return this.updateRequests();
            }
            if ("P".equals(mt)) {
                return this.updateProjects();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MeasureType=" + mt, (Throwable)e);
        }
        return false;
    }

    private boolean updateManualGoals() {
        if (!"M".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            MGoal goal = goals[i2];
            goal.setMeasureActual(this.getManualActual());
            goal.save();
        }
        return true;
    }

    private boolean updateAchievementGoals() {
        if (!"A".equals(this.getMeasureType())) {
            return false;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            MGoal goal = goals[i2];
            String MeasureScope = goal.getMeasureScope();
            String trunc = "D";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "W";
            }
            Timestamp compare = TimeUtil.trunc((Timestamp)today, (String)trunc);
            MAchievement[] achievements = MAchievement.getOfMeasure(this.getCtx(), this.getPA_Measure_ID());
            BigDecimal ManualActual = Env.ZERO;
            for (int j = 0; j < achievements.length; ++j) {
                Timestamp ach;
                MAchievement achievement = achievements[j];
                if (!achievement.isAchieved() || achievement.getDateDoc() == null || !compare.equals(ach = TimeUtil.trunc((Timestamp)achievement.getDateDoc(), (String)trunc))) continue;
                ManualActual = ManualActual.add(achievement.getManualActual());
            }
            goal.setMeasureActual(ManualActual);
            goal.save();
        }
        return true;
    }

    private boolean updateCalculatedGoals() {
        if (!"C".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            MMeasureCalc mc;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get((Ctx)this.getCtx(), (int)goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Ctx)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault((Ctx)this.getCtx(), (boolean)false);
            }
            if ((mc = MMeasureCalc.get(this.getCtx(), this.getPA_MeasureCalc_ID())) == null || mc.get_ID() == 0 || mc.get_ID() != this.getPA_MeasureCalc_ID()) {
                this.log.log(Level.SEVERE, "Not found PA_MeasureCalc_ID=" + this.getPA_MeasureCalc_ID());
                return false;
            }
            BigDecimal ManualActual = null;
            String sql = mc.getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ManualActual = rs.getBigDecimal(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ManualActual == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save();
        }
        return true;
    }

    private boolean updateRatios() {
        if (!"R".equals(this.getMeasureType())) {
            return false;
        }
        return false;
    }

    private boolean updateRequests() {
        if (!"Q".equals(this.getMeasureType()) || this.getR_RequestType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get((Ctx)this.getCtx(), (int)goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Ctx)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault((Ctx)this.getCtx(), (boolean)false);
            }
            BigDecimal ManualActual = null;
            MRequestType rt = MRequestType.get(this.getCtx(), this.getR_RequestType_ID());
            String sql = rt.getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ManualActual = rs.getBigDecimal(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ManualActual == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save();
        }
        return true;
    }

    private boolean updateProjects() {
        if (!"P".equals(this.getMeasureType()) || this.getC_ProjectType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i2];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get((Ctx)this.getCtx(), (int)goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Ctx)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault((Ctx)this.getCtx(), (boolean)false);
            }
            BigDecimal ManualActual = null;
            MProjectType pt = MProjectType.get(this.getCtx(), this.getC_ProjectType_ID());
            String sql = pt.getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ManualActual = rs.getBigDecimal(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ManualActual == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save();
        }
        return true;
    }
}

