/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MMedia;
import org.compiere.model.MMediaServer;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_MediaDeploy;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MMediaDeploy
extends X_CM_MediaDeploy {
    private static CLogger s_log = CLogger.getCLogger(MMedia.class);
    private MMediaServer m_mserver = null;

    public MMediaDeploy(Ctx ctx, int CM_MediaDeploy_ID, String trxName) {
        super(ctx, CM_MediaDeploy_ID, trxName);
    }

    public MMediaDeploy(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMediaDeploy(MMediaServer server, MMedia media) {
        this(server.getCtx(), 0, server.get_TrxName());
        this.setCM_Media_Server_ID(server.getCM_Media_Server_ID());
        this.setCM_Media_ID(media.getCM_Media_ID());
        this.setClientOrg((PO)server);
        this.setIsDeployed(true);
        this.setLastSynchronized(new Timestamp(System.currentTimeMillis()));
    }

    public static MMediaDeploy[] getByMediaAndProject(Ctx ctx, int CM_Media_ID, MWebProject thisProject, boolean createIfMissing, String trxName) {
        ArrayList<MMediaDeploy> list = new ArrayList<MMediaDeploy>();
        MMediaServer[] theseServers = MMediaServer.getMediaServer(thisProject);
        if (theseServers != null && theseServers.length > 0) {
            for (int i2 = 0; i2 < theseServers.length; ++i2) {
                list.add(MMediaDeploy.getByMedia(ctx, CM_Media_ID, theseServers[i2].get_ID(), createIfMissing, trxName));
            }
        }
        MMediaDeploy[] retValue = new MMediaDeploy[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMediaServer getServer() {
        if (this.m_mserver == null) {
            this.m_mserver = new MMediaServer(this.getCtx(), this.getCM_Media_Server_ID(), this.get_TrxName());
        }
        return this.m_mserver;
    }

    public static MMediaDeploy getByMedia(Ctx ctx, int CM_Media_ID, int CM_Media_Server_ID, boolean createIfMissing, String trxName) {
        MMediaDeploy thisMMediaDeploy = null;
        String sql = "SELECT * FROM CM_MediaDeploy WHERE CM_Media_ID=? AND CM_Media_Server_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, CM_Media_ID);
            pstmt.setInt(2, CM_Media_Server_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisMMediaDeploy = new MMediaDeploy(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (thisMMediaDeploy == null && createIfMissing) {
            thisMMediaDeploy = new MMediaDeploy(ctx, 0, trxName);
            thisMMediaDeploy.setCM_Media_Server_ID(CM_Media_Server_ID);
            thisMMediaDeploy.setCM_Media_ID(CM_Media_ID);
            thisMMediaDeploy.setIsDeployed(false);
            thisMMediaDeploy.setLastSynchronized(null);
            thisMMediaDeploy.save();
        }
        return thisMMediaDeploy;
    }
}

