/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineConfirm;
import org.compiere.model.MPeriod;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_MovementConfirm;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MMovementConfirm
extends X_M_MovementConfirm
implements DocAction {
    private MMovementLineConfirm[] m_lines = null;
    private MInventory m_inventoryFrom = null;
    private MInventory m_inventoryTo = null;
    private String m_inventoryInfo = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MMovementConfirm create(MMovement move, boolean checkExisting) {
        MMovementConfirm[] confirmations;
        int i2;
        if (checkExisting && (i2 = 0) < (confirmations = move.getConfirmations(false)).length) {
            MMovementConfirm confirm = confirmations[i2];
            return confirm;
        }
        MMovementConfirm confirm = new MMovementConfirm(move);
        confirm.save(move.get_TrxName());
        MMovementLine[] moveLines = move.getLines(false);
        for (int i3 = 0; i3 < moveLines.length; ++i3) {
            MMovementLine mLine = moveLines[i3];
            MMovementLineConfirm cLine = new MMovementLineConfirm(confirm);
            cLine.setMovementLine(mLine);
            cLine.save(move.get_TrxName());
        }
        return confirm;
    }

    public MMovementConfirm(Ctx ctx, int M_MovementConfirm_ID, String trxName) {
        super(ctx, M_MovementConfirm_ID, trxName);
        if (M_MovementConfirm_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MMovementConfirm(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementConfirm(MMovement move) {
        this(move.getCtx(), 0, move.get_TrxName());
        this.setClientOrg((PO)move);
        this.setM_Movement_ID(move.getM_Movement_ID());
    }

    public MMovementLineConfirm[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        String sql = "SELECT * FROM M_MovementLineConfirm WHERE M_MovementConfirm_ID=?";
        ArrayList<MMovementLineConfirm> list = new ArrayList<MMovementLineConfirm>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_MovementConfirm_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMovementLineConfirm(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MMovementLineConfirm[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setIsApproved(boolean IsApproved) {
        if (IsApproved && !this.isApproved()) {
            int AD_User_ID = this.getCtx().getAD_User_ID();
            MUser user = MUser.get((Ctx)this.getCtx(), (int)AD_User_ID);
            String info = user.getName() + ": " + Msg.translate((Ctx)this.getCtx(), (String)"IsApproved") + " - " + new Timestamp(System.currentTimeMillis());
            this.addDescription(info);
        }
        super.setIsApproved(IsApproved);
    }

    public String getDocumentInfo() {
        return Msg.getElement((Ctx)this.getCtx(), (String)"M_MovementConfirm_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getUpdated(), "MMM")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MMovementLineConfirm[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        boolean difference = false;
        for (int i2 = 0; i2 < lines.length; ++i2) {
            if (lines[i2].isFullyConfirmed()) continue;
            difference = true;
            break;
        }
        if (difference) {
            this.m_processMsg = "@M_MovementLineConfirm_ID@ <> @IsFullyConfirmed@";
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        MMovement move = new MMovement(this.getCtx(), this.getM_Movement_ID(), this.get_TrxName());
        MMovementLineConfirm[] lines = this.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MMovementLineConfirm confirm = lines[i2];
            confirm.set_TrxName(this.get_TrxName());
            if (!confirm.processLine()) {
                this.m_processMsg = "ShipLine not saved - " + (Object)((Object)confirm);
                return "IN";
            }
            if (confirm.isFullyConfirmed()) {
                confirm.setProcessed(true);
                confirm.save(this.get_TrxName());
                continue;
            }
            if (this.createDifferenceDoc(move, confirm)) {
                confirm.setProcessed(true);
                confirm.save(this.get_TrxName());
                continue;
            }
            this.log.log(Level.SEVERE, "completeIt - Scrapped=" + confirm.getScrappedQty() + " - Difference=" + confirm.getDifferenceQty());
            this.m_processMsg = "Differnce Doc not created";
            return "IN";
        }
        if (this.m_inventoryInfo != null) {
            this.m_processMsg = " @M_Inventory_ID@: " + this.m_inventoryInfo;
            this.addDescription(Msg.translate((Ctx)this.getCtx(), (String)"M_Inventory_ID") + ": " + this.m_inventoryInfo);
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private boolean createDifferenceDoc(MMovement move, MMovementLineConfirm confirm) {
        MInventoryLine line;
        MWarehouse wh;
        MLocator loc;
        MMovementLine mLine = confirm.getLine();
        if (Env.ZERO.compareTo(confirm.getDifferenceQty()) != 0) {
            loc = MLocator.get((Ctx)this.getCtx(), (int)mLine.getM_Locator_ID());
            if (this.m_inventoryFrom != null && this.m_inventoryFrom.getM_Warehouse_ID() != loc.getM_Warehouse_ID()) {
                this.m_inventoryFrom = null;
            }
            if (this.m_inventoryFrom == null) {
                wh = MWarehouse.get((Ctx)this.getCtx(), (int)loc.getM_Warehouse_ID());
                this.m_inventoryFrom = new MInventory(wh);
                this.m_inventoryFrom.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"M_MovementConfirm_ID") + " " + this.getDocumentNo());
                if (!this.m_inventoryFrom.save(this.get_TrxName())) {
                    this.m_processMsg = this.m_processMsg + "Inventory not created";
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.m_inventoryFrom.getM_Inventory_ID());
                    this.m_inventoryInfo = this.m_inventoryFrom.getDocumentNo();
                } else {
                    this.m_inventoryInfo = this.m_inventoryInfo + "," + this.m_inventoryFrom.getDocumentNo();
                }
            }
            this.log.info("createDifferenceDoc - Difference=" + confirm.getDifferenceQty());
            line = new MInventoryLine(this.m_inventoryFrom, mLine.getM_Locator_ID(), mLine.getM_Product_ID(), mLine.getM_AttributeSetInstance_ID(), confirm.getDifferenceQty(), Env.ZERO);
            line.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"DifferenceQty"));
            if (!line.save(this.get_TrxName())) {
                this.m_processMsg = this.m_processMsg + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        if (Env.ZERO.compareTo(confirm.getScrappedQty()) != 0) {
            loc = MLocator.get((Ctx)this.getCtx(), (int)mLine.getM_LocatorTo_ID());
            if (this.m_inventoryTo != null && this.m_inventoryTo.getM_Warehouse_ID() != loc.getM_Warehouse_ID()) {
                this.m_inventoryTo = null;
            }
            if (this.m_inventoryTo == null) {
                wh = MWarehouse.get((Ctx)this.getCtx(), (int)loc.getM_Warehouse_ID());
                this.m_inventoryTo = new MInventory(wh);
                this.m_inventoryTo.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"M_MovementConfirm_ID") + " " + this.getDocumentNo());
                if (!this.m_inventoryTo.save(this.get_TrxName())) {
                    this.m_processMsg = this.m_processMsg + "Inventory not created";
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.m_inventoryTo.getM_Inventory_ID());
                    this.m_inventoryInfo = this.m_inventoryTo.getDocumentNo();
                } else {
                    this.m_inventoryInfo = this.m_inventoryInfo + "," + this.m_inventoryTo.getDocumentNo();
                }
            }
            this.log.info("createDifferenceDoc - Scrapped=" + confirm.getScrappedQty());
            line = new MInventoryLine(this.m_inventoryTo, mLine.getM_LocatorTo_ID(), mLine.getM_Product_ID(), mLine.getM_AttributeSetInstance_ID(), confirm.getScrappedQty(), Env.ZERO);
            line.setDescription(Msg.translate((Ctx)this.getCtx(), (String)"ScrappedQty"));
            if (!line.save(this.get_TrxName())) {
                this.m_processMsg = this.m_processMsg + "Inventory Line not created";
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        return true;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return false;
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    public int getC_Currency_ID() {
        return 0;
    }
}

