/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MCost;
import org.compiere.model.MExpenseType;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCosting;
import org.compiere.model.MProductDownload;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.X_I_Product;
import org.compiere.model.X_M_Product;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MProduct
extends X_M_Product {
    private static CCache<Integer, MProduct> s_cache = new CCache("M_Product", 40, 5);
    private static CLogger s_log = CLogger.getCLogger(MProduct.class);
    private MProductDownload[] m_downloads = null;
    private Integer m_precision = null;

    public static MProduct get(Ctx ctx, int M_Product_ID) {
        Integer key = new Integer(M_Product_ID);
        MProduct retValue = (MProduct)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProduct(ctx, M_Product_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MProduct[] get(Ctx ctx, String whereClause, String trxName) {
        String sql = "SELECT * FROM M_Product";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE AD_Client_ID=? AND " + whereClause;
        }
        ArrayList<MProduct> list = new ArrayList<MProduct>();
        int AD_Client_ID = ctx.getAD_Client_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProduct(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MProduct[] retValue = new MProduct[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MProduct getTrial(Ctx ctx, String entityType) {
        if (Util.isEmpty((String)entityType)) {
            s_log.warning("No Entity Type");
            return null;
        }
        MProduct retValue = null;
        String sql = "SELECT * FROM M_Product WHERE LicenseInfo LIKE ? AND TrialPhaseDays > 0 AND IsActive='Y'";
        String entityTypeLike = "%" + entityType + "%";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, entityTypeLike);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProduct(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null && retValue.getAD_Client_ID() != ctx.getAD_Client_ID()) {
            s_log.warning("ProductClient_ID=" + retValue.getAD_Client_ID() + " <> EnvClient_ID=" + ctx.getAD_Client_ID());
        }
        if (retValue != null && retValue.getA_Asset_Group_ID() == 0) {
            s_log.warning("Product has no Asset Group - " + (Object)((Object)retValue));
            return null;
        }
        if (retValue == null) {
            s_log.warning("No Product for EntityType - " + entityType);
        }
        return retValue;
    }

    public static boolean isProductStocked(Ctx ctx, int M_Product_ID) {
        MProduct product = MProduct.get(ctx, M_Product_ID);
        return product.isStocked();
    }

    public MProduct(Ctx ctx, int M_Product_ID, String trxName) {
        super(ctx, M_Product_ID, trxName);
        if (M_Product_ID == 0) {
            this.setProductType("I");
            this.setIsBOM(false);
            this.setIsInvoicePrintDetails(false);
            this.setIsPickListPrintDetails(false);
            this.setIsPurchased(true);
            this.setIsSold(true);
            this.setIsStocked(true);
            this.setIsSummary(false);
            this.setIsVerified(false);
            this.setIsWebStoreFeatured(false);
            this.setIsSelfService(true);
            this.setIsExcludeAutoDelivery(false);
            this.setProcessing(false);
            this.setIsDropShip(false);
            this.setSupportUnits(1);
        }
    }

    public MProduct(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct(MExpenseType et) {
        this(et.getCtx(), 0, et.get_TrxName());
        this.setProductType("E");
        this.setExpenseType(et);
    }

    public MProduct(MResource resource, MResourceType resourceType) {
        this(resource.getCtx(), 0, resource.get_TrxName());
        this.setProductType("R");
        this.setResource(resource);
        this.setResource(resourceType);
    }

    public MProduct(X_I_Product impP) {
        this(impP.getCtx(), 0, impP.get_TrxName());
        PO.copyValues((PO)impP, (PO)this, (int)impP.getAD_Client_ID(), (int)impP.getAD_Org_ID());
    }

    public boolean setExpenseType(MExpenseType parent) {
        boolean changed = false;
        if (!"E".equals(this.getProductType())) {
            this.setProductType("E");
            changed = true;
        }
        if (parent.getS_ExpenseType_ID() != this.getS_ExpenseType_ID()) {
            this.setS_ExpenseType_ID(parent.getS_ExpenseType_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResource parent) {
        boolean changed = false;
        if (!"R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getS_Resource_ID() != this.getS_Resource_ID()) {
            this.setS_Resource_ID(parent.getS_Resource_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResourceType parent) {
        boolean changed = false;
        if ("R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public int getUOMPrecision() {
        if (this.m_precision == null) {
            int C_UOM_ID = this.getC_UOM_ID();
            if (C_UOM_ID == 0) {
                return 0;
            }
            this.m_precision = new Integer(MUOM.getPrecision(this.getCtx(), C_UOM_ID));
        }
        return this.m_precision;
    }

    public int getA_Asset_Group_ID() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID();
    }

    public boolean isCreateAsset() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID() != 0;
    }

    public MAttributeSet getAttributeSet() {
        if (this.getM_AttributeSet_ID() != 0) {
            return MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        }
        return null;
    }

    public boolean isInstanceAttribute() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet mas = MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        return mas.isInstanceAttribute();
    }

    public boolean isOneAssetPerUOM() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return false;
        }
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), pc.getA_Asset_Group_ID());
        return ag.isOneAssetPerUOM();
    }

    public boolean isItem() {
        return "I".equals(this.getProductType());
    }

    public boolean isStocked() {
        return super.isStocked() && this.isItem();
    }

    public boolean isService() {
        return !this.isItem();
    }

    public String getUOMSymbol() {
        int C_UOM_ID = this.getC_UOM_ID();
        if (C_UOM_ID == 0) {
            return "";
        }
        return MUOM.get(this.getCtx(), C_UOM_ID).getUOMSymbol();
    }

    public MProductDownload[] getProductDownloads(boolean requery) {
        if (this.m_downloads != null && !requery) {
            return this.m_downloads;
        }
        ArrayList<MProductDownload> list = new ArrayList<MProductDownload>();
        String sql = "SELECT * FROM M_ProductDownload WHERE M_Product_ID=? AND IsActive='Y' ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_Product_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductDownload(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_downloads = new MProductDownload[list.size()];
        list.toArray(this.m_downloads);
        return this.m_downloads;
    }

    public boolean hasDownloads() {
        this.getProductDownloads(false);
        return this.m_downloads != null && this.m_downloads.length > 0;
    }

    public int getSupportUnits() {
        int ii = super.getSupportUnits();
        if (ii < 1) {
            ii = 1;
        }
        return ii;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProduct[");
        sb.append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && (this.is_ValueChanged("IsActive") && !this.isActive() || this.is_ValueChanged("IsStocked") && !this.isStocked() || this.is_ValueChanged("ProductType") && "I".equals(this.get_ValueOld("ProductType")))) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            BigDecimal Reserved = Env.ZERO;
            for (int i2 = 0; i2 < storages.length; ++i2) {
                OnHand = OnHand.add(storages[i2].getQtyOnHand());
                Ordered = Ordered.add(storages[i2].getQtyOrdered());
                Reserved = Reserved.add(storages[i2].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (Reserved.signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)errMsg));
                return false;
            }
        }
        if (this.isStocked() && !"I".equals(this.getProductType())) {
            this.setIsStocked(false);
        }
        if (this.m_precision != null && this.is_ValueChanged("C_UOM_ID")) {
            this.m_precision = null;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription((Ctx)this.getCtx(), (String)("M_Product_ID=" + this.getM_Product_ID()), (String)this.get_TrxName());
        }
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description"))) {
            String sql = "UPDATE A_Asset a SET (Name, Description)=(SELECT SUBSTR(bp.Name || ' - ' || p.Name,1,60), p.Description FROM M_Product p, C_BPartner bp WHERE p.M_Product_ID=a.M_Product_ID AND bp.C_BPartner_ID=a.C_BPartner_ID) WHERE IsActive='Y'  AND M_Product_ID=" + this.getM_Product_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Asset Description updated #" + no);
        }
        if (newRecord) {
            this.insert_Accounting("M_Product_Acct", "M_Product_Category_Acct", "p.M_Product_Category_ID=" + this.getM_Product_Category_ID());
            MAcctSchema[] mass = MAcctSchema.getClientAcctSchema((Ctx)this.getCtx(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
            for (int i2 = 0; i2 < mass.length; ++i2) {
                MProductCosting pcOld = new MProductCosting(this, mass[i2].getC_AcctSchema_ID());
                pcOld.save();
            }
        }
        if (newRecord || this.is_ValueChanged("M_Product_Category_ID")) {
            MCost.create(this);
        }
        return success;
    }

    protected boolean beforeDelete() {
        if (this.isStocked() || "I".equals(this.getProductType())) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            BigDecimal Reserved = Env.ZERO;
            for (int i2 = 0; i2 < storages.length; ++i2) {
                OnHand = OnHand.add(storages[i2].getQtyOnHand());
                Ordered = OnHand.add(storages[i2].getQtyOrdered());
                Reserved = OnHand.add(storages[i2].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (Reserved.signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)errMsg));
                return false;
            }
        }
        MProductCosting[] costings = MProductCosting.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
        for (int i3 = 0; i3 < costings.length; ++i3) {
            costings[i3].delete(true, this.get_TrxName());
        }
        return this.delete_Accounting("M_Product_Acct");
    }
}

