/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.compiere.model.MRegistrationAttribute;
import org.compiere.model.MRegistrationValue;
import org.compiere.model.X_A_Registration;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.WebUtil;

public class MRegistration
extends X_A_Registration {
    private MRegistrationAttribute[] m_allAttributes = null;

    public MRegistration(Ctx ctx, int A_Registration_ID, String trxName) {
        super(ctx, A_Registration_ID, trxName);
        if (A_Registration_ID == 0) {
            this.setIsRegistered(true);
        }
    }

    public MRegistration(Ctx ctx, String Name, boolean IsAllowPublish, boolean IsInProduction, Timestamp AssetServiceDate, String trxName) {
        this(ctx, 0, trxName);
        this.setName(Name);
        this.setIsAllowPublish(IsAllowPublish);
        this.setIsInProduction(IsInProduction);
        this.setAssetServiceDate(AssetServiceDate);
    }

    public MRegistration(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRegistrationAttribute[] getAttributes() {
        if (this.m_allAttributes == null) {
            this.m_allAttributes = MRegistrationAttribute.getAll(this.getCtx());
        }
        return this.m_allAttributes;
    }

    public MRegistrationValue[] getValues() {
        return this.getValues(true);
    }

    public MRegistrationValue[] getValues(boolean onlySelfService) {
        this.createMissingValues();
        String sql = "SELECT * FROM A_RegistrationValue rv WHERE A_Registration_ID=?";
        if (onlySelfService) {
            sql = sql + " AND EXISTS (SELECT * FROM A_RegistrationAttribute ra WHERE rv.A_RegistrationAttribute_ID=ra.A_RegistrationAttribute_ID AND ra.IsActive='Y' AND ra.IsSelfService='Y')";
        }
        ArrayList<MRegistrationValue> list = new ArrayList<MRegistrationValue>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getA_Registration_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRegistrationValue(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        Object[] retValue = new MRegistrationValue[list.size()];
        list.toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }

    private void createMissingValues() {
        String sql = "SELECT ra.A_RegistrationAttribute_ID FROM A_RegistrationAttribute ra LEFT OUTER JOIN A_RegistrationProduct rp ON (rp.A_RegistrationAttribute_ID=ra.A_RegistrationAttribute_ID) LEFT OUTER JOIN A_Registration r ON (r.M_Product_ID=rp.M_Product_ID) WHERE r.A_Registration_ID=? AND NOT EXISTS (SELECT A_RegistrationAttribute_ID FROM A_RegistrationValue v WHERE ra.A_RegistrationAttribute_ID=v.A_RegistrationAttribute_ID AND r.A_Registration_ID=v.A_Registration_ID)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getA_Registration_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRegistrationValue v = new MRegistrationValue(this, rs.getInt(1), "?");
                v.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, null, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    public int loadAttributeValues(HttpServletRequest request) {
        if (this.get_ID() == 0) {
            this.save();
        }
        int count = 0;
        MRegistrationAttribute[] attributes = this.getAttributes();
        for (int i2 = 0; i2 < attributes.length; ++i2) {
            MRegistrationValue regValue;
            MRegistrationAttribute attribute = attributes[i2];
            String value = WebUtil.getParameter(request, attribute.getName());
            if (value == null || !(regValue = new MRegistrationValue(this, attribute.getA_RegistrationAttribute_ID(), value)).save()) continue;
            ++count;
        }
        this.log.fine("loadAttributeValues - #" + count + " (of " + attributes.length + ")");
        return count;
    }

    public int updateAttributeValues(HttpServletRequest request) {
        if (this.get_ID() == 0) {
            this.save();
        }
        int count = 0;
        MRegistrationValue[] regValues = this.getValues(false);
        for (int i2 = 0; i2 < regValues.length; ++i2) {
            MRegistrationValue regValue = regValues[i2];
            String attributeName = regValue.getRegistrationAttribute();
            String dataValue = WebUtil.getParameter(request, attributeName);
            if (dataValue == null) continue;
            regValue.setDescription("Previous=" + regValue.getName());
            regValue.setName(dataValue);
            if (!regValue.save()) continue;
            ++count;
        }
        this.log.fine("updateAttributeValues - #" + count + " (of " + regValues.length + ")");
        return count;
    }
}

