/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_TableIndex;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MTableIndex
extends X_AD_TableIndex {
    private static CLogger s_log = CLogger.getCLogger(MTableIndex.class);
    private MIndexColumn[] m_columns = null;
    private String m_ddl = null;

    public static MTableIndex[] get(MTable table2) {
        ArrayList<MTableIndex> list = new ArrayList<MTableIndex>();
        String sql = "SELECT * FROM AD_TableIndex WHERE AD_Table_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)table2.get_TrxName());
            pstmt.setInt(1, table2.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTableIndex(table2.getCtx(), rs, table2.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MTableIndex[] retValue = new MTableIndex[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MTableIndex(Ctx ctx, int AD_TableIndex_ID, String trxName) {
        super(ctx, AD_TableIndex_ID, trxName);
        if (AD_TableIndex_ID == 0) {
            this.setEntityType("U");
            this.setIsUnique(false);
            this.setIsCreateConstraint(false);
        }
    }

    public MTableIndex(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_ddl = this.createDDL();
    }

    public MTableIndex(MTable parent, String Name) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
        this.setName(Name);
    }

    public MIndexColumn[] getColumns(boolean reload) {
        if (this.m_columns != null && !reload) {
            return this.m_columns;
        }
        ArrayList<MIndexColumn> list = new ArrayList<MIndexColumn>();
        String sql = "SELECT * FROM AD_IndexColumn WHERE AD_TableIndex_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_TableIndex_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MIndexColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columns = new MIndexColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public String getTableName() {
        int AD_Table_ID = this.getAD_Table_ID();
        return MTable.getTableName((Ctx)this.getCtx(), (int)AD_Table_ID);
    }

    private String createDDL() {
        StringBuffer sql = null;
        if (!this.isCreateConstraint()) {
            sql = new StringBuffer("CREATE ");
            if (this.isUnique()) {
                sql.append("UNIQUE ");
            }
            sql.append("INDEX ").append(this.getName()).append(" ON ").append(this.getTableName()).append(" (");
            this.getColumns(false);
            for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
                MIndexColumn ic = this.m_columns[i2];
                if (i2 > 0) {
                    sql.append(",");
                }
                sql.append(ic.getColumnName());
            }
            sql.append(")");
        } else if (this.isUnique()) {
            sql = new StringBuffer("ALTER TABLE " + this.getTableName() + " ADD CONSTRAINT " + this.getName() + " UNIQUE (");
            this.getColumns(false);
            for (int i3 = 0; i3 < this.m_columns.length; ++i3) {
                MIndexColumn ic = this.m_columns[i3];
                if (i3 > 0) {
                    sql.append(",");
                }
                sql.append(ic.getColumnName());
            }
            sql.append(")");
        } else {
            this.log.severe("Neither index nor unique constraint with " + this.getTableName());
            return "";
        }
        return sql.toString();
    }

    public String getDDL() {
        if (this.m_ddl == null) {
            this.m_ddl = this.createDDL();
        }
        return this.m_ddl;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MTableIndex[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append("]");
        return sb.toString();
    }
}

