/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MUser;
import org.compiere.model.X_S_TimeExpense;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MTimeExpense
extends X_S_TimeExpense
implements DocAction {
    private int m_M_Locator_ID = 0;
    private MTimeExpenseLine[] m_lines = null;
    private int m_AD_User_ID = 0;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MTimeExpense(Ctx ctx, int S_TimeExpense_ID, String trxName) {
        super(ctx, S_TimeExpense_ID, trxName);
        if (S_TimeExpense_ID == 0) {
            this.setDateReport(new Timestamp(System.currentTimeMillis()));
            this.setIsApproved(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MTimeExpense(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTimeExpenseLine[] getLines() {
        return this.getLines(true);
    }

    public MTimeExpenseLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        int C_Currency_ID = this.getC_Currency_ID();
        ArrayList<MTimeExpenseLine> list = new ArrayList<MTimeExpenseLine>();
        String sql = "SELECT * FROM S_TimeExpenseLine WHERE S_TimeExpense_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getS_TimeExpense_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTimeExpenseLine te = new MTimeExpenseLine(this.getCtx(), rs, this.get_TrxName());
                te.setC_Currency_Report_ID(C_Currency_ID);
                list.add(te);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        this.m_lines = new MTimeExpenseLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public int getM_Locator_ID() {
        if (this.m_M_Locator_ID != 0) {
            return this.m_M_Locator_ID;
        }
        String sql = "SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID=? AND IsActive='Y' ORDER BY IsDefault DESC, Created";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getM_Warehouse_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_M_Locator_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, "getM_Locator_ID", (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        return this.m_M_Locator_ID;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE S_TimeExpenseLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE S_TimeExpense_ID=" + this.getS_TimeExpense_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - Lines=" + noLine);
    }

    public String getDocumentInfo() {
        return Msg.getElement((Ctx)this.getCtx(), (String)"S_TimeExpense_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MTimeExpenseLine line;
        int i2;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateReport(), "API")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MTimeExpenseLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal amt = Env.ZERO;
        for (i2 = 0; i2 < lines.length; ++i2) {
            line = lines[i2];
            amt = amt.add(line.getApprovalAmt());
        }
        this.setApprovalAmt(amt);
        for (i2 = 0; i2 < lines.length; ++i2) {
            line = lines[i2];
            if (!line.isInvoiced() || line.getC_BPartner_ID() != 0) continue;
            this.m_processMsg = "@Line@ " + line.getLine() + ": Invoiced, but no Business Partner";
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        MUser[] users;
        if (this.m_AD_User_ID != 0) {
            return this.m_AD_User_ID;
        }
        if (this.getC_BPartner_ID() != 0 && (users = MUser.getOfBPartner((Ctx)this.getCtx(), (int)this.getC_BPartner_ID())).length > 0) {
            this.m_AD_User_ID = users[0].getAD_User_ID();
            return this.m_AD_User_ID;
        }
        return this.getCreatedBy();
    }

    public int getC_Currency_ID() {
        MPriceList pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), this.get_TrxName());
        return pl.getC_Currency_ID();
    }
}

