/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import bsh.EvalError;
import bsh.Interpreter;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scriptlet {
    public static final String VARIABLE = "result";
    private static CLogger log = CLogger.getCLogger(Scriptlet.class);
    private String m_variable;
    private String m_script;
    private HashMap<String, Object> m_ctx;
    private Object m_result;

    static Object run(String variable, String script2, Ctx ctx, int WindowNo) {
        Scriptlet scr = new Scriptlet(variable, script2, ctx, WindowNo);
        scr.execute();
        return scr.getResult(false);
    }

    public Scriptlet() {
        this(VARIABLE, "", Env.getCtx(), 0);
    }

    public Scriptlet(String variable, String script2, Ctx ctx, int WindowNo) {
        this.setVariable(variable);
        this.setScript(script2);
        this.setEnvironment(ctx, WindowNo);
    }

    public Scriptlet(String variable, String script2, HashMap<String, Object> ctx) {
        this.setVariable(variable);
        this.setScript(script2);
        this.setEnvironment(ctx);
    }

    public Exception execute() {
        this.m_result = null;
        if (this.m_variable == null || this.m_variable.length() == 0 || this.m_script == null || this.m_script.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("No variable/script");
            log.config(e.toString());
            return e;
        }
        Interpreter i2 = new Interpreter();
        this.loadEnvironment(i2);
        try {
            log.config(this.m_script);
            i2.eval(this.m_script);
        }
        catch (Exception e) {
            log.config(e.toString());
            return e;
        }
        try {
            this.m_result = i2.get(this.m_variable);
            log.config("Result (" + this.m_result.getClass().getName() + ") " + this.m_result);
        }
        catch (Exception e2) {
            IllegalArgumentException e2;
            log.config("Result - " + e2);
            if (e2 instanceof NullPointerException) {
                e2 = new IllegalArgumentException("Result Variable not found - " + this.m_variable);
            }
            return e2;
        }
        return null;
    }

    private void loadEnvironment(Interpreter i2) {
        if (this.m_ctx == null) {
            return;
        }
        for (String key : this.m_ctx.keySet()) {
            Object value = this.m_ctx.get(key);
            try {
                if (value instanceof Boolean) {
                    i2.set(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    i2.set(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    i2.set(key, ((Double)value).doubleValue());
                    continue;
                }
                i2.set(key, value);
            }
            catch (EvalError ee) {
                log.log(Level.SEVERE, "", (Throwable)ee);
            }
        }
    }

    public String getVariable() {
        return this.m_variable;
    }

    public void setVariable(String variable) {
        this.m_variable = variable == null || variable.length() == 0 ? VARIABLE : variable;
    }

    public void setScript(String script2) {
        this.m_script = script2 == null ? "" : script2;
    }

    public String getScript() {
        return this.m_script;
    }

    public void setEnvironment(Ctx prop, int WindowNo) {
        if (prop == null) {
            prop = Env.getCtx();
        }
        this.m_ctx = new HashMap();
        Iterator it = prop.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key == null || key.length() == 0 || key.startsWith("P") || key.indexOf("|") != -1 && !key.startsWith(String.valueOf(WindowNo))) continue;
            String value = prop.getContext(key);
            this.setEnvironment(key, value);
        }
    }

    public void setEnvironment(String key, String stringValue) {
        if (key == null || key.length() == 0) {
            return;
        }
        if (stringValue == null) {
            this.m_ctx.remove(key);
            return;
        }
        if (stringValue.equals("Y")) {
            this.m_ctx.put(this.convertKey(key), new Boolean(true));
            return;
        }
        if (stringValue.equals("N")) {
            this.m_ctx.put(this.convertKey(key), new Boolean(false));
            return;
        }
        Timestamp timeValue = null;
        try {
            timeValue = Timestamp.valueOf(stringValue);
            this.m_ctx.put(this.convertKey(key), timeValue);
            return;
        }
        catch (Exception e) {
            Integer intValue = null;
            try {
                intValue = Integer.valueOf(stringValue);
            }
            catch (Exception e2) {
                // empty catch block
            }
            Double doubleValue = null;
            try {
                doubleValue = Double.valueOf(stringValue);
            }
            catch (Exception e3) {
                // empty catch block
            }
            if (doubleValue != null) {
                double di;
                if (intValue != null && Double.compare(di = Double.parseDouble(intValue.toString()), doubleValue) == 0) {
                    this.m_ctx.put(this.convertKey(key), intValue);
                    return;
                }
                this.m_ctx.put(this.convertKey(key), doubleValue);
                return;
            }
            if (intValue != null) {
                this.m_ctx.put(this.convertKey(key), intValue);
                return;
            }
            this.m_ctx.put(this.convertKey(key), stringValue);
            return;
        }
    }

    public void setEnvironment(String key, Object value) {
        if (key != null && key.length() > 0) {
            if (value == null) {
                this.m_ctx.remove(key);
            } else {
                this.m_ctx.put(this.convertKey(key), value);
            }
        }
    }

    private String convertKey(String key) {
        String retValue = Util.replace((String)key, (String)"#", (String)"_");
        return retValue;
    }

    public void setEnvironment(HashMap<String, Object> ctx) {
        this.m_ctx = ctx == null ? new HashMap() : ctx;
    }

    public HashMap<String, Object> getEnvironment() {
        return this.m_ctx;
    }

    public Object getResult(boolean runIt) {
        if (runIt) {
            this.execute();
        }
        return this.m_result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_variable);
        sb.append(" { ").append(this.m_script).append(" } = ").append(this.getResult(true));
        return sb.toString();
    }
}

