/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.KeyNamePair;

public class AcctSchemaCopyAcct
extends SvrProcess {
    private int p_SourceAcctSchema_ID = 0;
    private int p_TargetAcctSchema_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_SourceAcctSchema_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_TargetAcctSchema_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("SourceAcctSchema_ID=" + this.p_SourceAcctSchema_ID + ", TargetAcctSchema_ID=" + this.p_TargetAcctSchema_ID);
        if (this.p_SourceAcctSchema_ID == 0 || this.p_TargetAcctSchema_ID == 0) {
            throw new CompiereSystemException("ID=0");
        }
        if (this.p_SourceAcctSchema_ID == this.p_TargetAcctSchema_ID) {
            throw new CompiereUserException("Account Schema must be different");
        }
        MAcctSchema source = MAcctSchema.get((Ctx)this.getCtx(), (int)this.p_SourceAcctSchema_ID, null);
        if (source.get_ID() == 0) {
            throw new CompiereSystemException("@NotFound@ Source @C_AcctSchema_ID@=" + this.p_SourceAcctSchema_ID);
        }
        MAcctSchema target = new MAcctSchema(this.getCtx(), this.p_TargetAcctSchema_ID, this.get_TrxName());
        if (target.get_ID() == 0) {
            throw new CompiereSystemException("@NotFound@ Target @C_AcctSchema_ID@=" + this.p_TargetAcctSchema_ID);
        }
        MAcctSchemaElement[] targetElements = target.getAcctSchemaElements();
        if (targetElements.length == 0) {
            throw new CompiereUserException("@NotFound@ Target C_AcctSchema_Element");
        }
        MAcctSchemaElement sourceAcctElement = source.getAcctSchemaElement("AC");
        if (sourceAcctElement == null) {
            throw new CompiereUserException("NotFound Source AC C_AcctSchema_Element");
        }
        MAcctSchemaElement targetAcctElement = target.getAcctSchemaElement("AC");
        if (targetAcctElement == null) {
            throw new CompiereUserException("NotFound Target AC C_AcctSchema_Element");
        }
        if (sourceAcctElement.getC_Element_ID() != targetAcctElement.getC_Element_ID()) {
            throw new CompiereUserException("@C_Element_ID@ different");
        }
        if (MAcctSchemaGL.get((Ctx)this.getCtx(), (int)this.p_TargetAcctSchema_ID) == null) {
            this.copyGL(target);
        }
        if (MAcctSchemaDefault.get((Ctx)this.getCtx(), (int)this.p_TargetAcctSchema_ID) == null) {
            this.copyDefault(target);
        }
        return "@OK@";
    }

    private void copyGL(MAcctSchema targetAS) throws Exception {
        MAcctSchemaGL source = MAcctSchemaGL.get((Ctx)this.getCtx(), (int)this.p_SourceAcctSchema_ID);
        MAcctSchemaGL target = new MAcctSchemaGL(this.getCtx(), 0, this.get_TrxName());
        target.setC_AcctSchema_ID(this.p_TargetAcctSchema_ID);
        ArrayList list = source.getAcctInfo();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            KeyNamePair pp = (KeyNamePair)list.get(i2);
            int sourceC_ValidCombination_ID = pp.getKey();
            String columnName = pp.getName();
            MAccount sourceAccount = MAccount.get((Ctx)this.getCtx(), (int)sourceC_ValidCombination_ID);
            MAccount targetAccount = this.createAccount(targetAS, sourceAccount);
            target.setValue(columnName, new Integer(targetAccount.getC_ValidCombination_ID()));
        }
        if (!target.save()) {
            throw new CompiereSystemException("Could not Save GL");
        }
    }

    private void copyDefault(MAcctSchema targetAS) throws Exception {
        MAcctSchemaDefault source = MAcctSchemaDefault.get((Ctx)this.getCtx(), (int)this.p_SourceAcctSchema_ID);
        MAcctSchemaDefault target = new MAcctSchemaDefault(this.getCtx(), 0, this.get_TrxName());
        target.setC_AcctSchema_ID(this.p_TargetAcctSchema_ID);
        target.setC_AcctSchema_ID(this.p_TargetAcctSchema_ID);
        ArrayList list = source.getAcctInfo();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            KeyNamePair pp = (KeyNamePair)list.get(i2);
            int sourceC_ValidCombination_ID = pp.getKey();
            String columnName = pp.getName();
            MAccount sourceAccount = MAccount.get((Ctx)this.getCtx(), (int)sourceC_ValidCombination_ID);
            MAccount targetAccount = this.createAccount(targetAS, sourceAccount);
            target.setValue(columnName, new Integer(targetAccount.getC_ValidCombination_ID()));
        }
        if (!target.save()) {
            throw new CompiereSystemException("Could not Save Default");
        }
    }

    private MAccount createAccount(MAcctSchema targetAS, MAccount sourceAcct) {
        int AD_Client_ID = targetAS.getAD_Client_ID();
        int C_AcctSchema_ID = targetAS.getC_AcctSchema_ID();
        int AD_Org_ID = 0;
        int Account_ID = 0;
        int C_SubAcct_ID = 0;
        int M_Product_ID = 0;
        int C_BPartner_ID = 0;
        int AD_OrgTrx_ID = 0;
        int C_LocFrom_ID = 0;
        int C_LocTo_ID = 0;
        int C_SalesRegion_ID = 0;
        int C_Project_ID = 0;
        int C_Campaign_ID = 0;
        int C_Activity_ID = 0;
        int User1_ID = 0;
        int User2_ID = 0;
        int UserElement1_ID = 0;
        int UserElement2_ID = 0;
        MAcctSchemaElement[] elements = targetAS.getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MAcctSchemaElement ase = elements[i2];
            String elementType = ase.getElementType();
            if (elementType.equals("OO")) {
                AD_Org_ID = sourceAcct.getAD_Org_ID();
                continue;
            }
            if (elementType.equals("AC")) {
                Account_ID = sourceAcct.getAccount_ID();
                continue;
            }
            if (elementType.equals("SA")) {
                C_SubAcct_ID = sourceAcct.getC_SubAcct_ID();
                continue;
            }
            if (elementType.equals("BP")) {
                C_BPartner_ID = sourceAcct.getC_BPartner_ID();
                continue;
            }
            if (elementType.equals("PR")) {
                M_Product_ID = sourceAcct.getM_Product_ID();
                continue;
            }
            if (elementType.equals("AY")) {
                C_Activity_ID = sourceAcct.getC_Activity_ID();
                continue;
            }
            if (elementType.equals("LF")) {
                C_LocFrom_ID = sourceAcct.getC_LocFrom_ID();
                continue;
            }
            if (elementType.equals("LT")) {
                C_LocTo_ID = sourceAcct.getC_LocTo_ID();
                continue;
            }
            if (elementType.equals("MC")) {
                C_Campaign_ID = sourceAcct.getC_Campaign_ID();
                continue;
            }
            if (elementType.equals("OT")) {
                AD_OrgTrx_ID = sourceAcct.getAD_OrgTrx_ID();
                continue;
            }
            if (elementType.equals("PJ")) {
                C_Project_ID = sourceAcct.getC_Project_ID();
                continue;
            }
            if (elementType.equals("SR")) {
                C_SalesRegion_ID = sourceAcct.getC_SalesRegion_ID();
                continue;
            }
            if (elementType.equals("U1")) {
                User1_ID = sourceAcct.getUser1_ID();
                continue;
            }
            if (elementType.equals("U2")) {
                User2_ID = sourceAcct.getUser2_ID();
                continue;
            }
            if (elementType.equals("X1")) {
                UserElement1_ID = sourceAcct.getUserElement1_ID();
                continue;
            }
            if (!elementType.equals("X2")) continue;
            UserElement2_ID = sourceAcct.getUserElement2_ID();
        }
        return MAccount.get((Ctx)this.getCtx(), (int)AD_Client_ID, (int)AD_Org_ID, (int)C_AcctSchema_ID, (int)Account_ID, (int)C_SubAcct_ID, (int)M_Product_ID, (int)C_BPartner_ID, (int)AD_OrgTrx_ID, (int)C_LocFrom_ID, (int)C_LocTo_ID, (int)C_SalesRegion_ID, (int)C_Project_ID, (int)C_Campaign_ID, (int)C_Activity_ID, (int)User1_ID, (int)User2_ID, (int)UserElement1_ID, (int)UserElement2_ID);
    }
}

