/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class AllocationAuto
extends SvrProcess {
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private boolean p_AllocateOldest = true;
    private String p_APAR = "A";
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private MPayment[] m_payments = null;
    private MInvoice[] m_invoices = null;
    private MAllocationHdr m_allocation = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AllocateOldest")) {
                this.p_AllocateOldest = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("APAR")) {
                this.p_APAR = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", Oldest=" + this.p_AllocateOldest + ", AP/AR=" + this.p_APAR);
        int countBP = 0;
        int countAlloc = 0;
        if (this.p_C_BPartner_ID != 0) {
            countAlloc = this.allocateBP(this.p_C_BPartner_ID);
            if (countAlloc > 0) {
                ++countBP;
            }
        } else if (this.p_C_BP_Group_ID != 0) {
            String sql = "SELECT C_BPartner_ID FROM C_BPartner WHERE C_BP_Group_ID=? ORDER BY Value";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.p_C_BP_Group_ID);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_BPartner_ID = rs.getInt(1);
                    int count = this.allocateBP(C_BPartner_ID);
                    if (count <= 0) continue;
                    ++countBP;
                    countAlloc += count;
                    this.commit();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        } else {
            String sql = "SELECT C_BPartner_ID FROM C_BPartner WHERE AD_Client_ID=? ORDER BY Value";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getCtx().getAD_Client_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_BPartner_ID = rs.getInt(1);
                    int count = this.allocateBP(C_BPartner_ID);
                    if (count <= 0) continue;
                    ++countBP;
                    countAlloc += count;
                    this.commit();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        return "@Created@ #" + countBP + "/" + countAlloc;
    }

    private int allocateBP(int C_BPartner_ID) throws Exception {
        int newCount;
        this.getPayments(C_BPartner_ID);
        this.getInvoices(C_BPartner_ID);
        this.log.info("(1) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
        if (this.m_payments.length + this.m_invoices.length < 2) {
            return 0;
        }
        int count = this.allocateBPPaymentWithInfo();
        if (count != 0) {
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.log.info("(2) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if ((newCount = this.allocateBPartnerAll()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            this.log.info("(3) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if ((newCount = this.allocateBPOneToOne()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            this.log.info("(4) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        if (this.p_AllocateOldest && (newCount = this.allocateBPOldestFirst()) != 0) {
            count += newCount;
            this.getPayments(C_BPartner_ID);
            this.getInvoices(C_BPartner_ID);
            this.processAllocation();
            this.log.info("(5) - C_BPartner_ID=" + C_BPartner_ID + " - #Payments=" + this.m_payments.length + ", #Invoices=" + this.m_invoices.length);
            if (this.m_payments.length + this.m_invoices.length < 2) {
                return count;
            }
        }
        return count;
    }

    private MPayment[] getPayments(int C_BPartner_ID) {
        ArrayList<MPayment> list = new ArrayList<MPayment>();
        String sql = "SELECT * FROM C_Payment WHERE IsAllocated='N' AND Processed='Y' AND C_BPartner_ID=? AND IsPrepayment='N' AND C_Charge_ID IS NULL ";
        if (ONLY_AP.equals(this.p_APAR)) {
            sql = sql + "AND IsReceipt='N' ";
        } else if (ONLY_AR.equals(this.p_APAR)) {
            sql = sql + "AND IsReceipt='Y' ";
        }
        sql = sql + "ORDER BY DateTrx";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPayment payment = new MPayment(this.getCtx(), rs, this.get_TrxName());
                BigDecimal allocated = payment.getAllocatedAmt();
                if (allocated != null && allocated.compareTo(payment.getPayAmt()) == 0) {
                    payment.setIsAllocated(true);
                    payment.save();
                    continue;
                }
                list.add(payment);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_payments = new MPayment[list.size()];
        list.toArray(this.m_payments);
        return this.m_payments;
    }

    private MInvoice[] getInvoices(int C_BPartner_ID) {
        ArrayList<MInvoice> list = new ArrayList<MInvoice>();
        String sql = "SELECT * FROM C_Invoice WHERE IsPaid='N' AND Processed='Y' AND C_BPartner_ID=? ";
        if (ONLY_AP.equals(this.p_APAR)) {
            sql = sql + "AND IsSOTrx='N' ";
        } else if (ONLY_AR.equals(this.p_APAR)) {
            sql = sql + "AND IsSOTrx='Y' ";
        }
        sql = sql + "ORDER BY DateInvoiced";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoice invoice = new MInvoice(this.getCtx(), rs, this.get_TrxName());
                if (invoice.getOpenAmt(false, null).signum() == 0) {
                    invoice.setIsPaid(true);
                    invoice.save();
                    continue;
                }
                list.add(invoice);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_invoices = new MInvoice[list.size()];
        list.toArray(this.m_invoices);
        return this.m_invoices;
    }

    private int allocateBPPaymentWithInfo() {
        int count = 0;
        block0: for (int p2 = 0; p2 < this.m_payments.length; ++p2) {
            MPayment payment = this.m_payments[p2];
            if (payment.isAllocated()) continue;
            BigDecimal allocatedAmt = payment.getAllocatedAmt();
            this.log.info((Object)((Object)payment) + ", Allocated=" + allocatedAmt);
            if (allocatedAmt != null && allocatedAmt.signum() != 0) continue;
            BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
            if (!payment.isReceipt()) {
                availableAmt = availableAmt.negate();
            }
            this.log.fine("Available=" + availableAmt);
            if (payment.getC_Invoice_ID() != 0) {
                for (int i2 = 0; i2 < this.m_invoices.length; ++i2) {
                    MInvoice invoice = this.m_invoices[i2];
                    if (invoice.isPaid() || payment.getC_Invoice_ID() != invoice.getC_Invoice_ID() || payment.getC_Currency_ID() != invoice.getC_Currency_ID()) continue;
                    BigDecimal openAmt = invoice.getOpenAmt(true, null);
                    if (!invoice.isSOTrx()) {
                        openAmt = openAmt.negate();
                    }
                    this.log.fine((Object)((Object)invoice) + ", Open=" + openAmt);
                    if (availableAmt.compareTo(openAmt) != 0) continue;
                    if (!payment.allocateIt()) continue block0;
                    this.addLog(0, payment.getDateAcct(), openAmt, payment.getDocumentNo() + " [1]");
                    ++count;
                    continue block0;
                }
                continue;
            }
            MPaySelectionCheck psCheck = MPaySelectionCheck.getOfPayment(this.getCtx(), payment.getC_Payment_ID(), this.get_TrxName());
            if (psCheck == null) continue;
            BigDecimal totalInvoice = Env.ZERO;
            MPaySelectionLine[] psLines = psCheck.getPaySelectionLines(false);
            for (int i3 = 0; i3 < psLines.length; ++i3) {
                MPaySelectionLine line = psLines[i3];
                MInvoice invoice = line.getInvoice();
                if (payment.getC_Currency_ID() != invoice.getC_Currency_ID()) continue;
                BigDecimal invoiceAmt = invoice.getOpenAmt(true, null);
                BigDecimal overUnder = line.getOpenAmt().subtract(line.getPayAmt()).subtract(line.getDiscountAmt()).subtract(line.getDifferenceAmt());
                invoiceAmt = invoiceAmt.subtract(line.getDiscountAmt()).subtract(line.getDifferenceAmt()).subtract(overUnder);
                if (!invoice.isSOTrx()) {
                    invoiceAmt = invoiceAmt.negate();
                }
                this.log.fine((Object)((Object)invoice) + ", Invoice=" + invoiceAmt);
                totalInvoice = totalInvoice.add(invoiceAmt);
            }
            if (availableAmt.compareTo(totalInvoice) != 0 || !payment.allocateIt()) continue;
            this.addLog(0, payment.getDateAcct(), availableAmt, payment.getDocumentNo() + " [n]");
            ++count;
        }
        return count;
    }

    private int allocateBPOneToOne() throws Exception {
        int count = 0;
        block0: for (int p2 = 0; p2 < this.m_payments.length; ++p2) {
            MPayment payment = this.m_payments[p2];
            if (payment.isAllocated()) continue;
            BigDecimal allocatedAmt = payment.getAllocatedAmt();
            this.log.info((Object)((Object)payment) + ", Allocated=" + allocatedAmt);
            if (allocatedAmt != null && allocatedAmt.signum() != 0) continue;
            BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
            if (!payment.isReceipt()) {
                availableAmt = availableAmt.negate();
            }
            this.log.fine("Available=" + availableAmt);
            for (int i2 = 0; i2 < this.m_invoices.length; ++i2) {
                MInvoice invoice = this.m_invoices[i2];
                if (invoice == null || invoice.isPaid() || payment.getC_Currency_ID() != invoice.getC_Currency_ID()) continue;
                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                if (!invoice.isSOTrx()) {
                    openAmt = openAmt.negate();
                }
                BigDecimal difference = availableAmt.subtract(openAmt).abs();
                this.log.fine((Object)((Object)invoice) + ", Open=" + openAmt + " - Difference=" + difference);
                if (difference.signum() != 0) continue;
                Timestamp dateAcct = payment.getDateAcct();
                if (invoice.getDateAcct().after(dateAcct)) {
                    dateAcct = invoice.getDateAcct();
                }
                if (!this.createAllocation(payment.getC_Currency_ID(), "1:1 (" + availableAmt + ")", dateAcct, availableAmt, null, null, null, invoice.getC_BPartner_ID(), payment.getC_Payment_ID(), invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) {
                    throw new CompiereSystemException("Cannot create Allocation");
                }
                this.processAllocation();
                ++count;
                this.m_invoices[i2] = null;
                this.m_payments[p2] = null;
                payment = null;
                continue block0;
            }
        }
        return count;
    }

    private int allocateBPartnerAll() throws Exception {
        int C_Currency_ID = MClient.get((Ctx)this.getCtx()).getC_Currency_ID();
        Timestamp dateAcct = null;
        BigDecimal totalPayments = Env.ZERO;
        for (int p2 = 0; p2 < this.m_payments.length; ++p2) {
            BigDecimal allocatedAmt;
            MPayment payment = this.m_payments[p2];
            if (payment.isAllocated() || (allocatedAmt = payment.getAllocatedAmt()) != null && allocatedAmt.signum() != 0) continue;
            BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
            if (!payment.isReceipt()) {
                availableAmt = availableAmt.negate();
            }
            if (payment.getC_Currency_ID() != C_Currency_ID) continue;
            if (dateAcct == null || payment.getDateAcct().after(dateAcct)) {
                dateAcct = payment.getDateAcct();
            }
            totalPayments = totalPayments.add(availableAmt);
        }
        BigDecimal totalInvoices = Env.ZERO;
        for (int i2 = 0; i2 < this.m_invoices.length; ++i2) {
            MInvoice invoice = this.m_invoices[i2];
            if (invoice.isPaid()) continue;
            BigDecimal openAmt = invoice.getOpenAmt(true, null);
            if (!invoice.isSOTrx()) {
                openAmt = openAmt.negate();
            }
            if (invoice.getC_Currency_ID() != C_Currency_ID) continue;
            if (dateAcct == null || invoice.getDateAcct().after(dateAcct)) {
                dateAcct = invoice.getDateAcct();
            }
            totalInvoices = totalInvoices.add(openAmt);
        }
        BigDecimal difference = totalInvoices.subtract(totalPayments);
        this.log.info("= Invoices=" + totalInvoices + " - Payments=" + totalPayments + " = Difference=" + difference);
        if (difference.signum() == 0) {
            for (int p3 = 0; p3 < this.m_payments.length; ++p3) {
                BigDecimal allocatedAmt;
                MPayment payment = this.m_payments[p3];
                if (payment.isAllocated() || (allocatedAmt = payment.getAllocatedAmt()) != null && allocatedAmt.signum() != 0) continue;
                BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
                if (!payment.isReceipt()) {
                    availableAmt = availableAmt.negate();
                }
                if (payment.getC_Currency_ID() != C_Currency_ID || this.createAllocation(C_Currency_ID, "BP All", dateAcct, availableAmt, null, null, null, payment.getC_BPartner_ID(), payment.getC_Payment_ID(), 0, payment.getAD_Org_ID())) continue;
                throw new CompiereSystemException("Cannot create Allocation");
            }
            for (int i3 = 0; i3 < this.m_invoices.length; ++i3) {
                MInvoice invoice = this.m_invoices[i3];
                if (invoice.isPaid()) continue;
                BigDecimal openAmt = invoice.getOpenAmt(true, null);
                if (!invoice.isSOTrx()) {
                    openAmt = openAmt.negate();
                }
                if (invoice.getC_Currency_ID() != C_Currency_ID || this.createAllocation(C_Currency_ID, "BP All", dateAcct, openAmt, null, null, null, invoice.getC_BPartner_ID(), 0, invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) continue;
                throw new CompiereSystemException("Cannot create Allocation");
            }
            this.processAllocation();
            return 1;
        }
        return 0;
    }

    private int allocateBPOldestFirst() throws Exception {
        BigDecimal diff;
        int C_Currency_ID = MClient.get((Ctx)this.getCtx()).getC_Currency_ID();
        Timestamp dateAcct = null;
        BigDecimal totalPayments = Env.ZERO;
        for (int p2 = 0; p2 < this.m_payments.length; ++p2) {
            MPayment payment = this.m_payments[p2];
            if (payment.isAllocated() || payment.getC_Currency_ID() != C_Currency_ID) continue;
            BigDecimal allocatedAmt = payment.getAllocatedAmt();
            this.log.info((Object)((Object)payment) + ", Allocated=" + allocatedAmt);
            BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
            if (!payment.isReceipt()) {
                availableAmt = availableAmt.negate();
            }
            this.log.fine("Available=" + availableAmt);
            if (dateAcct == null || payment.getDateAcct().after(dateAcct)) {
                dateAcct = payment.getDateAcct();
            }
            totalPayments = totalPayments.add(availableAmt);
        }
        BigDecimal totalInvoices = Env.ZERO;
        for (int i2 = 0; i2 < this.m_invoices.length; ++i2) {
            MInvoice invoice = this.m_invoices[i2];
            if (invoice.isPaid() || invoice.getC_Currency_ID() != C_Currency_ID) continue;
            BigDecimal openAmt = invoice.getOpenAmt(true, null);
            this.log.fine("" + (Object)((Object)invoice));
            if (!invoice.isSOTrx()) {
                openAmt = openAmt.negate();
            }
            this.log.fine("Open=" + openAmt);
            if (dateAcct == null || invoice.getDateAcct().after(dateAcct)) {
                dateAcct = invoice.getDateAcct();
            }
            totalInvoices = totalInvoices.add(openAmt);
        }
        if (totalInvoices.signum() != totalPayments.signum()) {
            this.log.fine("Signum - Invoices=" + totalInvoices.signum() + " <> Payments=" + totalPayments.signum());
            return 0;
        }
        BigDecimal difference = totalInvoices.subtract(totalPayments);
        BigDecimal maxAmt = totalInvoices.abs().min(totalPayments.abs());
        if (totalInvoices.signum() < 0) {
            maxAmt = maxAmt.negate();
        }
        this.log.info("= Invoices=" + totalInvoices + " - Payments=" + totalPayments + " = Difference=" + difference + " - Max=" + maxAmt);
        BigDecimal allocatedPayments = Env.ZERO;
        for (int p3 = 0; p3 < this.m_payments.length; ++p3) {
            BigDecimal allocatedAmt;
            MPayment payment = this.m_payments[p3];
            if (payment.isAllocated() || payment.getC_Currency_ID() != C_Currency_ID || (allocatedAmt = payment.getAllocatedAmt()) != null && allocatedAmt.signum() != 0) continue;
            BigDecimal availableAmt = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getWriteOffAmt()).add(payment.getOverUnderAmt());
            if (!payment.isReceipt()) {
                availableAmt = availableAmt.negate();
            }
            allocatedPayments = allocatedPayments.add(availableAmt);
            if (totalInvoices.signum() > 0 && allocatedPayments.compareTo(maxAmt) > 0 || totalInvoices.signum() < 0 && allocatedPayments.compareTo(maxAmt) < 0) {
                diff = allocatedPayments.subtract(maxAmt);
                availableAmt = availableAmt.subtract(diff);
                allocatedPayments = allocatedPayments.subtract(diff);
            }
            this.log.fine("Payment Allocated=" + availableAmt);
            if (!this.createAllocation(C_Currency_ID, "BP Oldest (" + difference.abs() + ")", dateAcct, availableAmt, null, null, null, payment.getC_BPartner_ID(), payment.getC_Payment_ID(), 0, payment.getAD_Org_ID())) {
                throw new CompiereSystemException("Cannot create Allocation");
            }
            if (allocatedPayments.compareTo(maxAmt) == 0) break;
        }
        BigDecimal allocatedInvoices = Env.ZERO;
        for (int i3 = 0; i3 < this.m_invoices.length; ++i3) {
            MInvoice invoice = this.m_invoices[i3];
            if (invoice.isPaid() || invoice.getC_Currency_ID() != C_Currency_ID) continue;
            BigDecimal openAmt = invoice.getOpenAmt(true, null);
            if (!invoice.isSOTrx()) {
                openAmt = openAmt.negate();
            }
            allocatedInvoices = allocatedInvoices.add(openAmt);
            if (totalInvoices.signum() > 0 && allocatedInvoices.compareTo(maxAmt) > 0 || totalInvoices.signum() < 0 && allocatedInvoices.compareTo(maxAmt) < 0) {
                diff = allocatedInvoices.subtract(maxAmt);
                openAmt = openAmt.subtract(diff);
                allocatedInvoices = allocatedInvoices.subtract(diff);
            }
            if (openAmt.signum() == 0) break;
            this.log.fine("Invoice Allocated=" + openAmt);
            if (!this.createAllocation(C_Currency_ID, "BP Oldest (" + difference.abs() + ")", dateAcct, openAmt, null, null, null, invoice.getC_BPartner_ID(), 0, invoice.getC_Invoice_ID(), invoice.getAD_Org_ID())) {
                throw new CompiereSystemException("Cannot create Allocation");
            }
            if (allocatedInvoices.compareTo(maxAmt) == 0) break;
        }
        if (allocatedPayments.compareTo(allocatedInvoices) != 0) {
            throw new CompiereSystemException("Allocated Payments=" + allocatedPayments + " <> Invoices=" + allocatedInvoices);
        }
        this.processAllocation();
        return 1;
    }

    private boolean createAllocation(int C_Currency_ID, String description, Timestamp dateAcct, BigDecimal Amount, BigDecimal DiscountAmt, BigDecimal WriteOffAmt, BigDecimal OverUnderAmt, int C_BPartner_ID, int C_Payment_ID, int C_Invoice_ID, int AD_Org_ID) {
        if (this.m_allocation != null && this.m_allocation.getC_Currency_ID() != C_Currency_ID) {
            this.processAllocation();
        }
        if (this.m_allocation == null) {
            this.m_allocation = new MAllocationHdr(this.getCtx(), false, dateAcct, C_Currency_ID, "Auto " + description, this.get_TrxName());
            this.m_allocation.setAD_Org_ID(AD_Org_ID);
            if (!this.m_allocation.save()) {
                return false;
            }
        }
        MAllocationLine aLine = new MAllocationLine(this.m_allocation, Amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
        aLine.setC_BPartner_ID(C_BPartner_ID);
        aLine.setC_Payment_ID(C_Payment_ID);
        aLine.setC_Invoice_ID(C_Invoice_ID);
        return aLine.save();
    }

    private boolean processAllocation() {
        if (this.m_allocation == null) {
            return true;
        }
        boolean success = this.m_allocation.processIt("CO");
        if (success) {
            success = this.m_allocation.save();
        } else {
            this.m_allocation.save();
        }
        this.addLog(0, this.m_allocation.getDateAcct(), null, this.m_allocation.getDescription());
        this.m_allocation = null;
        return success;
    }
}

