/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class BPartnerValidate
extends SvrProcess {
    int p_C_BPartner_ID = 0;
    int p_C_BP_Group_ID = 0;

    protected void prepare() {
        this.p_C_BPartner_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID);
        if (this.p_C_BPartner_ID == 0 && this.p_C_BP_Group_ID == 0) {
            throw new CompiereUserException("No Business Partner/Group selected");
        }
        if (this.p_C_BP_Group_ID == 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new CompiereUserException("Business Partner not found - C_BPartner_ID=" + this.p_C_BPartner_ID);
            }
            this.checkBP(bp);
        } else {
            String sql = "SELECT * FROM C_BPartner WHERE C_BP_Group_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.p_C_BP_Group_ID);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MBPartner bp = new MBPartner(this.getCtx(), rs, this.get_TrxName());
                    this.checkBP(bp);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var2_3 = null;
            }
        }
        return "OK";
    }

    private void checkBP(MBPartner bp) {
        this.addLog(0, null, null, bp.getName() + ":");
        this.checkPayments(bp);
        this.checkInvoices(bp);
        bp.setTotalOpenBalance();
        bp.setActualLifeTimeValue();
        bp.save();
        this.addLog(0, null, bp.getSO_CreditUsed(), Msg.getElement((Ctx)this.getCtx(), (String)"SO_CreditUsed"));
        this.addLog(0, null, bp.getTotalOpenBalance(), Msg.getElement((Ctx)this.getCtx(), (String)"TotalOpenBalance"));
        this.addLog(0, null, bp.getActualLifeTimeValue(), Msg.getElement((Ctx)this.getCtx(), (String)"ActualLifeTimeValue"));
        this.commit();
    }

    private void checkPayments(MBPartner bp) {
        int changed = 0;
        MPayment[] payments = MPayment.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        for (int i2 = 0; i2 < payments.length; ++i2) {
            MPayment payment = payments[i2];
            if (!payment.testAllocation()) continue;
            payment.save();
            ++changed;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(payments.length), Msg.getElement((Ctx)this.getCtx(), (String)"C_Payment_ID") + " - #" + changed);
        }
    }

    private void checkInvoices(MBPartner bp) {
        int changed = 0;
        MInvoice[] invoices = MInvoice.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        for (int i2 = 0; i2 < invoices.length; ++i2) {
            MInvoice invoice = invoices[i2];
            if (!invoice.testAllocation()) continue;
            invoice.save();
            ++changed;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(invoices.length), Msg.getElement((Ctx)this.getCtx(), (String)"C_Invoice_ID") + " - #" + changed);
        }
    }
}

