/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CompiereUserException;
import org.compiere.util.DisplayType;
import org.compiere.util.SecureEngine;

public class ColumnEncryption
extends SvrProcess {
    private boolean p_IsEncrypted = false;
    private boolean p_ChangeSetting = false;
    private int p_MaxLength = 0;
    private String p_TestValue = null;
    private int p_AD_Column_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("IsEncrypted")) {
                this.p_IsEncrypted = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("ChangeSetting")) {
                this.p_ChangeSetting = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("MaxLength")) {
                this.p_MaxLength = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("TestValue")) {
                this.p_TestValue = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int encLength;
        this.log.info("AD_Column_ID=" + this.p_AD_Column_ID + ", IsEncrypted=" + this.p_IsEncrypted + ", ChangeSetting=" + this.p_ChangeSetting + ", MaxLength=" + this.p_MaxLength);
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, null);
        if (column.get_ID() == 0 || column.get_ID() != this.p_AD_Column_ID) {
            throw new CompiereUserException("@NotFound@ @AD_Column_ID@ - " + this.p_AD_Column_ID);
        }
        String columnName = column.getColumnName();
        int dt = column.getAD_Reference_ID();
        if (column.isKey() || column.isParent() || column.isStandardColumn() || column.isVirtualColumn() || column.isIdentifier() || column.isTranslated() || DisplayType.isLookup((int)dt) || DisplayType.isLOB((int)dt) || "DocumentNo".equalsIgnoreCase(column.getColumnName()) || "Value".equalsIgnoreCase(column.getColumnName()) || "Name".equalsIgnoreCase(column.getColumnName())) {
            if (column.isEncrypted()) {
                column.setIsEncrypted(false);
                column.save();
            }
            return columnName + ": cannot be encrypted";
        }
        this.addLog(0, null, null, "Encryption Class = " + SecureEngine.getClassName());
        boolean error = false;
        if (this.p_TestValue != null && this.p_TestValue.length() > 0) {
            String encString = SecureEngine.encrypt((String)this.p_TestValue);
            this.addLog(0, null, null, "Encrypted Test Value=" + encString);
            String clearString = SecureEngine.decrypt((String)encString);
            if (this.p_TestValue.equals(clearString)) {
                this.addLog(0, null, null, "Decrypted=" + clearString + " (same as test value)");
            } else {
                this.addLog(0, null, null, "Decrypted=" + clearString + " (NOT the same as test value - check algorithm)");
                error = true;
            }
            encLength = encString.length();
            this.addLog(0, null, null, "Test Length=" + this.p_TestValue.length() + " -> " + encLength);
            if (encLength <= column.getFieldLength()) {
                this.addLog(0, null, null, "Encrypted Length (" + encLength + ") fits into field (" + column.getFieldLength() + ")");
            } else {
                this.addLog(0, null, null, "Encrypted Length (" + encLength + ") does NOT fit into field (" + column.getFieldLength() + ") - resize field");
                error = true;
            }
        }
        if (this.p_MaxLength != 0) {
            String testClear = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            while (testClear.length() < this.p_MaxLength) {
                testClear = testClear + testClear;
            }
            testClear = testClear.substring(0, this.p_MaxLength);
            this.log.config("Test=" + testClear + " (" + this.p_MaxLength + ")");
            String encString = SecureEngine.encrypt((String)testClear);
            encLength = encString.length();
            this.addLog(0, null, null, "Test Max Length=" + testClear.length() + " -> " + encLength);
            if (encLength <= column.getFieldLength()) {
                this.addLog(0, null, null, "Encrypted Max Length (" + encLength + ") fits into field (" + column.getFieldLength() + ")");
            } else {
                this.addLog(0, null, null, "Encrypted Max Length (" + encLength + ") does NOT fit into field (" + column.getFieldLength() + ") - resize field");
                error = true;
            }
        }
        if (this.p_IsEncrypted != column.isEncrypted()) {
            if (error || !this.p_ChangeSetting) {
                this.addLog(0, null, null, "Encryption NOT changed - Encryption=" + column.isEncrypted());
            } else {
                column.setIsEncrypted(this.p_IsEncrypted);
                if (column.save()) {
                    this.addLog(0, null, null, "Encryption CHANGED - Encryption=" + column.isEncrypted());
                } else {
                    this.addLog(0, null, null, "Save Error");
                }
            }
        }
        return "Encryption=" + column.isEncrypted();
    }
}

