/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.FinBalance;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class FactAcctReset
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private boolean p_DeletePosting = false;
    private int m_countReset = 0;
    private int m_countDelete = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeletePosting")) {
                this.p_DeletePosting = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Table_ID=" + this.p_AD_Table_ID + ", DeletePosting=" + this.p_DeletePosting);
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
        if (this.p_AD_Table_ID > 0) {
            sql = sql + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
        }
        sql = sql + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Table_ID = rs.getInt(1);
                String TableName = rs.getString(2);
                if (this.p_DeletePosting) {
                    this.delete(TableName, AD_Table_ID);
                    continue;
                }
                this.reset(TableName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (this.p_DeletePosting) {
            FinBalance.updateBalanceClient(this.getCtx(), this.p_AD_Client_ID, true);
        }
        return "@Updated@ = " + this.m_countReset + ", @Deleted@ = " + this.m_countDelete;
    }

    private void reset(String TableName) {
        int invalid;
        String sql = "UPDATE " + TableName + " SET Processing='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Processing<>'N' OR Processing IS NULL)";
        int unlocked = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (unlocked + (invalid = DB.executeUpdate((String)(sql = "UPDATE " + TableName + " SET Posted='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted NOT IN ('Y','N') OR Posted IS NULL) AND Processed='Y'"), (String)this.get_TrxName())) != 0) {
            this.log.fine(TableName + " - Unlocked=" + unlocked + " - Invalid=" + invalid);
        }
        this.m_countReset += unlocked + invalid;
    }

    private void delete(String TableName, int AD_Table_ID) {
        this.reset(TableName);
        this.m_countReset = 0;
        String docBaseType = null;
        if (AD_Table_ID == 318) {
            docBaseType = "IN ('API','APC','ARI','ARC','ARF')";
        } else if (AD_Table_ID == 319) {
            docBaseType = "IN ('MMS','MMR')";
        } else if (AD_Table_ID == 335) {
            docBaseType = "IN ('APP','ARR')";
        } else if (AD_Table_ID == 259) {
            docBaseType = "IN ('SOO','POO')";
        } else if (AD_Table_ID == 623) {
            docBaseType = "= 'PJI'";
        } else if (AD_Table_ID == 392) {
            docBaseType = "= 'CMB'";
        } else if (AD_Table_ID == 407) {
            docBaseType = "= 'CMC'";
        } else if (AD_Table_ID == 735) {
            docBaseType = "= 'CMA'";
        } else if (AD_Table_ID == 224) {
            docBaseType = "= 'GLJ'";
        } else if (AD_Table_ID == 323) {
            docBaseType = "= 'MMM'";
        } else if (AD_Table_ID == 702) {
            docBaseType = "= 'POR'";
        } else if (AD_Table_ID == 321) {
            docBaseType = "= 'MMI'";
        } else if (AD_Table_ID == 325) {
            docBaseType = "= 'MMP'";
        } else if (AD_Table_ID == 472) {
            docBaseType = "= 'MXI'";
        } else if (AD_Table_ID == 473) {
            docBaseType = "= 'MXP'";
        }
        if (docBaseType == null) {
            String s = TableName + ": Unknown DocBaseType";
            this.log.severe(s);
            this.addLog(s);
            docBaseType = "";
            return;
        }
        docBaseType = " AND pc.DocBaseType " + docBaseType;
        String sql1 = "UPDATE " + TableName + " doc" + " SET Posted='N', Processing='N' " + "WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted<>'N' OR Posted IS NULL OR Processing<>'N' OR Processing IS NULL)" + " AND EXISTS (SELECT * FROM C_PeriodControl pc" + " INNER JOIN Fact_Acct fact ON (fact.C_Period_ID=pc.C_Period_ID) " + "WHERE pc.PeriodStatus = 'O'" + docBaseType + " AND fact.AD_Table_ID=" + AD_Table_ID + " AND fact.Record_ID=doc." + TableName + "_ID)";
        int reset = DB.executeUpdate((String)sql1, (String)this.get_TrxName());
        String sql2 = "DELETE FROM Fact_Acct fact WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND AD_Table_ID=" + AD_Table_ID + " AND EXISTS (SELECT * FROM C_PeriodControl pc " + "WHERE pc.PeriodStatus = 'O'" + docBaseType + " AND fact.C_Period_ID=pc.C_Period_ID)";
        int deleted = DB.executeUpdate((String)sql2, (String)this.get_TrxName());
        this.log.info(TableName + "(" + AD_Table_ID + ") - Reset=" + reset + " - Deleted=" + deleted);
        String s = TableName + " - Reset=" + reset + " - Deleted=" + deleted;
        this.addLog(s);
        if (reset == 0) {
            this.log.finest(sql1);
        }
        if (deleted == 0) {
            this.log.finest(sql2);
        }
        this.m_countReset += reset;
        this.m_countDelete += deleted;
    }
}

