/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MContactInterest;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_BPartner;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportBPartner
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private Timestamp p_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_DateValue == null) {
            this.p_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_deleteOldImported) {
            sql = new StringBuffer("DELETE FROM I_BPartner WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_BPartner SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Reset=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y' AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group=" + no);
        String ts = DB.isPostgreSQL() ? "COALESCE(I_ErrorMsg,'')" : "I_ErrorMsg";
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Group, ' " + "WHERE C_BP_Group_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE i.CountryCode=c.CountryCode AND c.IsSummary='N' AND c.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Country, ' " + "WHERE C_Country_ID IS NULL AND (City IS NOT NULL OR Address1 IS NOT NULL)" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set RegionName=(SELECT Name FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) ");
        sql.append("WHERE RegionName IS NULL AND C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=i.RegionName AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Region, ' " + "WHERE C_Region_ID IS NULL " + " AND EXISTS (SELECT * FROM C_Country c" + " WHERE c.C_Country_ID=i.C_Country_ID AND c.HasRegion='Y')" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Region=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting g WHERE i.BPContactGreeting=g.Name AND g.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Greeting, ' " + "WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Greeting=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE i.EMail=u.EMail AND u.AD_Client_ID=i.AD_Client_ID) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET AD_User_ID=(SELECT AD_User_ID FROM AD_User c WHERE i.ContactName=c.Name AND i.C_BPartner_ID=c.C_BPartner_ID AND c.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NOT NULL AND AD_User_ID IS NULL AND ContactName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Contact=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE i.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=i.AD_Client_ID AND DUMP(i.Address1)=DUMP(l.Address1) AND DUMP(i.Address2)=DUMP(l.Address2) AND DUMP(i.City)=DUMP(l.City) AND DUMP(i.Postal)=DUMP(l.Postal) AND DUMP(i.Postal_Add)=DUMP(l.Postal_Add) AND DUMP(i.C_Region_ID)=DUMP(l.C_Region_ID) AND DUMP(i.C_Country_ID)=DUMP(l.C_Country_ID)) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Location=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE i.InterestAreaName=ia.Name AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        this.commit();
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartner WHERE I_IsImported='N'").append(clientCheck);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MUser user;
                X_I_BPartner impBP;
                block51: {
                    String name;
                    MBPartnerLocation bpl;
                    MBPartner bp;
                    block53: {
                        block55: {
                            block56: {
                                block54: {
                                    MLocation location;
                                    block52: {
                                        block50: {
                                            impBP = new X_I_BPartner(this.getCtx(), rs, this.get_TrxName());
                                            this.log.fine("I_BPartner_ID=" + impBP.getI_BPartner_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                                            bp = null;
                                            if (impBP.getC_BPartner_ID() == 0) {
                                                bp = new MBPartner(impBP);
                                                if (bp.save()) {
                                                    impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                                    this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                                    ++noInsert;
                                                    break block50;
                                                } else {
                                                    sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("Cannot Insert BPartner").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                                    DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                                    continue;
                                                }
                                            }
                                            bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                            if (impBP.getName() != null) {
                                                bp.setName(impBP.getName());
                                                bp.setName2(impBP.getName2());
                                            }
                                            if (impBP.getDUNS() != null) {
                                                bp.setDUNS(impBP.getDUNS());
                                            }
                                            if (impBP.getTaxID() != null) {
                                                bp.setTaxID(impBP.getTaxID());
                                            }
                                            if (impBP.getNAICS() != null) {
                                                bp.setNAICS(impBP.getNAICS());
                                            }
                                            if (impBP.getC_BP_Group_ID() != 0) {
                                                bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                            }
                                            if (impBP.getDescription() != null) {
                                                bp.setDescription(impBP.getDescription());
                                            }
                                            bp.setisBPCompany(impBP.isBPCompany());
                                            bp.setisUnsubscribed(impBP.isUnsubscribed());
                                            if (bp.save()) {
                                                this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                                ++noUpdate;
                                            } else {
                                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("' Cannot Update BPartner' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                                DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                                continue;
                                            }
                                        }
                                        bpl = null;
                                        if (impBP.getC_BPartner_Location_ID() == 0) break block52;
                                        bpl = new MBPartnerLocation(this.getCtx(), impBP.getC_BPartner_Location_ID(), this.get_TrxName());
                                        location = new MLocation(this.getCtx(), bpl.getC_Location_ID(), this.get_TrxName());
                                        location.setC_Country_ID(impBP.getC_Country_ID());
                                        location.setC_Region_ID(impBP.getC_Region_ID());
                                        location.setCity(impBP.getCity());
                                        location.setAddress1(impBP.getAddress1());
                                        location.setAddress2(impBP.getAddress2());
                                        location.setPostal(impBP.getPostal());
                                        location.setPostal_Add(impBP.getPostal_Add());
                                        location.setRegionName(impBP.getRegionName());
                                        if (!location.save()) {
                                            this.log.warning("Location not updated");
                                        } else {
                                            bpl.setC_Location_ID(location.getC_Location_ID());
                                        }
                                        if (impBP.getPhone() != null) {
                                            bpl.setPhone(impBP.getPhone());
                                        }
                                        if (impBP.getPhone2() != null) {
                                            bpl.setPhone2(impBP.getPhone2());
                                        }
                                        if (impBP.getFax() != null) {
                                            bpl.setFax(impBP.getFax());
                                        }
                                        if (impBP.getC_LocationType() != null) {
                                            bpl.setC_LocationType(impBP.getC_LocationType());
                                        }
                                        if (impBP.getAddressKana() != null) {
                                            bpl.setAddressKana(impBP.getAddressKana());
                                        }
                                        bpl.save();
                                        break block53;
                                    }
                                    if (impBP.getC_Country_ID() == 0 || impBP.getAddress1() == null || impBP.getCity() == null) break block53;
                                    location = new MLocation(this.getCtx(), impBP.getC_Country_ID(), impBP.getC_Region_ID(), impBP.getCity(), this.get_TrxName());
                                    location.setAddress1(impBP.getAddress1());
                                    location.setAddress2(impBP.getAddress2());
                                    location.setPostal(impBP.getPostal());
                                    location.setPostal_Add(impBP.getPostal_Add());
                                    location.setRegionName(impBP.getRegionName());
                                    if (!location.save()) break block54;
                                    this.log.finest("Insert Location - " + location.getC_Location_ID());
                                    bpl = new MBPartnerLocation(bp);
                                    bpl.setC_Location_ID(location.getC_Location_ID());
                                    bpl.setPhone(impBP.getPhone());
                                    bpl.setPhone2(impBP.getPhone2());
                                    bpl.setFax(impBP.getFax());
                                    bpl.setC_LocationType(impBP.getC_LocationType());
                                    bpl.setAddressKana(impBP.getAddressKana());
                                    if (!bpl.save()) break block55;
                                    break block56;
                                }
                                this.rollback();
                                --noInsert;
                                sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("Cannot Insert Location").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                continue;
                            }
                            this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                            impBP.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                            break block53;
                        }
                        this.rollback();
                        --noInsert;
                        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("Cannot Insert BPLocation").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                        DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                        continue;
                    }
                    user = null;
                    if (impBP.getAD_User_ID() != 0) {
                        user = new MUser(this.getCtx(), impBP.getAD_User_ID(), this.get_TrxName());
                        if (user.getC_BPartner_ID() == 0) {
                            user.setC_BPartner_ID(bp.getC_BPartner_ID());
                        } else if (user.getC_BPartner_ID() != bp.getC_BPartner_ID()) {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("BP of User <> BP").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                        if (impBP.getC_Greeting_ID() != 0) {
                            user.setC_Greeting_ID(impBP.getC_Greeting_ID());
                        }
                        if ((name = impBP.getContactName()) == null || name.length() == 0) {
                            name = impBP.getEMail();
                        }
                        user.setName(name);
                        if (impBP.getTitle() != null) {
                            user.setTitle(impBP.getTitle());
                        }
                        if (impBP.getContactDescription() != null) {
                            user.setDescription(impBP.getContactDescription());
                        }
                        if (impBP.getComments() != null) {
                            user.setComments(impBP.getComments());
                        }
                        if (impBP.getPhone() != null) {
                            user.setPhone(impBP.getPhone());
                        }
                        if (impBP.getPhone2() != null) {
                            user.setPhone2(impBP.getPhone2());
                        }
                        if (impBP.getFax() != null) {
                            user.setFax(impBP.getFax());
                        }
                        if (impBP.getEMail() != null) {
                            user.setEMail(impBP.getEMail());
                        }
                        if (impBP.getBirthday() != null) {
                            user.setBirthday(impBP.getBirthday());
                        }
                        if (impBP.getLastName() != null) {
                            user.setLastName(impBP.getLastName());
                        }
                        if (impBP.getFirstName() != null) {
                            user.setFirstName(impBP.getFirstName());
                        }
                        if (impBP.getLastNameKana() != null) {
                            user.setLastNameKana(impBP.getLastNameKana());
                        }
                        if (impBP.getFirstNameKana() != null) {
                            user.setFirstNameKana(impBP.getFirstNameKana());
                        }
                        if (bpl != null) {
                            user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                        }
                        if (user.save()) {
                            this.log.finest("Update BP Contact - " + user.getAD_User_ID());
                            break block51;
                        } else {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("Cannot Update BP Contact").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    if (impBP.getContactName() != null || impBP.getEMail() != null) {
                        user = new MUser((X_C_BPartner)bp);
                        if (impBP.getC_Greeting_ID() != 0) {
                            user.setC_Greeting_ID(impBP.getC_Greeting_ID());
                        }
                        if ((name = impBP.getContactName()) == null || name.length() == 0) {
                            name = impBP.getEMail();
                        }
                        user.setName(name);
                        user.setTitle(impBP.getTitle());
                        user.setDescription(impBP.getContactDescription());
                        user.setComments(impBP.getComments());
                        user.setPhone(impBP.getPhone());
                        user.setPhone2(impBP.getPhone2());
                        user.setFax(impBP.getFax());
                        user.setEMail(impBP.getEMail());
                        user.setBirthday(impBP.getBirthday());
                        user.setLastName(impBP.getLastName());
                        user.setFirstName(impBP.getFirstName());
                        user.setLastNameKana(impBP.getLastNameKana());
                        user.setFirstNameKana(impBP.getFirstNameKana());
                        if (bpl != null) {
                            user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                        }
                        if (user.save()) {
                            this.log.finest("Insert BP Contact - " + user.getAD_User_ID());
                            impBP.setAD_User_ID(user.getAD_User_ID());
                        } else {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=" + ts + "||").append("Cannot Insert BPContact").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                }
                if (impBP.getR_InterestArea_ID() != 0 && user != null) {
                    MContactInterest ci = MContactInterest.get(this.getCtx(), impBP.getR_InterestArea_ID(), user.getAD_User_ID(), true, this.get_TrxName());
                    ci.save();
                }
                impBP.setI_IsImported("Y");
                impBP.setProcessed(true);
                impBP.setProcessing(false);
                impBP.save();
                this.commit();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.rollback();
        }
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        return "";
    }
}

