/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MContactInterest;
import org.compiere.model.MLead;
import org.compiere.model.MUser;
import org.compiere.model.X_I_Contact;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class ImportContact
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_deleteOldImported) {
            sql = new StringBuffer("DELETE FROM I_Contact WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Contact SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Contact i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE i.InterestAreaName=ia.Name AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        int noProcessed = 0;
        String sql0 = "SELECT * FROM I_Contact WHERE I_IsImported<>'Y' AND AD_Client_ID=1 ORDER BY I_Contact_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql0, (String)this.get_TrxName());
            pstmt.setInt(1, this.p_AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (!this.process(new X_I_Contact(this.getCtx(), rs, this.get_TrxName()))) continue;
                ++noProcessed;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql0, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Processed@ #" + noProcessed;
    }

    private boolean process(X_I_Contact imp) {
        if (imp.getEMail() == null || imp.getEMail().length() == 0) {
            return this.processFail(imp, "No EMail");
        }
        MUser user = MUser.get((Ctx)this.getCtx(), (String)imp.getEMail(), (String)this.get_TrxName());
        if (user == null || user.getAD_User_ID() == 0) {
            if (imp.isEMailBounced()) {
                return this.processFail(imp, "No User found with email - cannou set Bounced flag");
            }
            if (imp.getContactName() == null || imp.getContactName().length() == 0) {
                return this.processFail(imp, "No Name for User/Contact");
            }
            user = new MUser(this.getCtx(), 0, this.get_TrxName());
            user.setName(imp.getContactName());
            user.setDescription(imp.getContactDescription());
            user.setEMail(imp.getEMail());
        } else if (imp.isEMailBounced()) {
            user.setIsEMailBounced(true);
            user.setBouncedInfo(imp.getBouncedInfo());
        }
        if (!user.save()) {
            return this.processFail(imp, "Cannot save User");
        }
        if (imp.isCreateBP()) {
            if (user.getC_BPartner_ID() == 0) {
                MBPartner bp = new MBPartner(this.getCtx(), 0, this.get_TrxName());
                bp.setName(user.getName());
                if (!bp.save()) {
                    return this.processFail(imp, "Cannot create BPartner");
                }
                user.setC_BPartner_ID(bp.getC_BPartner_ID());
                if (!user.save()) {
                    return this.processFail(imp, "Cannot update User");
                }
            }
            imp.setC_BPartner_ID(user.getC_BPartner_ID());
        }
        if (imp.isCreateLead()) {
            MLead lead = new MLead(this.getCtx(), 0, this.get_TrxName());
            lead.setName(imp.getContactName());
            lead.setDescription(imp.getContactDescription());
            lead.setAD_User_ID(user.getAD_User_ID());
            lead.setC_BPartner_ID(user.getC_BPartner_ID());
            lead.save();
            imp.setC_Lead_ID(lead.getC_Lead_ID());
        }
        if (imp.getR_InterestArea_ID() != 0 && user != null) {
            MContactInterest ci = MContactInterest.get(this.getCtx(), imp.getR_InterestArea_ID(), user.getAD_User_ID(), true, this.get_TrxName());
            ci.save();
        }
        imp.setAD_User_ID(user.getAD_User_ID());
        imp.setI_IsImported(true);
        imp.setI_ErrorMsg(null);
        imp.save();
        return true;
    }

    private boolean processFail(X_I_Contact imp, String errorMsg) {
        imp.setI_IsImported(false);
        imp.setI_ErrorMsg(errorMsg);
        imp.save();
        return false;
    }
}

