/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class ImportDelete
extends SvrProcess {
    private int p_AD_Table_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("AD_Table_ID=" + this.p_AD_Table_ID);
        MTable table2 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
        if (table2.get_ID() == 0) {
            throw new IllegalArgumentException("No AD_Table_ID=" + this.p_AD_Table_ID);
        }
        String tableName = table2.getTableName();
        if (!tableName.startsWith("I")) {
            throw new IllegalArgumentException("Not an import table = " + tableName);
        }
        String sql = "DELETE FROM " + tableName + " WHERE AD_Client_ID=" + this.getAD_Client_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        String msg = Msg.translate((Ctx)this.getCtx(), (String)(tableName + "_ID")) + " #" + no;
        return msg;
    }
}

