/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class ImportOrder
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_docAction = "PR";
    private Timestamp m_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.m_docAction = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE FROM I_Order WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Order SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        String ts = DB.isPostgreSQL() ? "COALESCE(I_ErrorMsg,'')" : "I_ErrorMsg";
        sql = new StringBuffer("UPDATE I_Order o SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Org, '" + "WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0" + " OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PO DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SO DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType IN ('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid DocTypeName, ' " + "WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid DocTypeName=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PO Default DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SO Default DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType IN('SOO','POO') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default DocType=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No DocType, ' " + "WHERE C_DocType_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No DocType=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET IsSOTrx='Y' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set IsSOTrx=Y=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET IsSOTrx='N' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set IsSOTrx=N=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y' AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y' AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No PriceList, ' " + "WHERE M_PriceList_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PriceList=" + no);
        }
        Language language = Language.getLoginLanguage();
        String AD_Language = language.getAD_Language();
        sql = new StringBuffer("UPDATE I_Order O SET PaymentRule= (SELECT R.value   FROM AD_Ref_List R   left outer join AD_Ref_List_Trl RT   on RT.AD_Ref_List_ID = R.AD_Ref_List_ID and RT.AD_Language = ?   WHERE R.AD_Reference_ID = 195 and coalesce( RT.Name, R.Name ) = O.PaymentRuleName ) WHERE PaymentRule is null AND PaymentRuleName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (Object[])new Object[]{AD_Language}, (boolean)false, (String)this.get_TrxName());
        this.log.fine("Set PaymentRule=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p WHERE o.PaymentTermValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND o.PaymentTermValue IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No PaymentTerm, ' " + "WHERE C_PaymentTerm_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PaymentTerm=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Order o SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID AND o.AD_Org_ID=w.AD_Org_ID) WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Order o SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID) WHERE M_Warehouse_ID IS NULL AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=o.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1) AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set Only Client Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No Warehouse, ' " + "WHERE M_Warehouse_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.EMail=u.EMail AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND EMail IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from EMail=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND ContactName IS NOT NULL AND EXISTS (SELECT Name FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL GROUP BY Name HAVING COUNT(*)=1) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from ContactName=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.BPartnerValue=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from Value=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_BPartner_ID=(SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo c WHERE o.AD_Client_ID=c.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NULL AND Name IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default BP=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET (BillTo_ID,C_BPartner_Location_ID)=(SELECT C_BPartner_Location_ID,C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE o.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=o.AD_Client_ID AND DUMP(o.Address1)=DUMP(l.Address1) AND DUMP(o.Address2)=DUMP(l.Address2) AND DUMP(o.City)=DUMP(l.City) AND DUMP(o.Postal)=DUMP(l.Postal) AND DUMP(o.C_Region_ID)=DUMP(l.C_Region_ID) AND DUMP(o.C_Country_ID)=DUMP(l.C_Country_ID)) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Location=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET BillTo_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID AND ((l.IsBillTo='Y' AND o.IsSOTrx='Y') OR (l.IsPayFrom='Y' AND o.IsSOTrx='N'))) WHERE C_BPartner_ID IS NOT NULL AND BillTo_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP BillTo from BP=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET C_BPartner_Location_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID AND ((l.IsShipTo='Y' AND o.IsSOTrx='Y') OR o.IsSOTrx='N')) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP Location from BP=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No BP Location, ' " + "WHERE C_BPartner_ID IS NOT NULL AND (BillTo_ID IS NULL OR C_BPartner_Location_ID IS NULL)" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No BP Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE o.CountryCode=c.CountryCode AND c.IsSummary='N' AND c.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND CountryCode IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Country, ' " + "WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Country=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuffer("UPDATE I_Order o Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=o.RegionName AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Region, ' " + "WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL " + " AND EXISTS (SELECT * FROM C_Country c" + " WHERE c.C_Country_ID=o.C_Country_ID AND c.HasRegion='Y')" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Region=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.UPC=p.UPC AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from UPC=" + no);
        sql = new StringBuffer("UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.SKU=p.SKU AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND SKU IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product fom SKU=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Product, ' " + "WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL)" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        sql = new StringBuffer("UPDATE I_Order o SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Tax=" + no);
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Tax, ' " + "WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Tax=" + no);
        }
        this.commit();
        sql = new StringBuffer("SELECT * FROM I_Order WHERE I_IsImported='N' AND C_BPartner_ID IS NULL").append(clientCheck);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MBPartner bp;
                X_I_Order imp = new X_I_Order(this.getCtx(), rs, this.get_TrxName());
                if (imp.getBPartnerValue() == null) {
                    if (imp.getEMail() != null) {
                        imp.setBPartnerValue(imp.getEMail());
                    } else {
                        if (imp.getName() == null) continue;
                        imp.setBPartnerValue(imp.getName());
                    }
                }
                if (imp.getName() == null) {
                    if (imp.getContactName() != null) {
                        imp.setName(imp.getContactName());
                    } else {
                        imp.setName(imp.getBPartnerValue());
                    }
                }
                if ((bp = MBPartner.get(this.getCtx(), imp.getBPartnerValue())) == null) {
                    bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                    bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    bp.setValue(imp.getBPartnerValue());
                    bp.setName(imp.getName());
                    if (!bp.save()) continue;
                }
                imp.setC_BPartner_ID(bp.getC_BPartner_ID());
                MBPartnerLocation bpl = null;
                MBPartnerLocation[] bpls = bp.getLocations(true);
                for (int i2 = 0; bpl == null && i2 < bpls.length; ++i2) {
                    MLocation loc;
                    if (imp.getC_BPartner_Location_ID() == bpls[i2].getC_BPartner_Location_ID()) {
                        bpl = bpls[i2];
                        continue;
                    }
                    if (imp.getC_Location_ID() == bpls[i2].getC_Location_ID()) {
                        bpl = bpls[i2];
                        continue;
                    }
                    if (imp.getC_Location_ID() != 0 || !(loc = bpl.getLocation(false)).equals(imp.getC_Country_ID(), imp.getC_Region_ID(), imp.getPostal(), "", imp.getCity(), imp.getAddress1(), imp.getAddress2())) continue;
                    bpl = bpls[i2];
                }
                if (bpl == null) {
                    MLocation loc = new MLocation(this.getCtx(), 0, this.get_TrxName());
                    loc.setAddress1(imp.getAddress1());
                    loc.setAddress2(imp.getAddress2());
                    loc.setCity(imp.getCity());
                    loc.setPostal(imp.getPostal());
                    if (imp.getC_Region_ID() != 0) {
                        loc.setC_Region_ID(imp.getC_Region_ID());
                    }
                    loc.setC_Country_ID(imp.getC_Country_ID());
                    if (!loc.save()) continue;
                    bpl = new MBPartnerLocation(bp);
                    bpl.setC_Location_ID(imp.getC_Location_ID());
                    if (!bpl.save()) continue;
                }
                imp.setC_Location_ID(bpl.getC_Location_ID());
                imp.setBillTo_ID(bpl.getC_BPartner_Location_ID());
                imp.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                if (imp.getContactName() != null || imp.getEMail() != null || imp.getPhone() != null) {
                    MUser[] users = bp.getContacts(true);
                    MUser user = null;
                    for (int i3 = 0; user == null && i3 < users.length; ++i3) {
                        String name = users[i3].getName();
                        if (!name.equals(imp.getContactName()) && !name.equals(imp.getName())) continue;
                        user = users[i3];
                        imp.setAD_User_ID(user.getAD_User_ID());
                    }
                    if (user == null) {
                        user = new MUser((X_C_BPartner)bp);
                        if (imp.getContactName() == null) {
                            user.setName(imp.getName());
                        } else {
                            user.setName(imp.getContactName());
                        }
                        user.setEMail(imp.getEMail());
                        user.setPhone(imp.getPhone());
                        if (user.save()) {
                            imp.setAD_User_ID(user.getAD_User_ID());
                        }
                    }
                }
                imp.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=No BPartner, ' " + "WHERE C_BPartner_ID IS NULL" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No BPartner=" + no);
        }
        this.commit();
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_Order WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID, I_Order_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int oldC_BPartner_ID = 0;
            int oldBillTo_ID = 0;
            int oldC_BPartner_Location_ID = 0;
            String oldDocumentNo = "";
            MOrder order = null;
            int lineNo = 0;
            while (rs.next()) {
                X_I_Order imp = new X_I_Order(this.getCtx(), rs, this.get_TrxName());
                String cmpDocumentNo = imp.getDocumentNo();
                if (cmpDocumentNo == null) {
                    cmpDocumentNo = "";
                }
                if (oldC_BPartner_ID != imp.getC_BPartner_ID() || oldC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || oldBillTo_ID != imp.getBillTo_ID() || !oldDocumentNo.equals(cmpDocumentNo)) {
                    if (order != null) {
                        if (this.m_docAction != null && this.m_docAction.length() > 0) {
                            order.setDocAction(this.m_docAction);
                            order.processIt(this.m_docAction);
                        }
                        order.save();
                    }
                    oldC_BPartner_ID = imp.getC_BPartner_ID();
                    oldC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                    oldBillTo_ID = imp.getBillTo_ID();
                    oldDocumentNo = imp.getDocumentNo();
                    if (oldDocumentNo == null) {
                        oldDocumentNo = "";
                    }
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    order.setC_DocTypeTarget_ID(imp.getC_DocType_ID());
                    order.setIsSOTrx(imp.isSOTrx());
                    if (imp.getDocumentNo() != null) {
                        order.setDocumentNo(imp.getDocumentNo());
                    }
                    order.setC_BPartner_ID(imp.getC_BPartner_ID());
                    order.setC_BPartner_Location_ID(imp.getC_BPartner_Location_ID());
                    if (imp.getAD_User_ID() != 0) {
                        order.setAD_User_ID(imp.getAD_User_ID());
                    }
                    order.setBill_BPartner_ID(imp.getC_BPartner_ID());
                    order.setBill_Location_ID(imp.getBillTo_ID());
                    if (imp.getDescription() != null) {
                        order.setDescription(imp.getDescription());
                    }
                    if (imp.getPaymentRule() != null) {
                        order.setPaymentRule(imp.getPaymentRule());
                    }
                    order.setC_PaymentTerm_ID(imp.getC_PaymentTerm_ID());
                    order.setM_PriceList_ID(imp.getM_PriceList_ID());
                    order.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                    if (imp.getM_Shipper_ID() != 0) {
                        order.setM_Shipper_ID(imp.getM_Shipper_ID());
                    }
                    if (imp.getSalesRep_ID() != 0) {
                        order.setSalesRep_ID(imp.getSalesRep_ID());
                    }
                    if (order.getSalesRep_ID() == 0) {
                        order.setSalesRep_ID(this.getAD_User_ID());
                    }
                    if (imp.getAD_OrgTrx_ID() != 0) {
                        order.setAD_OrgTrx_ID(imp.getAD_OrgTrx_ID());
                    }
                    if (imp.getC_Activity_ID() != 0) {
                        order.setC_Activity_ID(imp.getC_Activity_ID());
                    }
                    if (imp.getC_Campaign_ID() != 0) {
                        order.setC_Campaign_ID(imp.getC_Campaign_ID());
                    }
                    if (imp.getC_Project_ID() != 0) {
                        order.setC_Project_ID(imp.getC_Project_ID());
                    }
                    if (imp.getDateOrdered() != null) {
                        order.setDateOrdered(imp.getDateOrdered());
                    }
                    if (imp.getDateAcct() != null) {
                        order.setDateAcct(imp.getDateAcct());
                    }
                    if (!order.save()) {
                        String msg = "Could not save Order";
                        ValueNamePair pp = CLogger.retrieveError();
                        if (pp != null) {
                            msg = msg + " - " + pp.toStringX();
                        }
                        imp.setI_ErrorMsg(msg);
                        imp.save();
                        continue;
                    }
                    ++noInsert;
                    lineNo = 10;
                }
                imp.setC_Order_ID(order.getC_Order_ID());
                MOrderLine line = new MOrderLine(order);
                line.setLine(lineNo);
                lineNo += 10;
                boolean convertUOM = false;
                if (imp.getM_Product_ID() != 0 && imp.getC_UOM_ID() != 0) {
                    line.setM_Product_ID(imp.getM_Product_ID(), imp.getC_UOM_ID());
                    convertUOM = line.getProduct().getC_UOM_ID() != imp.getC_UOM_ID();
                } else if (imp.getM_Product_ID() != 0) {
                    line.setM_Product_ID(imp.getM_Product_ID(), true);
                    convertUOM = false;
                }
                if (convertUOM) {
                    BigDecimal rateQty = MUOMConversion.getProductRateFrom(this.getCtx(), line.getM_Product_ID(), imp.getC_UOM_ID());
                    if (rateQty == null) {
                        String msg = Msg.translate((Ctx)this.getCtx(), (String)"NoProductUOMConversion");
                        imp.setI_ErrorMsg(msg);
                        imp.save();
                        continue;
                    }
                    line.setQtyEntered(imp.getQtyOrdered());
                    line.setQtyOrdered(imp.getQtyOrdered().multiply(rateQty));
                    line.setPrice();
                    if (imp.getPriceActual().compareTo(Env.ZERO) != 0) {
                        line.setPriceEntered(imp.getPriceActual());
                        line.setPriceActual(imp.getPriceActual().divide(rateQty, 12, 4));
                    }
                } else {
                    line.setQty(imp.getQtyOrdered());
                    line.setPrice();
                    if (imp.getPriceActual().compareTo(Env.ZERO) != 0) {
                        line.setPrice(imp.getPriceActual());
                    }
                }
                if (imp.getC_Tax_ID() != 0) {
                    line.setC_Tax_ID(imp.getC_Tax_ID());
                } else {
                    line.setTax();
                    imp.setC_Tax_ID(line.getC_Tax_ID());
                }
                if (imp.getFreightAmt() != null) {
                    line.setFreightAmt(imp.getFreightAmt());
                }
                if (imp.getLineDescription() != null) {
                    line.setDescription(imp.getLineDescription());
                }
                if (!line.save()) {
                    String msg = "Could not save OrderLine";
                    ValueNamePair pp = CLogger.retrieveError();
                    if (pp != null) {
                        msg = msg + " - " + pp.toStringX();
                    }
                    imp.setI_ErrorMsg(msg);
                    imp.save();
                    continue;
                }
                imp.setC_OrderLine_ID(line.getC_OrderLine_ID());
                imp.setI_IsImported("Y");
                imp.setProcessed(true);
                if (!imp.save()) continue;
                ++noInsertLine;
            }
            if (order != null) {
                if (this.m_docAction != null && this.m_docAction.length() > 0) {
                    order.setDocAction(this.m_docAction);
                    order.processIt(this.m_docAction);
                }
                order.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Order - " + sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Order SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Order_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@C_OrderLine_ID@: @Inserted@");
        return "#" + noInsert + "/" + noInsertLine;
    }
}

