/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MRequest;
import org.compiere.model.X_I_Request;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

public class ImportRequest
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE FROM I_Request WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET AD_Client_ID = (SELECT AD_Client_ID FROM AD_Client c WHERE c.Value = r.ClientValue),  ClientName = (SELECT Name FROM AD_Client c WHERE c.Value = r.ClientValue),  Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND AD_Client_ID is NULL AND ClientValue is NOT NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Set client from key =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET AD_Client_ID = (SELECT AD_Client_ID FROM AD_Client c WHERE c.Name = r.ClientName),  ClientValue = (SELECT Value FROM AD_Client c WHERE c.Name = r.ClientName), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND AD_Client_ID is NULL AND ClientName is NOT NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Set client from name =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET AD_Org_ID = (SELECT AD_Org_ID FROM AD_Org o WHERE o.Value = r.OrgValue),  OrgName = (SELECT Name FROM AD_Org o WHERE o.Value = r.OrgValue),  Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND (AD_Org_ID is NULL OR AD_Org_ID =0) AND OrgValue is NOT NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Set org from key =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET AD_Org_ID = (SELECT AD_Org_ID FROM AD_Org o WHERE o.Name = r.OrgName),  OrgValue = (SELECT Value FROM AD_Org o WHERE o.Name = r.OrgName),  Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND (AD_Org_ID is NULL OR AD_Org_ID =0) AND OrgName is NOT NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Set Org from name =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        String ts = DB.isPostgreSQL() ? "COALESCE(I_ErrorMsg,'')" : "I_ErrorMsg";
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Org, '" + "WHERE (AD_Org_ID IS NULL " + " OR NOT EXISTS (SELECT * FROM AD_Org oo WHERE r.AD_Org_ID=oo.AD_Org_ID AND oo.IsSummary='N' AND oo.IsActive='Y'))" + " AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_RequestType_ID =  (SELECT R_RequestType_ID FROM R_RequestType rt WHERE rt.Name = r.ReqTypeName) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_RequestType_ID is NULL AND r.ReqTypeName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set RequestType=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid RequestTypeName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_RequestType_ID is NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid ReqType=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_Group_ID =  (SELECT R_Group_ID FROM R_Group g WHERE g.Name = r.GroupName) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_Group_ID is NULL AND r.GroupName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid GroupName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_Group_ID is NULL" + " AND r.GroupName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid GroupName=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_Category_ID =  (SELECT R_Category_ID FROM R_Category c WHERE c.Name = r.CategoryName) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_Category_ID is NULL AND r.CategoryName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Category=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid CategoryName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_Category_ID is NULL" + " AND r.CategoryName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid CategoryName=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_Status_ID =  (SELECT R_Status_ID FROM R_Status s, R_StatusCategory sc, R_RequestType t  WHERE s.Name = r.StatusName and t.R_RequestType_ID = r.R_RequestType_ID and t.R_StatusCategory_ID = sc.R_StatusCategory_ID AND s.R_StatusCategory_ID = sc.R_StatusCategory_ID) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_Status_ID is NULL AND r.StatusName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Status=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid StatusName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_Status_ID is NULL" + " AND r.StatusName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Status=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_Resolution_ID =  (SELECT R_Resolution_ID FROM R_Resolution rr  WHERE rr.Name = r.ResolutionName ) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_Resolution_ID is NULL AND r.ResolutionName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Resolution=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid ResolutionName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_Resolution_ID is NULL" + " AND r.ResolutionName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Resolution=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Summary, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.Summary is NULL").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Summary=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_BPartner_ID = (SELECT C_BPartner_ID FROM C_BPartner b WHERE b.Value=r.BPartnerValue AND b.AD_Client_ID=r.AD_Client_ID ),  BPartnerName=(SELECT Name FROM C_BPartner b WHERE b.Value=r.BPartnerValue AND b.AD_Client_ID=r.AD_Client_ID ) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BPartner from BPartnerKey=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner b WHERE b.Name=r.BpartnerName AND b.AD_Client_ID=r.AD_Client_ID ),  BPartnerValue=(SELECT Value FROM C_BPartner b WHERE b.Name=r.BpartnerName AND b.AD_Client_ID=r.AD_Client_ID ) WHERE C_BPartner_ID IS NULL AND BPartnerName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BPartner from BPartnerName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Bpartner, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_BPartner_ID is NULL" + " AND (r.BPartnerName is NOT NULL OR r.BPartnerValue IS NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid BPartner=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET AD_User_ID =(SELECT AD_User_ID FROM AD_User u WHERE r.ContactValue=u.Value AND r.AD_Client_ID=u.AD_Client_ID AND u.C_Bpartner_ID = r.C_BPartner_ID),  ContactName =(SELECT Name FROM AD_User u WHERE r.ContactValue=u.Value AND r.AD_Client_ID=u.AD_Client_ID AND u.C_Bpartner_ID = r.C_BPartner_ID)  WHERE AD_User_ID IS NULL AND ContactValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set User from UserKey=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET AD_User_ID=(SELECT AD_User_ID FROM AD_User u WHERE r.ContactName=u.Name AND r.AD_Client_ID=u.AD_Client_ID AND u.C_Bpartner_ID = r.C_BPartner_ID ), ContactValue =(SELECT Value FROM AD_User u WHERE r.ContactName=u.Name AND r.AD_Client_ID=u.AD_Client_ID AND u.C_Bpartner_ID = r.C_BPartner_ID ) WHERE AD_User_ID IS NULL AND ContactName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set User from UserName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid User, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND (" + " (r.AD_User_ID is NULL AND (r.ContactName is NOT NULL OR r.ContactValue IS NOT NULL))" + " OR (r.AD_User_ID is NOT NULL AND NOT EXISTS" + "(SELECT 1 FROM AD_USER u WHERE u.AD_User_ID = r.AD_User_ID " + " AND r.AD_Client_ID=u.AD_Client_ID AND u.C_Bpartner_ID = r.C_BPartner_ID)))").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid User=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET SalesRep_ID = (SELECT AD_User_ID FROM AD_User u WHERE r.SalesRepValue=u.Value AND r.AD_Client_ID=u.AD_Client_ID ),  SalesRepName = (SELECT name FROM AD_User u WHERE r.SalesRepValue=u.Value AND r.AD_Client_ID=u.AD_Client_ID ) WHERE SalesRep_ID IS NULL AND SalesRepValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SalesRep from SalesRepValue=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET SalesRep_ID = (SELECT AD_User_ID FROM AD_User u WHERE r.SalesRepName=u.Name AND r.AD_Client_ID=u.AD_Client_ID ),  SalesRepValue =(SELECT  value FROM AD_User u WHERE r.SalesRepName=u.Name AND r.AD_Client_ID=u.AD_Client_ID ) WHERE SalesRep_ID IS NULL AND SalesRepName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SalesRep from SalesRepName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Representative, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.SalesRep_ID is NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid SalesRep=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET AD_Table_ID =  (SELECT AD_Table_ID FROM AD_Table t  WHERE t.Name = r.TableName ) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.AD_Table_ID is NULL AND r.TableName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Table=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid TableName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.AD_Table_ID is NULL" + " AND r.TableName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Table=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_RequestRelated_ID =  (SELECT R_Request_ID FROM R_Request rr  WHERE rr.DocumentNo = r.RequestRelatedDocNo ) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.R_RequestRelated_ID is NULL AND r.RequestRelatedDocNo is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Resolution=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Rel, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_RequestRelated_ID is NULL" + " AND r.RequestRelatedDocNo is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid RelatedRequest=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET R_Source_ID = (SELECT R_Source_ID FROM R_Source s WHERE r.SourceValue=s.Value AND r.AD_Client_ID=s.AD_Client_ID ),  SourceName = (SELECT name FROM R_Source s WHERE r.SourceValue=s.Value AND r.AD_Client_ID=s.AD_Client_ID ) WHERE R_Source_ID IS NULL AND SourceValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Source from SourceValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET R_Source_ID=(SELECT R_Source_ID FROM R_Source s WHERE r.SourceName=s.Name AND r.AD_Client_ID=s.AD_Client_ID ),  SourceValue = (SELECT value FROM R_Source s WHERE r.SourceName=s.Name AND r.AD_Client_ID=s.AD_Client_ID )  WHERE R_Source_ID IS NULL AND SourceName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Source from SourceName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Source, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.R_Source_ID IS NULL" + " AND (r.SourceName IS NOT NULL OR r.SourceValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Source=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET AD_Role_ID =  (SELECT AD_Role_ID FROM AD_Role ar  WHERE ar.Name = r.RoleName ) WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND r.AD_Role_ID is NULL AND r.RoleName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Role=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid RoleName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.AD_Role_ID is NULL" + " AND r.RoleName is NOT NULL").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Role=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET M_ProductSpent_ID=(SELECT M_Product_ID FROM M_Product m WHERE r.ProductSpentValue=m.Value AND r.AD_Client_ID=m.AD_Client_ID ),  ProductSpentName =(SELECT Name FROM M_Product m WHERE r.ProductSpentValue=m.Value AND r.AD_Client_ID=m.AD_Client_ID )  WHERE M_ProductSpent_ID IS NULL AND ProductSpentValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set ProductSpent from ProductSpentValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET M_ProductSpent_ID = (SELECT M_Product_ID FROM M_Product m WHERE r.ProductSpentName=m.Name AND r.AD_Client_ID=m.AD_Client_ID ),  ProductSpentValue =(SELECT Value FROM M_Product m WHERE r.ProductSpentName=m.Name AND r.AD_Client_ID=m.AD_Client_ID ) WHERE M_ProductSpent_ID IS NULL AND ProductSpentName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set ProductSpent from ProductSpentValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid ProductSpent, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.M_ProductSpent_ID IS NULL" + " AND (r.productSpentName IS NOT NULL OR r.ProductSpentValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid ProductSpent=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Activity_ID=(SELECT C_Activity_ID FROM C_Activity a WHERE r.ActivityValue=a.Value AND r.AD_Client_ID=a.AD_Client_ID ),  ActivityName=(SELECT Name FROM C_Activity a WHERE r.ActivityValue=a.Value AND r.AD_Client_ID=a.AD_Client_ID ) WHERE C_Activity_ID IS NULL AND ActivityValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Activity from ActivityValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_Activity_ID = (SELECT C_Activity_ID FROM C_Activity a WHERE r.ActivityName=a.Name AND r.AD_Client_ID=a.AD_Client_ID ),  ActivityValue =(SELECT Value FROM C_Activity a WHERE r.ActivityName=a.Name AND r.AD_Client_ID=a.AD_Client_ID ) WHERE C_Activity_ID IS NULL AND ActivityName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Activity from ActivityName =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Activity, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Activity_ID IS NULL" + " AND (r.ActivityName IS NOT NULL OR r.ActivityValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Activity=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_BPartnerSR_ID=(SELECT C_BPartner_ID FROM C_BPartner b WHERE b.Value=r.BPartnerSRValue AND b.AD_Client_ID=r.AD_Client_ID AND isSalesRep='Y'),  BPartnerSRName =(SELECT Name FROM C_BPartner b WHERE b.Value=r.BPartnerSRValue AND b.AD_Client_ID=r.AD_Client_ID AND isSalesRep='Y') WHERE C_BPartnerSR_ID IS NULL AND BPartnerSRValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BPartnerSR from BPartnerSRKey=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_BPartnerSR_ID=(SELECT C_BPartner_ID FROM C_BPartner b WHERE b.Name=r.BPartnerSRName AND b.AD_Client_ID=r.AD_Client_ID AND isSalesRep='Y'),  BPartnerSRValue =(SELECT value FROM C_BPartner b WHERE b.Name=r.BPartnerSRName AND b.AD_Client_ID=r.AD_Client_ID AND isSalesRep='Y') WHERE C_BPartnerSR_ID IS NULL AND BPartnerSRName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BPartnerSR from BPartnerSRName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Bpartner(Agent), ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND ((r.C_BPartnerSR_ID is NULL AND (r.BPartnerSRName is NOT NULL OR r.BPartnerSRValue IS NOT NULL))" + " OR (r.C_BPartnerSR_ID is NOT NULL AND " + " NOT EXISTS (SELECT 1 from C_BPartner b WHERE b.C_BPartner_ID = r.C_BPartnerSR_ID" + " AND b.AD_Client_ID=r.AD_Client_ID AND isSalesRep='Y')))").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid BPartner (Agent)=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r  SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p WHERE p.Value=r.ProjectValue AND p.AD_Client_ID=r.AD_Client_ID ),  ProjectName=(SELECT Name FROM C_Project p WHERE p.Value=r.ProjectValue AND p.AD_Client_ID=r.AD_Client_ID )  WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Project from ProjectKey=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p WHERE p.Name=r.ProjectName AND p.AD_Client_ID=r.AD_Client_ID ),  ProjectValue=(SELECT Value FROM C_Project p WHERE p.Name=r.ProjectName AND p.AD_Client_ID=r.AD_Client_ID )  WHERE C_Project_ID IS NULL AND ProjectName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Project from ProjectName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Project, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Project_ID is NULL" + " AND (r.ProjectName is NOT NULL OR r.ProjectValue IS NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Project=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET A_Asset_ID=(SELECT A_Asset_ID FROM A_Asset a WHERE a.Value=r.AssetValue AND a.AD_Client_ID=r.AD_Client_ID ),  AssetName =(SELECT Name FROM A_Asset a WHERE a.Value=r.AssetValue AND a.AD_Client_ID=r.AD_Client_ID )  WHERE A_Asset_ID IS NULL AND AssetValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Asset from AssetKey=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET A_Asset_ID=(SELECT A_Asset_ID FROM A_Asset a WHERE a.Name=r.AssetName AND a.AD_Client_ID=r.AD_Client_ID ),  AssetValue=(SELECT Value FROM A_Asset a WHERE a.Name=r.AssetName AND a.AD_Client_ID=r.AD_Client_ID )  WHERE A_Asset_ID IS NULL AND AssetName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Asset from AssetName=" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Asset, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.A_Asset_ID is NULL" + " AND (r.AssetName is NOT NULL OR r.AssetValue IS NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Asset=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET M_Product_ID=(SELECT M_Product_ID FROM M_Product m WHERE r.ProductValue=m.Value AND r.AD_Client_ID=m.AD_Client_ID ),  ProductName=(SELECT Name FROM M_Product m WHERE r.ProductValue=m.Value AND r.AD_Client_ID=m.AD_Client_ID ) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from ProductValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET M_Product_ID =(SELECT M_Product_ID FROM M_Product m WHERE r.ProductName=m.Name AND r.AD_Client_ID=m.AD_Client_ID ),  ProductValue =(SELECT Value FROM M_Product m WHERE r.ProductName=m.Name AND r.AD_Client_ID=m.AD_Client_ID ) WHERE M_Product_ID IS NULL AND ProductName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from ProductName =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid ProductSpent, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.M_Product_ID IS NULL" + " AND (r.productName IS NOT NULL OR r.ProductValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign c WHERE r.CampaignValue=c.Value AND r.AD_Client_ID=c.AD_Client_ID ),  CampaignName =(SELECT Name FROM C_Campaign c WHERE r.CampaignValue=c.Value AND r.AD_Client_ID=c.AD_Client_ID ) WHERE C_Campaign_ID IS NULL AND CampaignValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Campaign from CampaignValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_Campaign_ID =(SELECT C_Campaign_ID FROM C_Campaign c WHERE r.CampaignName=c.Name AND r.AD_Client_ID=c.AD_Client_ID ),  CampaignValue =(SELECT Value FROM C_Campaign c WHERE r.CampaignName=c.Name AND r.AD_Client_ID=c.AD_Client_ID ) WHERE C_Campaign_ID IS NULL AND CampaignName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Campaign from CampaignValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid Campaign, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Campaign_ID IS NULL" + " AND (r.CampaignName IS NOT NULL OR r.CampaignValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Campaign=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_SalesRegion_ID=(SELECT C_SalesRegion_ID FROM C_SalesRegion s WHERE r.SalesRegionValue=s.Value AND r.AD_Client_ID=s.AD_Client_ID ),  SalesRegionName=(SELECT Name FROM C_SalesRegion s WHERE r.SalesRegionValue=s.Value AND r.AD_Client_ID=s.AD_Client_ID ) WHERE C_SalesRegion_ID IS NULL AND SalesRegionValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SalesRegion from SalesRegionValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET C_SalesRegion_ID=(SELECT C_SalesRegion_ID FROM C_SalesRegion s WHERE r.SalesRegionName=s.Name AND r.AD_Client_ID=s.AD_Client_ID ),  SalesRegionValue=(SELECT SalesRegionValue FROM C_SalesRegion s WHERE r.SalesRegionName=s.Name AND r.AD_Client_ID=s.AD_Client_ID ) WHERE C_SalesRegion_ID IS NULL AND SalesRegionName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set SalesRegion from SalesRegionValue =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid SalesRegion, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_SalesRegion_ID IS NULL" + " AND (r.SalesRegionName IS NOT NULL OR r.SalesRegionValue is NOT NULL)").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid SalesRegion=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Order_ID =(SELECT C_Order_ID FROM C_Order o WHERE r.OrderDocumentNo = o.DocumentNo AND r.AD_Client_ID=o.AD_Client_ID ) WHERE C_Order_ID IS NULL AND OrderDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Order from OrderDocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid OrderDocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Order_ID IS NULL" + " AND r.OrderDocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid OrderDocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Invoice_ID =(SELECT C_Invoice_ID FROM C_Invoice i WHERE r.InvoiceDocumentNo = i.DocumentNo AND r.AD_Client_ID=i.AD_Client_ID ) WHERE C_Invoice_ID IS NULL AND InvoiceDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Invoice from InvoiceDocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid InvoiceDocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Invoice_ID IS NULL" + " AND r.InvoiceDocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid InvoiceDocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Payment_ID =(SELECT C_Payment_ID FROM C_Payment p WHERE r.PaymentDocumentNo = p.DocumentNo AND r.AD_Client_ID=p.AD_Client_ID ) WHERE C_Payment_ID IS NULL AND PaymentDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Payment from PaymentDocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid PaymentDocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Payment_ID IS NULL" + " AND r.PaymentDocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid PaymentDocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET M_InOut_ID =(SELECT M_InOut_ID FROM M_InOut i WHERE r.InOutDocumentNo = i.DocumentNo AND r.AD_Client_ID=i.AD_Client_ID ) WHERE M_InOut_ID IS NULL AND InOutDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Shipment/Receipt from InOutDocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid InOutDocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.M_InOut_ID IS NULL" + " AND r.InOutDocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid InOutDocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET M_RMA_ID =(SELECT M_RMA_ID FROM M_RMA rm WHERE r.RMADocumentNo = rm.DocumentNo AND r.AD_Client_ID=rm.AD_Client_ID ) WHERE M_RMA_ID IS NULL AND RMADocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Order from RMADocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid RMADocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.M_RMA_ID IS NULL" + " AND r.RMADocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid RMADocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET C_Lead_ID =(SELECT C_Lead_ID FROM C_Lead l WHERE r.LeadDocumentNo = l.DocumentNo AND r.AD_Client_ID=l.AD_Client_ID ) WHERE C_Lead_ID IS NULL AND LeadDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Lead from LeadDocumentNo =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid LeadDocumentNo, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.C_Lead_ID IS NULL" + " AND r.LeadDocumentNo IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid LeadDocumentNo=" + no);
        }
        sql = new StringBuffer("UPDATE I_Request r SET M_ChangeRequest_ID =(SELECT M_ChangeRequest_ID FROM M_ChangeRequest c WHERE r.ChangeRequestName = c.Name AND r.AD_Client_ID=c.AD_Client_ID ) WHERE M_ChangeRequest_ID IS NULL AND ChangeRequestName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set ChangeRequest from ChangeRequestName =" + no);
        sql = new StringBuffer("UPDATE I_Request r SET I_IsImported='E', I_ErrorMsg=" + ts + "||'ERR=Invalid ChangeRequestName, ' " + " WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL)" + " AND r.M_ChangeRequest_ID IS NULL" + " AND r.ChangeRequestName IS NOT NULL ").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid ChangeRequestName=" + no);
        }
        this.commit();
        int noInsert = 0;
        int noProcessed = 0;
        sql = new StringBuffer("SELECT * FROM I_Request WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY DocumentNo, I_Request_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            String oldDocumentNo = "";
            MRequest request = null;
            while (rs.next()) {
                X_I_Request imp = new X_I_Request(this.getCtx(), rs, this.get_TrxName());
                request = new MRequest(imp);
                if (!request.save()) {
                    String msg = "Could not save Request";
                    ValueNamePair pp = CLogger.retrieveError();
                    if (pp != null) {
                        msg = msg + " - " + pp.toStringX();
                    }
                    imp.setI_ErrorMsg(msg);
                    imp.save();
                    continue;
                }
                ++noProcessed;
                imp.setR_Request_ID(request.getR_Request_ID());
                imp.setI_IsImported("Y");
                imp.setProcessed(true);
                imp.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Order - " + sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Request SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noProcessed), " @Processed@");
        return "#" + noInsert + "/" + noProcessed;
    }

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }
}

